from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.api.v2010.account.sip.ip_access_control_list.ip_address import IpAddressList as IpAddressList
from typing import Any, Optional

class IpAccessControlListList(ListResource):
    def __init__(self, version: Any, account_sid: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, friendly_name: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class IpAccessControlListPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class IpAccessControlListContext(InstanceContext):
    def __init__(self, version: Any, account_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, friendly_name: Any): ...
    def delete(self): ...
    @property
    def ip_addresses(self): ...

class IpAccessControlListInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, account_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def subresource_uris(self): ...
    @property
    def uri(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any): ...
    def delete(self): ...
    @property
    def ip_addresses(self): ...
