from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.api.v2010.account.incoming_phone_number.assigned_add_on import AssignedAddOnList as AssignedAddOnList
from twilio.rest.api.v2010.account.incoming_phone_number.local import LocalList as LocalList
from twilio.rest.api.v2010.account.incoming_phone_number.mobile import MobileList as MobileList
from twilio.rest.api.v2010.account.incoming_phone_number.toll_free import TollFreeList as TollFreeList
from typing import Any, Optional

class IncomingPhoneNumberList(ListResource):
    def __init__(self, version: Any, account_sid: Any) -> None: ...
    def stream(self, beta: Any = ..., friendly_name: Any = ..., phone_number: Any = ..., origin: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, beta: Any = ..., friendly_name: Any = ..., phone_number: Any = ..., origin: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, beta: Any = ..., friendly_name: Any = ..., phone_number: Any = ..., origin: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, api_version: Any = ..., friendly_name: Any = ..., sms_application_sid: Any = ..., sms_fallback_method: Any = ..., sms_fallback_url: Any = ..., sms_method: Any = ..., sms_url: Any = ..., status_callback: Any = ..., status_callback_method: Any = ..., voice_application_sid: Any = ..., voice_caller_id_lookup: Any = ..., voice_fallback_method: Any = ..., voice_fallback_url: Any = ..., voice_method: Any = ..., voice_url: Any = ..., emergency_status: Any = ..., emergency_address_sid: Any = ..., trunk_sid: Any = ..., identity_sid: Any = ..., address_sid: Any = ..., voice_receive_mode: Any = ..., bundle_sid: Any = ..., phone_number: Any = ..., area_code: Any = ...): ...
    @property
    def local(self): ...
    @property
    def mobile(self): ...
    @property
    def toll_free(self): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class IncomingPhoneNumberPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class IncomingPhoneNumberContext(InstanceContext):
    def __init__(self, version: Any, account_sid: Any, sid: Any) -> None: ...
    def update(self, account_sid: Any = ..., api_version: Any = ..., friendly_name: Any = ..., sms_application_sid: Any = ..., sms_fallback_method: Any = ..., sms_fallback_url: Any = ..., sms_method: Any = ..., sms_url: Any = ..., status_callback: Any = ..., status_callback_method: Any = ..., voice_application_sid: Any = ..., voice_caller_id_lookup: Any = ..., voice_fallback_method: Any = ..., voice_fallback_url: Any = ..., voice_method: Any = ..., voice_url: Any = ..., emergency_status: Any = ..., emergency_address_sid: Any = ..., trunk_sid: Any = ..., voice_receive_mode: Any = ..., identity_sid: Any = ..., address_sid: Any = ..., bundle_sid: Any = ...): ...
    def fetch(self): ...
    def delete(self): ...
    @property
    def assigned_add_ons(self): ...

class IncomingPhoneNumberInstance(InstanceResource):
    class AddressRequirement:
        NONE: str = ...
        ANY: str = ...
        LOCAL: str = ...
        FOREIGN: str = ...
    class EmergencyStatus:
        ACTIVE: str = ...
        INACTIVE: str = ...
    class VoiceReceiveMode:
        VOICE: str = ...
        FAX: str = ...
    def __init__(self, version: Any, payload: Any, account_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def address_sid(self): ...
    @property
    def address_requirements(self): ...
    @property
    def api_version(self): ...
    @property
    def beta(self): ...
    @property
    def capabilities(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def friendly_name(self): ...
    @property
    def identity_sid(self): ...
    @property
    def phone_number(self): ...
    @property
    def origin(self): ...
    @property
    def sid(self): ...
    @property
    def sms_application_sid(self): ...
    @property
    def sms_fallback_method(self): ...
    @property
    def sms_fallback_url(self): ...
    @property
    def sms_method(self): ...
    @property
    def sms_url(self): ...
    @property
    def status_callback(self): ...
    @property
    def status_callback_method(self): ...
    @property
    def trunk_sid(self): ...
    @property
    def uri(self): ...
    @property
    def voice_receive_mode(self): ...
    @property
    def voice_application_sid(self): ...
    @property
    def voice_caller_id_lookup(self): ...
    @property
    def voice_fallback_method(self): ...
    @property
    def voice_fallback_url(self): ...
    @property
    def voice_method(self): ...
    @property
    def voice_url(self): ...
    @property
    def emergency_status(self): ...
    @property
    def emergency_address_sid(self): ...
    @property
    def bundle_sid(self): ...
    @property
    def status(self): ...
    def update(self, account_sid: Any = ..., api_version: Any = ..., friendly_name: Any = ..., sms_application_sid: Any = ..., sms_fallback_method: Any = ..., sms_fallback_url: Any = ..., sms_method: Any = ..., sms_url: Any = ..., status_callback: Any = ..., status_callback_method: Any = ..., voice_application_sid: Any = ..., voice_caller_id_lookup: Any = ..., voice_fallback_method: Any = ..., voice_fallback_url: Any = ..., voice_method: Any = ..., voice_url: Any = ..., emergency_status: Any = ..., emergency_address_sid: Any = ..., trunk_sid: Any = ..., voice_receive_mode: Any = ..., identity_sid: Any = ..., address_sid: Any = ..., bundle_sid: Any = ...): ...
    def fetch(self): ...
    def delete(self): ...
    @property
    def assigned_add_ons(self): ...
