from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class ParticipantList(ListResource):
    def __init__(self, version: Any, account_sid: Any, conference_sid: Any) -> None: ...
    def create(self, from_: Any, to: Any, status_callback: Any = ..., status_callback_method: Any = ..., status_callback_event: Any = ..., label: Any = ..., timeout: Any = ..., record: Any = ..., muted: Any = ..., beep: Any = ..., start_conference_on_enter: Any = ..., end_conference_on_exit: Any = ..., wait_url: Any = ..., wait_method: Any = ..., early_media: Any = ..., max_participants: Any = ..., conference_record: Any = ..., conference_trim: Any = ..., conference_status_callback: Any = ..., conference_status_callback_method: Any = ..., conference_status_callback_event: Any = ..., recording_channels: Any = ..., recording_status_callback: Any = ..., recording_status_callback_method: Any = ..., sip_auth_username: Any = ..., sip_auth_password: Any = ..., region: Any = ..., conference_recording_status_callback: Any = ..., conference_recording_status_callback_method: Any = ..., recording_status_callback_event: Any = ..., conference_recording_status_callback_event: Any = ..., coaching: Any = ..., call_sid_to_coach: Any = ..., jitter_buffer_size: Any = ..., byoc: Any = ..., caller_id: Any = ..., call_reason: Any = ...): ...
    def stream(self, muted: Any = ..., hold: Any = ..., coaching: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, muted: Any = ..., hold: Any = ..., coaching: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, muted: Any = ..., hold: Any = ..., coaching: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, call_sid: Any): ...
    def __call__(self, call_sid: Any): ...

class ParticipantPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ParticipantContext(InstanceContext):
    def __init__(self, version: Any, account_sid: Any, conference_sid: Any, call_sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, muted: Any = ..., hold: Any = ..., hold_url: Any = ..., hold_method: Any = ..., announce_url: Any = ..., announce_method: Any = ..., wait_url: Any = ..., wait_method: Any = ..., beep_on_exit: Any = ..., end_conference_on_exit: Any = ..., coaching: Any = ..., call_sid_to_coach: Any = ...): ...
    def delete(self): ...

class ParticipantInstance(InstanceResource):
    class Status:
        QUEUED: str = ...
        CONNECTING: str = ...
        RINGING: str = ...
        CONNECTED: str = ...
        COMPLETE: str = ...
        FAILED: str = ...
    def __init__(self, version: Any, payload: Any, account_sid: Any, conference_sid: Any, call_sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def call_sid(self): ...
    @property
    def label(self): ...
    @property
    def call_sid_to_coach(self): ...
    @property
    def coaching(self): ...
    @property
    def conference_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def end_conference_on_exit(self): ...
    @property
    def muted(self): ...
    @property
    def hold(self): ...
    @property
    def start_conference_on_enter(self): ...
    @property
    def status(self): ...
    @property
    def uri(self): ...
    def fetch(self): ...
    def update(self, muted: Any = ..., hold: Any = ..., hold_url: Any = ..., hold_method: Any = ..., announce_url: Any = ..., announce_method: Any = ..., wait_url: Any = ..., wait_method: Any = ..., beep_on_exit: Any = ..., end_conference_on_exit: Any = ..., coaching: Any = ..., call_sid_to_coach: Any = ...): ...
    def delete(self): ...
