from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.api.v2010.account.address import AddressList as AddressList
from twilio.rest.api.v2010.account.application import ApplicationList as ApplicationList
from twilio.rest.api.v2010.account.authorized_connect_app import AuthorizedConnectAppList as AuthorizedConnectAppList
from twilio.rest.api.v2010.account.available_phone_number import AvailablePhoneNumberCountryList as AvailablePhoneNumberCountryList
from twilio.rest.api.v2010.account.balance import BalanceList as BalanceList
from twilio.rest.api.v2010.account.call import CallList as CallList
from twilio.rest.api.v2010.account.conference import ConferenceList as ConferenceList
from twilio.rest.api.v2010.account.connect_app import ConnectAppList as ConnectAppList
from twilio.rest.api.v2010.account.incoming_phone_number import IncomingPhoneNumberList as IncomingPhoneNumberList
from twilio.rest.api.v2010.account.key import KeyList as KeyList
from twilio.rest.api.v2010.account.message import MessageList as MessageList
from twilio.rest.api.v2010.account.new_key import NewKeyList as NewKeyList
from twilio.rest.api.v2010.account.new_signing_key import NewSigningKeyList as NewSigningKeyList
from twilio.rest.api.v2010.account.notification import NotificationList as NotificationList
from twilio.rest.api.v2010.account.outgoing_caller_id import OutgoingCallerIdList as OutgoingCallerIdList
from twilio.rest.api.v2010.account.queue import QueueList as QueueList
from twilio.rest.api.v2010.account.recording import RecordingList as RecordingList
from twilio.rest.api.v2010.account.short_code import ShortCodeList as ShortCodeList
from twilio.rest.api.v2010.account.signing_key import SigningKeyList as SigningKeyList
from twilio.rest.api.v2010.account.sip import SipList as SipList
from twilio.rest.api.v2010.account.token import TokenList as TokenList
from twilio.rest.api.v2010.account.transcription import TranscriptionList as TranscriptionList
from twilio.rest.api.v2010.account.usage import UsageList as UsageList
from twilio.rest.api.v2010.account.validation_request import ValidationRequestList as ValidationRequestList
from typing import Any, Optional

class AccountList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, friendly_name: Any = ...): ...
    def stream(self, friendly_name: Any = ..., status: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, friendly_name: Any = ..., status: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, friendly_name: Any = ..., status: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class AccountPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class AccountContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., status: Any = ...): ...
    @property
    def addresses(self): ...
    @property
    def applications(self): ...
    @property
    def authorized_connect_apps(self): ...
    @property
    def available_phone_numbers(self): ...
    @property
    def balance(self): ...
    @property
    def calls(self): ...
    @property
    def conferences(self): ...
    @property
    def connect_apps(self): ...
    @property
    def incoming_phone_numbers(self): ...
    @property
    def keys(self): ...
    @property
    def messages(self): ...
    @property
    def new_keys(self): ...
    @property
    def new_signing_keys(self): ...
    @property
    def notifications(self): ...
    @property
    def outgoing_caller_ids(self): ...
    @property
    def queues(self): ...
    @property
    def recordings(self): ...
    @property
    def signing_keys(self): ...
    @property
    def sip(self): ...
    @property
    def short_codes(self): ...
    @property
    def tokens(self): ...
    @property
    def transcriptions(self): ...
    @property
    def usage(self): ...
    @property
    def validation_requests(self): ...

class AccountInstance(InstanceResource):
    class Status:
        ACTIVE: str = ...
        SUSPENDED: str = ...
        CLOSED: str = ...
    class Type:
        TRIAL: str = ...
        FULL: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def auth_token(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def friendly_name(self): ...
    @property
    def owner_account_sid(self): ...
    @property
    def sid(self): ...
    @property
    def status(self): ...
    @property
    def subresource_uris(self): ...
    @property
    def type(self): ...
    @property
    def uri(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., status: Any = ...): ...
    @property
    def addresses(self): ...
    @property
    def applications(self): ...
    @property
    def authorized_connect_apps(self): ...
    @property
    def available_phone_numbers(self): ...
    @property
    def balance(self): ...
    @property
    def calls(self): ...
    @property
    def conferences(self): ...
    @property
    def connect_apps(self): ...
    @property
    def incoming_phone_numbers(self): ...
    @property
    def keys(self): ...
    @property
    def messages(self): ...
    @property
    def new_keys(self): ...
    @property
    def new_signing_keys(self): ...
    @property
    def notifications(self): ...
    @property
    def outgoing_caller_ids(self): ...
    @property
    def queues(self): ...
    @property
    def recordings(self): ...
    @property
    def signing_keys(self): ...
    @property
    def sip(self): ...
    @property
    def short_codes(self): ...
    @property
    def tokens(self): ...
    @property
    def transcriptions(self): ...
    @property
    def usage(self): ...
    @property
    def validation_requests(self): ...
