"""
Make standalone interactive heatmap for time series data

This sub-package provides a module that can be imported as a Python
module, and a command line interface entry point.


Application program interface
-----------------------------
>>> import xplorts.heatmap


Command line interface
----------------------
> python -m xplorts.heatmap --help
"""

# Export names from .heatmap.heatmap.
from .heatmap import (figheatmap, addheatmap,
                      jscb_set_from_selection, ts_categorical_figure)

__all__ = ["figheatmap", "addheatmap",
           "jscb_set_from_selection", "ts_categorical_figure"]
