# -*- coding: utf-8 -*-

from edxml.event import ParsedEvent
from edxml.event_validator import EventValidator
from edxml.ontology import Ontology

from lxml import etree
from typing import Union, List, Type, BinaryIO


class ProcessingInterrupted(Exception):
    pass


class EDXMLParserBase(object):

    _VISITED_TAGS = ...
    _LXML_PARSER_OPTIONS = ...

    def __init__(self, validate: bool=True) -> None:
        super().__init__()

        self._ontology = ...                # type: Ontology
        self._element_iterator = ...         # type: etree.Element
        self._event_class = ...

        self.__previous_event = ...  # type: etree.Element
        self.__root_element = ...
        self.__parsing = ...
        self.__parsed_initial_ontology = ...
        self.__num_parsed_events = ...
        self.__num_parsed_event_types = ...
        self.__event_type_handlers = ...
        self.__event_source_handlers = ...
        self.__current_event_handlers = ...
        self.__source_uri_pattern_map = ...
        self.__schema = ...
        self.__event_type_schema_cache = ...
        self.__event_type_schema = ...
        self.__validate = ...
        self.__validator = ...  # type: EventValidator

    def close(self) -> 'EDXMLParserBase': ...

    def _close(self) -> 'EDXMLParserBase': ...

    def set_event_type_handler(self, event_types: List[str], handler: callable) -> 'EDXMLParserBase': ...

    def set_event_source_handler(self, source_patterns: List[str], handler: callable) -> 'EDXMLParserBase': ...

    def set_custom_event_class(self, event_class: Type[etree.ElementBase]) -> 'EDXMLParserBase': ...

    def get_event_counter(self) -> int: ...

    def get_event_type_counter(self, event_type_name) -> int: ...

    def get_ontology(self) -> Ontology: ...

    def __find_root_element(self, event_element: etree.Element) -> None: ...

    def __validate_ontology_element(self) -> None: ...

    def __process_ontology(self, ontology_element: etree.Element) -> None: ...

    def _parsed_ontology(self, ontology: Ontology) -> None: ...

    def _parse_edxml(self) -> None: ...

    def __parse_event(self, event: ParsedEvent) -> None: ...

    def _init(self) -> None: ...

    def _check_element_is_event_property(self, elem: etree.Element) -> None: ...

    def _get_event_handlers(self, event_type_name: str, event_source_id: str) -> List[callable]: ...

    def _parsed_event(self, event: ParsedEvent) -> None: ...

    def _parsed_foreign_element(self, element: ParsedEvent) -> None: ...

class EDXMLPullParser(EDXMLParserBase):

    def parse(self, input_file: Union[BinaryIO, str],
              foreign_element_tags: List[str]=()) -> 'EDXMLPullParser': ...


class EDXMLPushParser(EDXMLParserBase):

    def __init__(self, validate: bool = True) -> None:
        super().__init__(validate)
        self.__input_parser = ... # type: etree.XMLPullParser
        self.__foreign_element_tags = ... # type: List

    def feed(self, data: bytes) -> None: ...


class EDXMLOntologyPullParser(EDXMLPullParser):
    ...


class EDXMLOntologyPushParser(EDXMLPushParser):
    ...
