import os
import streamlit as st
import streamlit.components.v1 as components
import base64



_RELEASE = True

if _RELEASE:

    root_dir = os.path.dirname(os.path.abspath(__file__))
    build_dir = os.path.join(root_dir, "frontend/build")

    _on_hover_tabs = components.declare_component(
        "st_on_machine_data",
        path = build_dir
    )

else:
    _on_hover_tabs = components.declare_component(
    "on_machine_data",
    url="http://localhost:3001"
    )

def on_machine_data(menu, group_names, text_groups,summaries,topics,generated_number_groups, word_cloud_image, default_choice=1, key=None):
    
    component_value = _on_hover_tabs(menu=menu, group_names=group_names, text_groups=text_groups,summaries=summaries,topics=topics,generated_number_groups=generated_number_groups, word_cloud_image=word_cloud_image, key=key)
    
    return component_value

if not _RELEASE:
    st.markdown('<style>' + open('./style.css').read() + '</style>', unsafe_allow_html=True) # Load the on hover side bar css file
    WORD_CLOUD_IMAGE = ""
    with open("wordcloud.jpg", "rb") as img_file:
        WORD_CLOUD_IMAGE = base64.b64encode(img_file.read())
    #print(WORD_CLOUD_IMAGE)
    group_names=['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12']
    
    text_groups=[
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
        ['Group 1', 'Group 2', 'Group 3', 'Group 4', 'Group 5', 'Group 6', 'Group 7', 'Group 8', 'Group 9', 'Group 10', 'Group 11', 'Group 12'],
    ]
    
    topics=['Map printers to access card', 'Change phone replacement policy', 'Keep shades open', 'Dim lights/screens', 'Turn off lights', 'Turn off automatic lights-on', 'Print after scanning badge', 'Reduce decorative lights', 'Reduce screen time out', 'Digitalize expenses', 'Ban soda cans', 'Office engagement', 'Reduce hard documents', 'Work from home', 'Stop cans', 'Automatic screen off', 'Ban canned water', 'Passcode printing', 'Digital business cards', 'Lights out day', 'Paperless culture', 'Phone access building', 'Commute outside peak hours.'], ['Sowing seeds challenge', 'Get more plants for office', 'Sustainability focused social activity', 'Volunteer day to plant trees', 'Rebuy @ Bain Platform', 'Climate activists lectures', 'Green teams outreach', 'Oxygen Rich Plant', 'Office-wide volunteering days', 'Eco foundations products', 'Carbon footprint sign', 'Ecosystem with environmental players', 'Green web hosting', 'Earth Day events', 'Plant a tree month', 'Car-free day', 'Monthly sustainability newsletter', 'Vegan education', 'Zero Defect for Zero Waste', 'Second hand/ circular economy', 'Volunteer day', 'Earth Day celebration', 'Plant a tree initiative', 'Carbon footprint assessment', 'Eco challenge', 'Meat production impact', 'Social media presence for climate', 'Plants in office', 'Climate day training', 'Low-carbon competition', 'Tree planting events.'], ['Serve as a farm share pickup point for employees (CSA)', 'Reduce meat consumption', 'Donate leftover food after events', 'No meat in office canteen or Bain events', 'Sustainable packing options for catered lunch', 'Tie-up with Robinhood Army or other similar groups', 'Celebrate vegetarianism', 'Have 2 days per week in which the canteen only offers vegetarian options', 'Create competitions for vegetarian slides', 'Share vegetarian/vegan recipe options', 'Vegan catering by default', 'Turning the cafe food waste into compost', 'focus on catering meals from restaurants focused on sustainability', 'Weekly update on how much food was thrown away in the fridge', 'Reduce food delivery by increasing meal budget', 'Dinners with 100% vegetarian dishes', 'Eliminate soft drinks in cans and coconut water in plastic bottles', 'More snacks in offices that have less plastic wrapping', 'Carbon production labels on food in the cafeteria', 'Put a weighing gear below the container having wet food waste', 'Collaborate with an NGO that can deal with food waste', 'Subsidized vegetables subscription service to homes', 'Friday office meals can be vegetarian every other week', 'Partner with Too Good To Go', 'Reduce footprint of food and drinks in local offices', 'Propose more vegetarian/vegan options', 'Limit expensing meals that include beef', 'Vegan cooking classes', 'Training meals become fully vegetarian', 'Celebrate employees who adhere to vegetarianism', 'Eliminate plastic wrapped snacks', 'Carbon positive snacks/beverages', 'Order groceries if working from home late', 'Donate daily food leftovers to the homeless', 'More vegan options/restaurants at events', 'Vegetarian as default', 'meat upon request', 'Highlight food wasted', 'Enable grocery expensing', 'Incentivize teams to spend their team lunch budget on vegetarian food', 'Vegetarian lunch challenges', 'Making Food Rescue more widespread', 'Discounts at vegetarian places.'], ['Co-financing public transport', 'Incentivize using public transport', 'ACT/NCT program', 'Office-wide online portal', 'Electric car shuttles', 'Carpool commute', 'Reduce flights', 'Shuttle bus services', 'Reward for limiting taxis', 'Public transport allowance', 'Banning short taxi trips', 'Eco-friendly airlines/cabs', 'Local offices', 'Reduce internal meetings', 'Uber Green/Lyft Green', 'Public transport promotion', 'Reduce commute & client travel', 'Sustainable aviation fuel', 'Electric cars', 'Sustainable commute', 'Carpooling', 'Air travel guidelines', 'Train travel', 'Public transport passes', 'Carpooling solutions', 'Sustainable transport', 'Charging for parking', 'Cycle rides', 'Travel incentives', 'Permanent work from home', 'Carbon intensive routes.'], ['Have another cup issue and cup decorating', 'Happy Hour', 'Allow employees time to take reusable boxes/containers to restaurants', 'Kombucha and Asahi on tap', 'Reusable glasses or ceramic cups', 'Encouraging second-hand clothing use', 'Add sustainable pads/tampons', 'Give each employee a Bain waterbottle', 'Return used electronics', 'Reusable dishware', 'Avoid heavily/unnecessarily packaged foods', 'Create list of preferred restaurants/kitchens', 'Provide coffee mugs', 'Bain waterbottles', 'Reduce plastic usage', 'Pack lunch', 'Reusable shopping bags', 'Reduce food waste', 'Non-disposable cups', 'Reusable cutlery', 'Terracycle boxes', 'Recyclable boxes', 'Infographics', 'Metal cutlery', 'Reusable nametags', 'Reuse stationery', 'Ecofriendly creme/soap refillers', 'Donation drives', 'Reused water', 'Coffee mugs', 'Second hand market', 'Recycled paper', 'Recyclable kitchen supplies', 'Reusable to go containers', 'Sodastream machines', 'Reusable silverware and plates.'], ['Target sustainability', 'Incorporate sustainability as KPI', 'Access to app/tech support', 'Climate-related events', 'Sustainable material/method for deliverables', 'Education panels', 'Virtual roadshow', 'Carbon emissions records', 'Incentivize low/no travel projects', 'Environmental issues', 'Outside vendors for waste reduction', 'Carbon credits', 'Sourcing from decarbonization practices', 'Metrics/compliance for offset system', 'Environmental performance of projects', 'Monitor flights', 'Print document case codes', 'US-wide sustainability competition', 'Keynote speaker sustainability', 'Company clothes', 'Speaker sessions from climate-related clients', 'Carbon calculator', 'Carbon footprint measurement challenge', 'Newspaper subscriptions', 'Carbon footprint assessments', 'Feedback on individual carbon footprints', 'Green sourcing', '10 minutes of meetings for sustainability topics', 'Speaker sessions from climate-related clients', 'Carbon calculator', 'Carbon footprint measurement challenge', 'Newspaper subscriptions', 'Carbon footprint assessments', 'Feedback on individual carbon footprints', 'Green sourcing', '10 minutes of meetings for sustainability topics', 'ESG-focused news sources', 'Sustainable clothing/fashion/skincare', 'Case team sustainability contest', 'Speaker on climate change', 'ESG-focused news sources', 'Sustainable clothing/fashion/skincare', 'Case team sustainability contest', 'Speaker on climate change', 'Sustainability Result Challenge', 'CO2 tracker', 'Internal events', 'Carbon offsets', 'Monthly podcasts.'], ['Reducing paper tissues', 'thermostat temperature', 'motion sensors', 'smart shades', 'WFH days', 'electricity saving tips', 'energy saving systems', 'dishwasher scheduling', 'heat recovery systems', 'hand dryers', 'energy saving light-bulbs', 'power-strips', 'motion-activated lights', 'temperature resistant windows', 'HVAC settings', 'sensor lights', 'water temperature', 'air filters', 'Eco Office Umbrella Dryer', 'increasing temperature', 'environmental footprint tips.'], ['Raccolta differenziata', 'trasporti', 'emissioni', 'limitare viaggi aerei', 'Roma-Milano', 'voli', 'tempo risparmiato', 'comodità', 'lavorare durante viaggio', 'disincentivare voli', 'orari "indifferenti vs treni"', 'autorizzazione Case Manager', 'contributo € per offsettare CO2', 'ridurre spreco confezioni', 'involucri colazione', 'sostituire sacchetto carta', 'Green Team', 'viaggi aerei', 'emissioni in eccesso', 'Travel Route Exception.'], ['Beehive Hosting', 'Beekeeper Maintenance', 'Customizable Honey', 'Sponsor Opportunities', 'Photovoltaic Windows/Roofs', 'Rooftop Beekeeping Programme', 'Fresh Air at Offices', 'Bain Garden on Roofs', 'Indoor Plants', 'Bain Veg Patch', 'Sustainable Suppliers', 'Terrace/Roof/Outside Space Usage'], ['Provide credits that employees can put towards green transpiration', 'Promote cycle to work scheme', 'Switch all Bain cars to electric vehicles', 'Divvy bike membership included', 'Monetary/other incentives for travelling green', 'Possibility to rent a bike', 'Bike to work incentives', 'Encourage employees to walk/cycle to work', 'Santander Cycle/Lime/Dott subscriptions', 'Incentives/subsidies for electric rides', 'Allow only e-vehicles in Bain garage', 'Office-wide bike-to-work challenge', 'Buy EVs for next car', 'Subsidized bike share memberships', 'Incentivise Bainies to travel on the train', 'Reduced emissions options', 'Invest in sustainable transportation', 'Bike/e-bike subsidies', 'Carpooling app', 'Fly less incentives', 'Allow fitness reimbursements for bike shares', 'Points system for sustainable transportation', 'Buy plants allowance', 'Low-emission commuting benefits', 'Bike lane uprising', 'Only E-taxis', 'POD competition', 'EV subsidy', 'Stipend for green commuters', 'Walk/bike/public transport day', 'Carpooling app', 'EV subsidy', 'Steps challenge', 'Green choices incentivization', 'Lower carbon travel incentives', 'Free hire bicycles', 'Vouchers for bike rental', 'Live on walking distance', 'Train incentives', 'Carbon-free options subsidies.'], ['Recycling non-biodegradable components', 'Waste separation', 'Composting in the office', 'Start a recycling program', 'Share impact of initiatives', 'Seperate garbage systems', 'Compostable Trash Bags', 'Non-usage of products with single-use plastic', 'Raise recycling awareness', 'Composting/plant-related activities', 'More compost bins', 'Clearer info on what can be composted', 'Compost office leftovers', 'Bare-minimum standards for office services', 'Reminder of sustainability tips', 'More recycling bins', 'Separating biodegradable/non-biodegradable waste', 'Prohibit the usage of plastic', 'Garbage recycling', 'Report composted pounds/benefits', 'Separate compost bin for Sweetgreen', 'Stop usage of small packaged water', 'Posters about different types of plastic', 'Incentives to use less', 'Circulate information on proper recycling', 'Environmentally friendly contracts', '"Talking rubbish" recycling tips', 'Tracker of plastic use', 'Paper bags instead of plastic.'], ['ESG', 'ESG DD', 'ESG upskilling', 'Rewards', 'Communication', 'ESG courses', 'Visibility', 'ESG Ringfence', 'ESG Analytical Tools', 'Trainings', 'ESG Surcharge', 'ESG Cases', 'ESG Case Competitions', 'Global Rotation', 'Decarbonization', 'Donations', 'Volunteering', 'Dashboard', 'ESG Commitments', 'Pro Bono Case Target.']
    
    
    summaries=[['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
               ['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
               ['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
               ['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
               ['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
               ['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
               ['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
               ['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
               ['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
               ['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
               ['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
               ['This text outlines various strategies for reducing energy consumption in the office, such as mapping printers to employee access cards, dimming lights and screens, utilizing natural light, turning off lights and screens at the end of the day, banning soda cans, implementing paperless systems, and promoting competition. It also suggests working from home and encouraging employees to commute to the office outside of peak hours.', ' Bain is launching a challenge for employees to run for a month, in which they need to sow seeds, post pictures of the growth, and show blooming flowers in the fourth week. Winners will receive green kits with organic seeds and plants. Additionally, Bain will offer sustainability-focused social activities, pro-bono projects to help reduce environmental footprints, green team liaisons, lectures from climate activists, volunteer days to plant trees, green team swag, sustainability learning sessions, green web hosting, Earth Day events, green team challenges, plant a tree initiatives, sustainability mornings, eco challenges, group volunteer activities, low-carbon competitions, and tree-planting events. They will also educate employees on vegan diets, provide pro-bono consulting for energy startups, offer volunteer days, provide 0% financing for green investments, encourage physical exercise outdoors, encourage second-hand shopping, and celebrate Earth Day.', ' This text outlines a variety of initiatives to reduce meat consumption and increase sustainability in the workplace. These include providing a farm share pickup point for employees, delivering produce boxes from local farms, offering vegetarian options for all hands, office meetings, and global trainings, donating leftover food, offering vegan cooking classes, celebrating vegetarianism, providing vegan catering, composting food waste, partnering with organizations that fight food waste, sourcing local and seasonal products, limiting the expansibility of beef-based meals, and incentivizing teams to spend their team lunch budget on vegetarian food.', 'This text discusses various strategies to reduce carbon emissions related to employee and client travel. Strategies include incentivizing public transport, providing shuttle buses, reducing flights, offering commuter benefits, carpooling, using sustainable aviation fuel, and allowing permanent work from home.', 'This text suggests a variety of sustainable measures that can be taken in offices to reduce waste, such as providing reusable containers, water bottles, and mugs; organizing clothing swaps; replacing disposable utensils with metal cutlery; using recyclable paper and boxes; offering reusable shopping bags; using terracycle boxes; encouraging the use of personal mugs; using furniture made from recycled material; hosting donation drives; and replacing cans with soda water machines.', ' This text discusses various ways that a company can proactively target sustainability topics, such as incorporating sustainability as a KPI in case work, providing access to tech support to understand their impact, holding office-wide climate-related events, defining sustainable materials/methods for deliverables, conducting webinars and seminars on sustainability topics, tracking environmental performance of projects, monitoring flights, having outside vendors focus on waste reduction, buying carbon credits, sourcing materials from vendors who follow decarbonization practices, setting up a CO2 tracker, having internal events locally, and training on carbon offsets.', ' This text outlines various strategies to reduce energy consumption in the office. These strategies include removing paper hand towels from washrooms and emphasizing usage of electric hand dryers, lowering the air temperature, installing motion sensors to control lights and HVAC, using green building structure, installing heat recovery systems, using energy saving light-bulbs, raising the AC temperature, having lights, monitors, and TVs turn off more aggressively, and creating campaigns to decrease paper tissue usage.', ' Questo testo discute di come un gruppo possa ridurre le proprie emissioni di CO2. Suggerisce di sostituire i cestini indifferenziati con cestini per la raccolta differenziata, di limitare i viaggi in aereo sulla tratta Roma-Milano e di disincentivare i voli dopo le 8 del mattino e prima delle 9 di sera. Inoltre, si raccomanda di ridurre lo spreco di confezioni e involucri per la colazione.', ' This text discusses ways for companies to be more sustainable, such as hosting a beehive on office grounds, installing photovoltaic windows, launching a rooftop beekeeping program, creating a terrace for employees to get fresh air, and placing more indoor plants. It also suggests creating a Bain garden on roofs of offices, and a Bain veg patch that could be used in a town square.', ' This text discusses various initiatives to promote green transportation for employees, such as providing credits for green transportation, promoting cycle to work schemes, switching to electric vehicles, providing bike memberships and incentives, creating a bike-to-work challenge, offering extra vacation days for slower, more carbon-friendly modes of transportation, offering allowances for purchasing plants, providing benefits for low-emission commuting, creating a carpooling app, offering e-bike discounts, electric vehicle incentives, walk/bike/public transport day, steps challenge with money prizes, incentivizing green choices, incentives for lower carbon travel, providing free bike hire, vouchers for bike rental, increasing incentives for taking the train instead of flying, and increasing subsidies for staff who choose carbon-free options.', ' This text outlines various initiatives to reduce waste in an office setting. It suggests educational sessions on what should go in each type of trash bin, collaborating with Bain Active to run something similar to the CID beach cleanup, composting in the office, waste separation, introducing compostable trash bags, discouraging the purchase of products with single-use plastic, implementing a personal monitoring tool, raising recycling awareness, composting and plant-related activities, having more compost bins, clearer info on what can be composted, composting office leftovers, introducing bare-minimum standards for office services, reminding people of sustainability tips, having more recycling bins, separating biodegradable and non-biodegradable waste, prohibiting the usage of plastic, garbage recycling, getting a separate compost bin for Sweetgreen containers, stopping the usage of small packaged water, enforcing the different types of bins, including posters about the different types of plastic, incentives to use less, circulating information on proper recycling, setting up recycling vending machines, making requests on environmentally friendly cleaning products and services when setting up contracts, talking rubbish recycling tips, and setting up a tracker of how much plastic is used in a week.', ' This text outlines a number of initiatives that Bain & Company can take to promote sustainability, such as offering existing and new clients a free ESG DD, incorporating ESG upskilling into all trainings, rewarding clients who exemplify best ESG practices, communicating globally on ESG results, creating an ESG/sustainability "ringfence", using ESG analytical tools, bringing ESG experts to the office, making a dashboard, offering more trainings on sustainability, charging an ESG surcharge, setting a target for ESG cases per year, hosting ESG case competitions, and offering global rotation for ESG cases.'],
    ]
    generated_number_groups=12
    
    
    tabs = on_machine_data(menu=["World","Hello","Test"], 
                              group_names=group_names, 
                              text_groups=text_groups,
                              summaries=summaries,
                              topics=topics,
                              generated_number_groups=generated_number_groups,
                              word_cloud_image=WORD_CLOUD_IMAGE,
                              key="1") ## create tabs for on hover navigation bar
    
    print(tabs)





        
