# CEC User Control Codes, see:
# https://github.com/Pulse-Eight/libcec/blob/master/include/cectypes.h
# https://storage.googleapis.com/google-code-archive-downloads/v2/code.google.com/xtreamerdev/CEC_Specs.pdf
# (CEC Table 27: User Control Codes on page CEC-95 of 97)
KEYCODES = {
    'select':                       0x00,
    'up':                           0x01,
    'down':                         0x02,
    'left':                         0x03,
    'right':                        0x04,
    'right_up':                     0x05,
    'right_down':                   0x06,
    'left_up':                      0x07,
    'left_down':                    0x08,
    'root_menu':                    0x09,
    'setup_menu':                   0x0a,
    'contents_menu':                0x0b,
    'favorite_menu':                0x0c,
    'exit':                         0x0d,
    # reserved: 0x0e, 0x0f
    'top_menu':                     0x10,
    'dvd_menu':                     0x11,
    # reserved: 0x12 ... 0x1c
    'number_entry_mode':            0x1d,
    'number11':                     0x1e,
    'number12':                     0x1f,
    'number0':                      0x20,
    'number1':                      0x21,
    'number2':                      0x22,
    'number3':                      0x23,
    'number4':                      0x24,
    'number5':                      0x25,
    'number6':                      0x26,
    'number7':                      0x27,
    'number8':                      0x28,
    'number9':                      0x29,
    'dot':                          0x2a,
    'enter':                        0x2b,
    'clear':                        0x2c,
    'next_favorite':                0x2f,
    'channel_up':                   0x30,
    'channel_down':                 0x31,
    'previous_channel':             0x32,
    'sound_select':                 0x33,
    'input_select':                 0x34,
    'display_information':          0x35,
    'help':                         0x36,
    'page_up':                      0x37,
    'page_down':                    0x38,
    # reserved: 0x39 ... 0x3f
    'power':                        0x40,
    'volume_up':                    0x41,
    'volume_down':                  0x42,
    'mute':                         0x43,
    'play':                         0x44,
    'stop':                         0x45,
    'pause':                        0x46,
    'record':                       0x47,
    'rewind':                       0x48,
    'fast_forward':                 0x49,
    'eject':                        0x4a,
    'forward':                      0x4b,
    'backward':                     0x4c,
    'stop_record':                  0x4d,
    'pause_record':                 0x4e,
    # reserved: 0x4f
    'angle':                        0x50,
    'sub_picture':                  0x51,
    'video_on_demand':              0x52,
    'electronic_program_guide':     0x53,
    'timer_programming':            0x54,
    'initial_configuration':        0x55,
    'select_broadcast_type':        0x56,
    'select_sound_presentation':    0x57,
    # reserved: 0x58 ... 0x5f
    'play_function':                0x60,
    'pause_play_function':          0x61,
    'record_function':              0x62,
    'pause_record_function':        0x63,
    'stop_function':                0x64,
    'mute_function':                0x65,
    'restore_volume_function':      0x66,
    'tune_function':                0x67,
    'select_media_function':        0x68,
    'select_av_input_function':     0x69,
    'select_audio_input_function':  0x6a,
    'power_toggle_function':        0x6b,
    'power_off_function':           0x6c,
    'power_on_function':            0x6d,
    # reserved: 0x6e ... 0x70
    'f1':                           0x71,
    'f2':                           0x72,
    'f3':                           0x73,
    'f4':                           0x74,
    'f5':                           0x75,
    'data':                         0x76,
    # reserved: 0x77 ... 0xff
    'an_return':                    0x91,  # return (Samsung)
    'an_channels_list':             0x96,  # channels list (Samsung)
    'unknown':                      0xff,

    # convenience aliases:
    'ok':                           0x00,
    'back':                         0x0d,
    'blue':                         0x71,
    'red':                          0x72,
    'green':                        0x73,
    'yellow':                       0x74,
}
