"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackApprovalAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_apigateway_1 = require("@aws-cdk/aws-apigateway");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_sns_1 = require("@aws-cdk/aws-sns");
const aws_sns_subscriptions_1 = require("@aws-cdk/aws-sns-subscriptions");
const channel_types_1 = require("./channel-types");
class SlackApprovalAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 0,
                minOutputs: 0,
                maxOutputs: 0,
            },
        });
        this.props = props;
        this.props = props;
    }
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     */
    bound(scope, stage, options) {
        const environment = {
            SLACK_BOT_TOKEN: this.props.slackBotToken,
            SLACK_SIGNING_SECRET: this.props.slackSigningSecret,
            SLACK_CHANNEL: this.props.slackChannel,
            SLACK_CHANNEL_ID: this.props.slackChannelId,
            SLACK_CHANNEL_TYPES: (this.props.slackChannelTypes || [channel_types_1.ChannelTypes.PUBLIC]).join(','),
            SLACK_BOT_NAME: this.props.slackBotName || 'buildbot',
            SLACK_BOT_ICON: this.props.slackBotIcon || ':robot_face:',
        };
        const approvalRequester = new aws_lambda_1.Function(scope, 'SlackApprovalRequesterFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.asset(path.join(__dirname, 'lambdas', 'approval-requester')),
            environment,
        });
        const topic = new aws_sns_1.Topic(scope, 'SlackApprovalTopic');
        topic.grantPublish(options.role);
        topic.addSubscription(new aws_sns_subscriptions_1.LambdaSubscription(approvalRequester));
        const approvalHandler = new aws_lambda_1.Function(scope, 'SlackApprovalHandlerFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'approval-handler')),
            environment,
        });
        const api = new aws_apigateway_1.RestApi(scope, 'SlackApprovalApi');
        api.root.addProxy({
            defaultIntegration: new aws_apigateway_1.LambdaIntegration(approvalHandler),
        });
        approvalHandler.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ['codepipeline:PutApprovalResult'],
            resources: [`${stage.pipeline.pipelineArn}/${stage.stageName}/${this.props.actionName}`],
        }));
        return {
            configuration: {
                NotificationArn: topic.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            },
        };
    }
}
exports.SlackApprovalAction = SlackApprovalAction;
_a = JSII_RTTI_SYMBOL_1;
SlackApprovalAction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-slack.SlackApprovalAction", version: "1.28.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2xhY2stYXBwcm92YWwtYWN0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3NsYWNrLWFwcHJvdmFsLWFjdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZCQUE2QjtBQUM3Qiw0REFBcUU7QUFDckUsZ0VBQXVIO0FBQ3ZILGdGQUEyRDtBQUMzRCw4Q0FBbUQ7QUFDbkQsb0RBQThEO0FBQzlELDhDQUF5QztBQUN6QywwRUFBb0U7QUFHcEUsbURBQStDO0FBYy9DLE1BQWEsbUJBQW9CLFNBQVEsaUNBQU07SUFDN0MsWUFBMkIsS0FBK0I7UUFDeEQsS0FBSyxDQUFDO1lBQ0osR0FBRyxLQUFLO1lBQ1IsUUFBUSxFQUFFLGlDQUFjLENBQUMsUUFBUTtZQUNqQyxRQUFRLEVBQUUsUUFBUTtZQUNsQixjQUFjLEVBQUU7Z0JBQ2QsU0FBUyxFQUFFLENBQUM7Z0JBQ1osU0FBUyxFQUFFLENBQUM7Z0JBQ1osVUFBVSxFQUFFLENBQUM7Z0JBQ2IsVUFBVSxFQUFFLENBQUM7YUFDZDtTQUNGLENBQUMsQ0FBQztRQVhzQixVQUFLLEdBQUwsS0FBSyxDQUEwQjtRQWF4RCxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDOzs7Ozs7SUFFUyxLQUFLLENBQUMsS0FBZ0IsRUFBRSxLQUFhLEVBQUUsT0FBMEI7UUFDekUsTUFBTSxXQUFXLEdBQUc7WUFDbEIsZUFBZSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYTtZQUN6QyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFrQjtZQUNuRCxhQUFhLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFzQjtZQUNoRCxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGNBQXdCO1lBQ3JELG1CQUFtQixFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsSUFBSSxDQUFDLDRCQUFZLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO1lBQ3RGLGNBQWMsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksSUFBSSxVQUFVO1lBQ3JELGNBQWMsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksSUFBSSxjQUFjO1NBQzFELENBQUM7UUFFRixNQUFNLGlCQUFpQixHQUFHLElBQUkscUJBQVEsQ0FBQyxLQUFLLEVBQUUsZ0NBQWdDLEVBQUU7WUFDOUUsT0FBTyxFQUFFLG9CQUFPLENBQUMsV0FBVztZQUM1QixPQUFPLEVBQUUsZUFBZTtZQUN4QixJQUFJLEVBQUUsaUJBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLG9CQUFvQixDQUFDLENBQUM7WUFDdkUsV0FBVztTQUNaLENBQUMsQ0FBQztRQUVILE1BQU0sS0FBSyxHQUFHLElBQUksZUFBSyxDQUFDLEtBQUssRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO1FBQ3JELEtBQUssQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ2pDLEtBQUssQ0FBQyxlQUFlLENBQUMsSUFBSSwwQ0FBa0IsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7UUFFakUsTUFBTSxlQUFlLEdBQUcsSUFBSSxxQkFBUSxDQUFDLEtBQUssRUFBRSw4QkFBOEIsRUFBRTtZQUMxRSxPQUFPLEVBQUUsb0JBQU8sQ0FBQyxXQUFXO1lBQzVCLE9BQU8sRUFBRSxlQUFlO1lBQ3hCLElBQUksRUFBRSxpQkFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztZQUN6RSxXQUFXO1NBQ1osQ0FBQyxDQUFDO1FBRUgsTUFBTSxHQUFHLEdBQUcsSUFBSSx3QkFBTyxDQUFDLEtBQUssRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBQ25ELEdBQUcsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO1lBQ2hCLGtCQUFrQixFQUFFLElBQUksa0NBQWlCLENBQUMsZUFBZSxDQUFDO1NBQzNELENBQUMsQ0FBQztRQUVILGVBQWUsQ0FBQyxlQUFlLENBQzdCLElBQUkseUJBQWUsQ0FBQztZQUNsQixPQUFPLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQztZQUMzQyxTQUFTLEVBQUUsQ0FBQyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsV0FBVyxJQUFJLEtBQUssQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEVBQUUsQ0FBQztTQUN6RixDQUFDLENBQ0gsQ0FBQztRQUVGLE9BQU87WUFDTCxhQUFhLEVBQUU7Z0JBQ2IsZUFBZSxFQUFFLEtBQUssQ0FBQyxRQUFRO2dCQUMvQixVQUFVLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUI7Z0JBQzVDLGtCQUFrQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsa0JBQWtCO2FBQ2xEO1NBQ0YsQ0FBQztJQUNKLENBQUM7O0FBakVILGtEQWtFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBSZXN0QXBpLCBMYW1iZGFJbnRlZ3JhdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1hcGlnYXRld2F5JztcbmltcG9ydCB7IEFjdGlvbkNhdGVnb3J5LCBDb21tb25BY3Rpb25Qcm9wcywgSVN0YWdlLCBBY3Rpb25CaW5kT3B0aW9ucywgQWN0aW9uQ29uZmlnIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWNvZGVwaXBlbGluZSc7XG5pbXBvcnQgeyBBY3Rpb24gfSBmcm9tICdAYXdzLWNkay9hd3MtY29kZXBpcGVsaW5lLWFjdGlvbnMnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgeyBDb2RlLCBGdW5jdGlvbiwgUnVudGltZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgVG9waWMgfSBmcm9tICdAYXdzLWNkay9hd3Mtc25zJztcbmltcG9ydCB7IExhbWJkYVN1YnNjcmlwdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMtc3Vic2NyaXB0aW9ucyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuaW1wb3J0IHsgQ2hhbm5lbFR5cGVzIH0gZnJvbSAnLi9jaGFubmVsLXR5cGVzJztcblxuZXhwb3J0IGludGVyZmFjZSBTbGFja0FwcHJvdmFsQWN0aW9uUHJvcHMgZXh0ZW5kcyBDb21tb25BY3Rpb25Qcm9wcyB7XG4gIHJlYWRvbmx5IHNsYWNrQm90VG9rZW46IHN0cmluZztcbiAgcmVhZG9ubHkgc2xhY2tTaWduaW5nU2VjcmV0OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNsYWNrQ2hhbm5lbD86IHN0cmluZztcbiAgcmVhZG9ubHkgc2xhY2tDaGFubmVsSWQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNsYWNrQ2hhbm5lbFR5cGVzPzogQ2hhbm5lbFR5cGVzW107XG4gIHJlYWRvbmx5IHNsYWNrQm90TmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkgc2xhY2tCb3RJY29uPzogc3RyaW5nO1xuICByZWFkb25seSBhZGRpdGlvbmFsSW5mb3JtYXRpb24/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGV4dGVybmFsRW50aXR5TGluaz86IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIFNsYWNrQXBwcm92YWxBY3Rpb24gZXh0ZW5kcyBBY3Rpb24ge1xuICBwdWJsaWMgY29uc3RydWN0b3IocHJpdmF0ZSBwcm9wczogU2xhY2tBcHByb3ZhbEFjdGlvblByb3BzKSB7XG4gICAgc3VwZXIoe1xuICAgICAgLi4ucHJvcHMsXG4gICAgICBjYXRlZ29yeTogQWN0aW9uQ2F0ZWdvcnkuQVBQUk9WQUwsXG4gICAgICBwcm92aWRlcjogJ01hbnVhbCcsXG4gICAgICBhcnRpZmFjdEJvdW5kczoge1xuICAgICAgICBtaW5JbnB1dHM6IDAsXG4gICAgICAgIG1heElucHV0czogMCxcbiAgICAgICAgbWluT3V0cHV0czogMCxcbiAgICAgICAgbWF4T3V0cHV0czogMCxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLnByb3BzID0gcHJvcHM7XG4gIH1cblxuICBwcm90ZWN0ZWQgYm91bmQoc2NvcGU6IENvbnN0cnVjdCwgc3RhZ2U6IElTdGFnZSwgb3B0aW9uczogQWN0aW9uQmluZE9wdGlvbnMpOiBBY3Rpb25Db25maWcge1xuICAgIGNvbnN0IGVudmlyb25tZW50ID0ge1xuICAgICAgU0xBQ0tfQk9UX1RPS0VOOiB0aGlzLnByb3BzLnNsYWNrQm90VG9rZW4sXG4gICAgICBTTEFDS19TSUdOSU5HX1NFQ1JFVDogdGhpcy5wcm9wcy5zbGFja1NpZ25pbmdTZWNyZXQsXG4gICAgICBTTEFDS19DSEFOTkVMOiB0aGlzLnByb3BzLnNsYWNrQ2hhbm5lbCBhcyBzdHJpbmcsXG4gICAgICBTTEFDS19DSEFOTkVMX0lEOiB0aGlzLnByb3BzLnNsYWNrQ2hhbm5lbElkIGFzIHN0cmluZyxcbiAgICAgIFNMQUNLX0NIQU5ORUxfVFlQRVM6ICh0aGlzLnByb3BzLnNsYWNrQ2hhbm5lbFR5cGVzIHx8IFtDaGFubmVsVHlwZXMuUFVCTElDXSkuam9pbignLCcpLFxuICAgICAgU0xBQ0tfQk9UX05BTUU6IHRoaXMucHJvcHMuc2xhY2tCb3ROYW1lIHx8ICdidWlsZGJvdCcsXG4gICAgICBTTEFDS19CT1RfSUNPTjogdGhpcy5wcm9wcy5zbGFja0JvdEljb24gfHwgJzpyb2JvdF9mYWNlOicsXG4gICAgfTtcblxuICAgIGNvbnN0IGFwcHJvdmFsUmVxdWVzdGVyID0gbmV3IEZ1bmN0aW9uKHNjb3BlLCAnU2xhY2tBcHByb3ZhbFJlcXVlc3RlckZ1bmN0aW9uJywge1xuICAgICAgcnVudGltZTogUnVudGltZS5OT0RFSlNfMTBfWCxcbiAgICAgIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgICAgIGNvZGU6IENvZGUuYXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJ2xhbWJkYXMnLCAnYXBwcm92YWwtcmVxdWVzdGVyJykpLFxuICAgICAgZW52aXJvbm1lbnQsXG4gICAgfSk7XG5cbiAgICBjb25zdCB0b3BpYyA9IG5ldyBUb3BpYyhzY29wZSwgJ1NsYWNrQXBwcm92YWxUb3BpYycpO1xuICAgIHRvcGljLmdyYW50UHVibGlzaChvcHRpb25zLnJvbGUpO1xuICAgIHRvcGljLmFkZFN1YnNjcmlwdGlvbihuZXcgTGFtYmRhU3Vic2NyaXB0aW9uKGFwcHJvdmFsUmVxdWVzdGVyKSk7XG5cbiAgICBjb25zdCBhcHByb3ZhbEhhbmRsZXIgPSBuZXcgRnVuY3Rpb24oc2NvcGUsICdTbGFja0FwcHJvdmFsSGFuZGxlckZ1bmN0aW9uJywge1xuICAgICAgcnVudGltZTogUnVudGltZS5OT0RFSlNfMTBfWCxcbiAgICAgIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgICAgIGNvZGU6IENvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICdsYW1iZGFzJywgJ2FwcHJvdmFsLWhhbmRsZXInKSksXG4gICAgICBlbnZpcm9ubWVudCxcbiAgICB9KTtcblxuICAgIGNvbnN0IGFwaSA9IG5ldyBSZXN0QXBpKHNjb3BlLCAnU2xhY2tBcHByb3ZhbEFwaScpO1xuICAgIGFwaS5yb290LmFkZFByb3h5KHtcbiAgICAgIGRlZmF1bHRJbnRlZ3JhdGlvbjogbmV3IExhbWJkYUludGVncmF0aW9uKGFwcHJvdmFsSGFuZGxlciksXG4gICAgfSk7XG5cbiAgICBhcHByb3ZhbEhhbmRsZXIuYWRkVG9Sb2xlUG9saWN5KFxuICAgICAgbmV3IFBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIGFjdGlvbnM6IFsnY29kZXBpcGVsaW5lOlB1dEFwcHJvdmFsUmVzdWx0J10sXG4gICAgICAgIHJlc291cmNlczogW2Ake3N0YWdlLnBpcGVsaW5lLnBpcGVsaW5lQXJufS8ke3N0YWdlLnN0YWdlTmFtZX0vJHt0aGlzLnByb3BzLmFjdGlvbk5hbWV9YF0sXG4gICAgICB9KSxcbiAgICApO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgTm90aWZpY2F0aW9uQXJuOiB0b3BpYy50b3BpY0FybixcbiAgICAgICAgQ3VzdG9tRGF0YTogdGhpcy5wcm9wcy5hZGRpdGlvbmFsSW5mb3JtYXRpb24sXG4gICAgICAgIEV4dGVybmFsRW50aXR5TGluazogdGhpcy5wcm9wcy5leHRlcm5hbEVudGl0eUxpbmssXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==