/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.sparksdk.internal;

import com.amazonaws.services.sagemaker.sparksdk.S3DataPath;
import com.amazonaws.services.sagemaker.sparksdk.internal.DataUploadResult;
import com.amazonaws.services.sagemaker.sparksdk.internal.ManifestDataUploadResult;
import com.amazonaws.services.sagemaker.sparksdk.internal.ObjectPrefixUploadResult;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.spark.sql.Dataset;
import scala.Function0;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005eg!B\u0001\u0003\u0001\u0011q!\u0001\u0004#bi\u0006,\u0006\u000f\\8bI\u0016\u0014(BA\u0002\u0005\u0003!Ig\u000e^3s]\u0006d'BA\u0003\u0007\u0003!\u0019\b/\u0019:lg\u0012\\'BA\u0004\t\u0003%\u0019\u0018mZ3nC.,'O\u0003\u0002\n\u0015\u0005A1/\u001a:wS\u000e,7O\u0003\u0002\f\u0019\u0005I\u0011-\\1{_:\fwo\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0014\u0005\u0001y\u0001C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0003\u0005\u0017\u0001\t\u0015\r\u0011\"\u0002\u0019\u0003)!\u0017\r^1G_Jl\u0017\r^\u0002\u0001+\u0005I\u0002C\u0001\u000e\u001e\u001d\t\u00012$\u0003\u0002\u001d#\u00051\u0001K]3eK\u001aL!AH\u0010\u0003\rM#(/\u001b8h\u0015\ta\u0012\u0003\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0004\u001a\u0003-!\u0017\r^1G_Jl\u0017\r\u001e\u0011\t\u0011\r\u0002!Q1A\u0005\u0006\u0011\n\u0011\u0003Z1uC\u001a{'/\\1u\u001fB$\u0018n\u001c8t+\u0005)\u0003\u0003\u0002\u0014,3ei\u0011a\n\u0006\u0003Q%\n\u0011\"[7nkR\f'\r\\3\u000b\u0005)\n\u0012AC2pY2,7\r^5p]&\u0011Af\n\u0002\u0004\u001b\u0006\u0004\b\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000bQB\u0013\u0002%\u0011\fG/\u0019$pe6\fGo\u00149uS>t7\u000f\t\u0005\u0006a\u0001!\t!M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\"T\u0007\u0005\u00024\u00015\t!\u0001C\u0003\u0017_\u0001\u0007\u0011\u0004C\u0003$_\u0001\u0007Q\u0005C\u00048\u0001\t\u0007IQ\u0002\u001d\u0002-5\u000bg.\u001b4fgR$V-\u001c9GS2,\u0007K]3gSb,\u0012!O\b\u0002u\u0005\n1(\u0001\ntC\u001e,W.Y6fe6j\u0017M\\5gKN$\bBB\u001f\u0001A\u00035\u0011(A\fNC:Lg-Z:u)\u0016l\u0007OR5mKB\u0013XMZ5yA!9q\b\u0001b\u0001\n\u001b\u0001\u0015!E'b]&4Wm\u001d;LKf\u001cVO\u001a4jqV\t\u0011iD\u0001CC\u0005\u0019\u0015!\u0004\u0018nC:Lg-Z:u]QDH\u000f\u0003\u0004F\u0001\u0001\u0006i!Q\u0001\u0013\u001b\u0006t\u0017NZ3ti.+\u0017pU;gM&D\b\u0005C\u0004H\u0001\t\u0007IQ\u0002%\u0002!!#ei\u0015$pY\u0012,'oU;gM&DX#A%\u0010\u0003)\u000b\u0013aS\u0001\tI\u0019|G\u000eZ3sI!1Q\n\u0001Q\u0001\u000e%\u000b\u0011\u0003\u0013#G'\u001a{G\u000eZ3s'V4g-\u001b=!\u0011\u001dy\u0005A1A\u0005\u000eA\u000b\u0011\u0003S1e_>\u00048+^2dKN\u001ch)\u001b7f+\u0005\tv\"\u0001*\"\u0003M\u000b\u0001bX*V\u0007\u000e+5k\u0015\u0005\u0007+\u0002\u0001\u000bQB)\u0002%!\u000bGm\\8q'V\u001c7-Z:t\r&dW\r\t\u0005\b/\u0002\u0011\r\u0011\"\u0004Y\u0003)\u00196GR*TG\",W.Z\u000b\u00023>\t!,I\u0001\\\u0003\r\u00198'\u0019\u0005\u0007;\u0002\u0001\u000bQB-\u0002\u0017M\u001bdiU*dQ\u0016lW\r\t\u0005\b?\u0002\u0011\r\u0011\"\u0004a\u0003-)UJ\u0015$T'\u000eDW-\\3\u0016\u0003\u0005|\u0011AY\u0011\u0002G\u0006\u00111o\r\u0005\u0007K\u0002\u0001\u000bQB1\u0002\u0019\u0015k%KR*TG\",W.\u001a\u0011\t\u000f\u001d\u0004!\u0019!C\u0007Q\u0006iQ)\u001c:ggB\u0013x\u000e]3sif,\u0012![\b\u0002U\u0006\n1.\u0001\u0006gg:\u001a8GL5na2Da!\u001c\u0001!\u0002\u001bI\u0017AD#ne\u001a\u001c\bK]8qKJ$\u0018\u0010\t\u0005\b_\u0002\u0011\r\u0011\"\u0004q\u00039)UN\u001d$T\u00072\f7o\u001d(b[\u0016,\u0012!]\b\u0002e\u0006\n1/A\u0007F[J4\u0015\u000e\\3TsN$X-\u001c\u0005\u0007k\u0002\u0001\u000bQB9\u0002\u001f\u0015k'OR*DY\u0006\u001c8OT1nK\u0002BQa\u001e\u0001\u0005\u0002a\f!\"\u001e9m_\u0006$G)\u0019;b)\u0011IH0!\u0002\u0011\u0005MR\u0018BA>\u0003\u0005A!\u0015\r^1Va2|\u0017\r\u001a*fgVdG\u000fC\u0003~m\u0002\u0007a0A\bj]B,HoU\u001aECR\f\u0007+\u0019;i!\ry\u0018\u0011A\u0007\u0002\t%\u0019\u00111\u0001\u0003\u0003\u0015M\u001bD)\u0019;b!\u0006$\b\u000eC\u0004\u0002\bY\u0004\r!!\u0003\u0002\u000f\u0011\fG/Y:fiB\"\u00111BA\u0014!\u0019\ti!a\b\u0002$5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0002tc2TA!!\u0006\u0002\u0018\u0005)1\u000f]1sW*!\u0011\u0011DA\u000e\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QD\u0001\u0004_J<\u0017\u0002BA\u0011\u0003\u001f\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u0002&\u0005\u001dB\u0002\u0001\u0003\r\u0003S\t)!!A\u0001\u0002\u000b\u0005\u00111\u0006\u0002\u0004?\u0012\n\u0014\u0003BA\u0017\u0003g\u00012\u0001EA\u0018\u0013\r\t\t$\u0005\u0002\b\u001d>$\b.\u001b8h!\r\u0001\u0012QG\u0005\u0004\u0003o\t\"aA!os\"A\u00111\b\u0001\u0005\u0002\t\ti$A\u0006hKR45kU2iK6,GcA\r\u0002@!A\u0011\u0011IA\u001d\u0001\u0004\t\u0019%A\u0003p]\u0016k%\u000bE\u0002\u0011\u0003\u000bJ1!a\u0012\u0012\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u0013\u0001\t\u0003!\u0011QJ\u0001\noJLG/\u001a#bi\u0006$b!a\u0014\u0002V\u0005\u0005\u0004c\u0001\t\u0002R%\u0019\u00111K\t\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u000f\tI\u00051\u0001\u0002XA\"\u0011\u0011LA/!\u0019\ti!a\b\u0002\\A!\u0011QEA/\t1\ty&!\u0016\u0002\u0002\u0003\u0005)\u0011AA\u0016\u0005\ryFE\r\u0005\b\u0003G\nI\u00051\u0001\u001a\u0003!Ig\u000e];u+JK\u0005\u0002CA4\u0001\u0011\u0005!!!\u001b\u0002\u0015U\u001c\u0018N\\4F\u001bJ35\u000b\u0006\u0003\u0002D\u0005-\u0004\u0002CA\u0004\u0003K\u0002\r!!\u001c1\t\u0005=\u00141\u000f\t\u0007\u0003\u001b\ty\"!\u001d\u0011\t\u0005\u0015\u00121\u000f\u0003\r\u0003k\nY'!A\u0001\u0002\u000b\u0005\u00111\u0006\u0002\u0004?\u0012\u001a\u0004\u0002CA=\u0001\u0011\u0005!!a\u001f\u0002'\u001d,G\u000fS1e_>\u0004h)\u001b7fgf\u001cH/Z7\u0015\r\u0005u\u0014QRAL!\u0011\ty(!#\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000b!AZ:\u000b\t\u0005\u001d\u0015qC\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005-\u0015\u0011\u0011\u0002\u000b\r&dWmU=ti\u0016l\u0007\u0002CAH\u0003o\u0002\r!!%\u0002\u0013%t\u0007/\u001e;QCRD\u0007\u0003BA@\u0003'KA!!&\u0002\u0002\n!\u0001+\u0019;i\u0011!\t9!a\u001eA\u0002\u0005e\u0005\u0007BAN\u0003?\u0003b!!\u0004\u0002 \u0005u\u0005\u0003BA\u0013\u0003?#A\"!)\u0002\u0018\u0006\u0005\t\u0011!B\u0001\u0003W\u00111a\u0018\u00135\u0011!\t)\u000b\u0001C\u0001\u0005\u0005\u001d\u0016AF<sSR,\u0017I\u001c3Va2|\u0017\rZ'b]&4Wm\u001d;\u0015\u000be\tI+!,\t\u0011\u0005-\u00161\u0015a\u0001\u0003#\u000bab]1hK6\f7.\u001a:J]B,H\u000f\u0003\u0005\u00020\u0006\r\u0006\u0019AA?\u0003!A\u0017\rZ8pa\u001a\u001b\u0006\u0002CAZ\u0001\u0011\u0005!!!.\u0002\u001b]\u0014\u0018\u000e^3NC:Lg-Z:u)!\ty%a.\u0002:\u0006m\u0006\u0002CAV\u0003c\u0003\r!!%\t\u0011\u0005=\u0016\u0011\u0017a\u0001\u0003{B\u0001\"!0\u00022\u0002\u0007\u0011qX\u0001\u000f[\u0006t\u0017NZ3ti^\u0013\u0018\u000e^3s!\u0011\t\t-a3\u000e\u0005\u0005\r'\u0002BAc\u0003\u000f\f!![8\u000b\u0005\u0005%\u0017\u0001\u00026bm\u0006LA!!4\u0002D\n1qK]5uKJD\u0001\"!5\u0001\t\u0003\u0011\u00111[\u0001\u0014SND\u0015\rZ8paN\u0003XmY5bY\u001aKG.\u001a\u000b\u0005\u0003\u0007\n)\u000eC\u0004\u0002X\u0006=\u0007\u0019A\r\u0002\u0011\u0019LG.\u001a(b[\u0016\u0004")
public class DataUploader {
    private final String dataFormat;
    private final Map<String, String> dataFormatOptions;
    private final String ManifestTempFilePrefix;
    private final String ManifestKeySuffix;
    private final String HDFSFolderSuffix;
    private final String HadoopSuccessFile;
    private final String S3FSScheme;
    private final String EMRFSScheme;
    private final String EmrfsProperty;
    private final String EmrFSClassName;

    public final String dataFormat() {
        return this.dataFormat;
    }

    public final Map<String, String> dataFormatOptions() {
        return this.dataFormatOptions;
    }

    private final String ManifestTempFilePrefix() {
        return "sagemaker-manifest";
    }

    private final String ManifestKeySuffix() {
        return ".manifest.txt";
    }

    private final String HDFSFolderSuffix() {
        return "$folder$";
    }

    private final String HadoopSuccessFile() {
        return "_SUCCESS";
    }

    private final String S3FSScheme() {
        return "s3a";
    }

    private final String EMRFSScheme() {
        return "s3";
    }

    private final String EmrfsProperty() {
        return "fs.s3.impl";
    }

    private final String EmrFSClassName() {
        return "EmrFileSystem";
    }

    public DataUploadResult uploadData(S3DataPath inputS3DataPath, Dataset<?> dataset) {
        Product product;
        String inputDataBucket = inputS3DataPath.bucket();
        String inputDataObjectPath = inputS3DataPath.objectPath();
        boolean onEMR = this.usingEMRFS(dataset);
        String fsScheme = this.getFSScheme(onEMR);
        String inputURI = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fsScheme, inputDataBucket, inputDataObjectPath}));
        this.writeData(dataset, inputURI);
        if (onEMR) {
            Path inputPath = new Path(inputURI);
            FileSystem hadoopFS = this.getHadoopFilesystem(inputPath, dataset);
            String manifestKey = this.writeAndUploadManifest(inputPath, hadoopFS);
            product = new ManifestDataUploadResult(new S3DataPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputDataBucket})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{manifestKey}))));
        } else {
            product = new ObjectPrefixUploadResult(new S3DataPath(inputDataBucket, inputDataObjectPath));
        }
        return product;
    }

    public String getFSScheme(boolean onEMR) {
        return onEMR ? "s3" : "s3a";
    }

    public void writeData(Dataset<?> dataset, String inputURI) {
        dataset.sparkSession().sparkContext().hadoopConfiguration().set("mapreduce.fileoutputcommitter.marksuccessfuljobs", "false");
        dataset.write().format(this.dataFormat()).options(this.dataFormatOptions()).save(inputURI);
    }

    public boolean usingEMRFS(Dataset<?> dataset) {
        String fileSystemClassName = dataset.sparkSession().sparkContext().hadoopConfiguration().get("fs.s3.impl");
        return fileSystemClassName != null && fileSystemClassName.contains("EmrFileSystem");
    }

    public FileSystem getHadoopFilesystem(Path inputPath, Dataset<?> dataset) {
        return inputPath.getFileSystem(dataset.sparkSession().sparkContext().hadoopConfiguration());
    }

    /*
     * WARNING - void declaration
     */
    public String writeAndUploadManifest(Path sagemakerInput, FileSystem hadoopFS) {
        File tempFile = File.createTempFile("sagemaker-manifest", "sagemaker-manifest");
        FileWriter manifestWriter = new FileWriter(tempFile);
        try {
            this.writeManifest(sagemakerInput, hadoopFS, manifestWriter);
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        manifestWriter.close();
        Path manifestPath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sagemakerInput.toUri().getPath(), ".manifest.txt"})));
        hadoopFS.copyFromLocalFile(true, new Path(tempFile.getAbsolutePath()), manifestPath);
        return new StringOps(Predef$.MODULE$.augmentString(manifestPath.toUri().getPath())).stripPrefix("/");
    }

    public void writeManifest(Path sagemakerInput, FileSystem hadoopFS, Writer manifestWriter) {
        RemoteIterator hadoopFSIterator = hadoopFS.listFiles(sagemakerInput, true);
        StringBuilder manifestStringBuilder = new StringBuilder(new StringBuilder().append((Object)"[{\"prefix\": \"").append((Object)sagemakerInput).append((Object)"/\"}, ").toString());
        Predef$.MODULE$.require(hadoopFSIterator.hasNext(), (Function0)new Serializable(this, sagemakerInput){
            public static final long serialVersionUID = 0L;
            private final Path sagemakerInput$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No files found at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sagemakerInput$1}));
            }
            {
                this.sagemakerInput$1 = sagemakerInput$1;
            }
        });
        ListBuffer fileNames = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (hadoopFSIterator.hasNext()) {
            Path nextFile = ((FileStatus)hadoopFSIterator.next()).getPath();
            String fileName = nextFile.getName();
            if (this.isHadoopSpecialFile(fileName)) continue;
            fileNames.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"\"").append((Object)fileName).append((Object)"\"").toString()}));
        }
        Predef$.MODULE$.require(fileNames.nonEmpty(), (Function0)new Serializable(this, sagemakerInput){
            public static final long serialVersionUID = 0L;
            private final Path sagemakerInput$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No non-hadoop files found at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sagemakerInput$1}));
            }
            {
                this.sagemakerInput$1 = sagemakerInput$1;
            }
        });
        manifestStringBuilder.append(fileNames.mkString(", "));
        manifestWriter.write(manifestStringBuilder.append("]").toString());
    }

    public boolean isHadoopSpecialFile(String fileName) {
        return fileName.endsWith("$folder$") || fileName.equals("_SUCCESS");
    }

    public DataUploader(String dataFormat, Map<String, String> dataFormatOptions) {
        this.dataFormat = dataFormat;
        this.dataFormatOptions = dataFormatOptions;
    }
}

