/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.sparksdk.algorithms;

import com.amazonaws.services.sagemaker.sparksdk.algorithms.SageMakerAlgorithmParams;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.Identifiable;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public abstract class SageMakerAlgorithmParams$class {
    public static int getMiniBatchSize(SageMakerAlgorithmParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.miniBatchSize()));
    }

    public static int getFeatureDim(SageMakerAlgorithmParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.featureDim()));
    }

    public static Function1 autoOrAboveParamValidator(SageMakerAlgorithmParams $this, double lowerBound, boolean inclusive) {
        return new Serializable($this, lowerBound, inclusive){
            public static final long serialVersionUID = 0L;
            private final double lowerBound$1;
            private final boolean inclusive$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(String value) {
                try {
                    String string = value;
                    String string2 = "auto";
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) return true;
                    if (this.inclusive$1) {
                        StringOps stringOps = new StringOps(Predef$.MODULE$.augmentString(value));
                        if (!(stringOps.toDouble() >= this.lowerBound$1)) return false;
                        return true;
                    }
                    StringOps stringOps = new StringOps(Predef$.MODULE$.augmentString(value));
                    if (!(stringOps.toDouble() > this.lowerBound$1)) return false;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            {
                this.lowerBound$1 = lowerBound$1;
                this.inclusive$1 = inclusive$1;
            }
        };
    }

    public static Function1 inArrayOrAboveParamValidator(SageMakerAlgorithmParams $this, String[] validValues, double lowerBound) {
        return new Serializable($this, validValues, lowerBound){
            public static final long serialVersionUID = 0L;
            private final String[] validValues$1;
            private final double lowerBound$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(String value) {
                try {
                    if (Predef$.MODULE$.refArrayOps((Object[])this.validValues$1).contains((Object)value)) return true;
                    StringOps stringOps = new StringOps(Predef$.MODULE$.augmentString(value));
                    if (!(stringOps.toDouble() > this.lowerBound$2)) return false;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            {
                this.validValues$1 = validValues$1;
                this.lowerBound$2 = lowerBound$2;
            }
        };
    }

    public static boolean parseTrueAndFalse(SageMakerAlgorithmParams $this, Param param) {
        block4: {
            boolean bl;
            block3: {
                String string;
                block2: {
                    string = (String)$this.$(param);
                    if (!"True".equals(string)) break block2;
                    bl = true;
                    break block3;
                }
                if (!"False".equals(string)) break block4;
                bl = false;
            }
            return bl;
        }
        throw new IllegalArgumentException("Param is neither 'True' nor 'False'");
    }

    public static void $init$(SageMakerAlgorithmParams $this) {
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$SageMakerAlgorithmParams$_setter_$miniBatchSize_$eq(new IntParam((Identifiable)$this, "mini_batch_size", "The number of examples in a mini-batch. Must be > 0.", ParamValidators$.MODULE$.gtEq(1.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$SageMakerAlgorithmParams$_setter_$featureDim_$eq(new IntParam((Identifiable)$this, "feature_dim", "The dimension of the input vectors. Must be > 0.", ParamValidators$.MODULE$.gtEq(1.0)));
    }
}

