"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const stepfunctions = require("../lib");
module.exports = {
    'Instantiate Default State Machine'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new stepfunctions.StateMachine(stack, 'MyStateMachine', {
            stateMachineName: "MyStateMachine",
            definition: stepfunctions.Chain.start(new stepfunctions.Pass(stack, 'Pass'))
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::StepFunctions::StateMachine', {
            StateMachineName: "MyStateMachine",
            DefinitionString: "{\"StartAt\":\"Pass\",\"States\":{\"Pass\":{\"Type\":\"Pass\",\"End\":true}}}"
        }));
        test.done();
    },
    'Instantiate Standard State Machine'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new stepfunctions.StateMachine(stack, 'MyStateMachine', {
            stateMachineName: "MyStateMachine",
            definition: stepfunctions.Chain.start(new stepfunctions.Pass(stack, 'Pass')),
            stateMachineType: stepfunctions.StateMachineType.STANDARD
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::StepFunctions::StateMachine', {
            StateMachineName: "MyStateMachine",
            StateMachineType: "STANDARD",
            DefinitionString: "{\"StartAt\":\"Pass\",\"States\":{\"Pass\":{\"Type\":\"Pass\",\"End\":true}}}"
        }));
        test.done();
    },
    'Instantiate Express State Machine'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new stepfunctions.StateMachine(stack, 'MyStateMachine', {
            stateMachineName: "MyStateMachine",
            definition: stepfunctions.Chain.start(new stepfunctions.Pass(stack, 'Pass')),
            stateMachineType: stepfunctions.StateMachineType.EXPRESS
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::StepFunctions::StateMachine', {
            StateMachineName: "MyStateMachine",
            StateMachineType: "EXPRESS",
            DefinitionString: "{\"StartAt\":\"Pass\",\"States\":{\"Pass\":{\"Type\":\"Pass\",\"End\":true}}}"
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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