"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const stepfunctions = require("../lib");
module.exports = {
    'instantiate Activity'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new stepfunctions.Activity(stack, 'Activity');
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::StepFunctions::Activity', {
            Name: 'Activity'
        }));
        test.done();
    },
    'Activity exposes metrics'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const activity = new stepfunctions.Activity(stack, 'Activity');
        // THEN
        const sharedMetric = {
            period: cdk.Duration.minutes(5),
            namespace: 'AWS/States',
            dimensions: { ActivityArn: { Ref: 'Activity04690B0A' } },
        };
        test.deepEqual(stack.resolve(activity.metricRunTime()), {
            ...sharedMetric,
            metricName: 'ActivityRunTime',
            statistic: 'Average'
        });
        test.deepEqual(stack.resolve(activity.metricFailed()), {
            ...sharedMetric,
            metricName: 'ActivitiesFailed',
            statistic: 'Sum'
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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