"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractPOCDecider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
class TextractPOCDecider extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var lambdaMemoryMB = 1024;
        if (typeof (props.lambdaMemoryMB != 0) && props.lambdaMemoryMB) {
            lambdaMemoryMB = props.lambdaMemoryMB;
        }
        var lambdaTimeout = 900;
        if (typeof (props.lambdaTimeout != 0) && props.lambdaTimeout) {
            lambdaTimeout = props.lambdaTimeout;
        }
        const deciderFunction = new lambda.DockerImageFunction(this, 'TextractDecider', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/decider/')),
            memorySize: lambdaMemoryMB,
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
        });
        deciderFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['s3:GetObject'], resources: ['*'] }));
        const deciderLambdaInvoke = new tasks.LambdaInvoke(this, id + '-decider}', {
            lambdaFunction: deciderFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            outputPath: '$.Payload',
        });
        this.startState = deciderLambdaInvoke;
        this.endStates = [deciderLambdaInvoke];
    }
}
exports.TextractPOCDecider = TextractPOCDecider;
_a = JSII_RTTI_SYMBOL_1;
TextractPOCDecider[_a] = { fqn: "schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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