# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### TextractPOCDecider <a name="TextractPOCDecider" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider"></a>

#### Initializers <a name="Initializers" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.Initializer"></a>

```typescript
import { TextractPOCDecider } from 'schadem-cdk-construct-sfn-idp-decider'

new TextractPOCDecider(parent: Construct, id: string, props: TextractDPPOCDeciderProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.Initializer.parameter.parent">parent</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.Initializer.parameter.props">props</a></code> | <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractDPPOCDeciderProps">TextractDPPOCDeciderProps</a></code> | *No description.* |

---

##### `parent`<sup>Required</sup> <a name="parent" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.Initializer.parameter.parent"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.Initializer.parameter.props"></a>

- *Type:* <a href="#schadem-cdk-construct-sfn-idp-decider.TextractDPPOCDeciderProps">TextractDPPOCDeciderProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.next">next</a></code> | Continue normal execution with the given state. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.prefixStates">prefixStates</a></code> | Prefix the IDs of all states in this state machine fragment. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.toSingleState">toSingleState</a></code> | Wrap all states in this state machine fragment up into a single state. |

---

##### `toString` <a name="toString" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `next` <a name="next" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.next"></a>

```typescript
public next(next: IChainable): Chain
```

Continue normal execution with the given state.

###### `next`<sup>Required</sup> <a name="next" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.next.parameter.next"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

##### `prefixStates` <a name="prefixStates" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.prefixStates"></a>

```typescript
public prefixStates(prefix?: string): StateMachineFragment
```

Prefix the IDs of all states in this state machine fragment.

Use this to avoid multiple copies of the state machine all having the
same state IDs.

###### `prefix`<sup>Optional</sup> <a name="prefix" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.prefixStates.parameter.prefix"></a>

- *Type:* string

The prefix to add.

Will use construct ID by default.

---

##### `toSingleState` <a name="toSingleState" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.toSingleState"></a>

```typescript
public toSingleState(options?: SingleStateOptions): Parallel
```

Wrap all states in this state machine fragment up into a single state.

This can be used to add retry or error handling onto this state
machine fragment.

Be aware that this changes the result of the inner state machine
to be an array with the result of the state machine in it. Adjust
your paths accordingly. For example, change 'outputPath' to
'$[0]'.

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.toSingleState.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.SingleStateOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.isConstruct"></a>

```typescript
import { TextractPOCDecider } from 'schadem-cdk-construct-sfn-idp-decider'

TextractPOCDecider.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.property.endStates">endStates</a></code> | <code>aws-cdk-lib.aws_stepfunctions.INextable[]</code> | The states to chain onto if this fragment is used. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.property.id">id</a></code> | <code>string</code> | Descriptive identifier for this chainable. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.property.startState">startState</a></code> | <code>aws-cdk-lib.aws_stepfunctions.State</code> | The start state of this state machine fragment. |

---

##### `node`<sup>Required</sup> <a name="node" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `endStates`<sup>Required</sup> <a name="endStates" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.property.endStates"></a>

```typescript
public readonly endStates: INextable[];
```

- *Type:* aws-cdk-lib.aws_stepfunctions.INextable[]

The states to chain onto if this fragment is used.

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Descriptive identifier for this chainable.

---

##### `startState`<sup>Required</sup> <a name="startState" id="schadem-cdk-construct-sfn-idp-decider.TextractPOCDecider.property.startState"></a>

```typescript
public readonly startState: State;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.State

The start state of this state machine fragment.

---


## Structs <a name="Structs" id="Structs"></a>

### TextractDPPOCDeciderProps <a name="TextractDPPOCDeciderProps" id="schadem-cdk-construct-sfn-idp-decider.TextractDPPOCDeciderProps"></a>

#### Initializer <a name="Initializer" id="schadem-cdk-construct-sfn-idp-decider.TextractDPPOCDeciderProps.Initializer"></a>

```typescript
import { TextractDPPOCDeciderProps } from 'schadem-cdk-construct-sfn-idp-decider'

const textractDPPOCDeciderProps: TextractDPPOCDeciderProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractDPPOCDeciderProps.property.lambdaMemoryMB">lambdaMemoryMB</a></code> | <code>number</code> | memory of Lambda function (may need to increase for larger documents). |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.TextractDPPOCDeciderProps.property.lambdaTimeout">lambdaTimeout</a></code> | <code>number</code> | *No description.* |

---

##### `lambdaMemoryMB`<sup>Optional</sup> <a name="lambdaMemoryMB" id="schadem-cdk-construct-sfn-idp-decider.TextractDPPOCDeciderProps.property.lambdaMemoryMB"></a>

```typescript
public readonly lambdaMemoryMB: number;
```

- *Type:* number

memory of Lambda function (may need to increase for larger documents).

---

##### `lambdaTimeout`<sup>Optional</sup> <a name="lambdaTimeout" id="schadem-cdk-construct-sfn-idp-decider.TextractDPPOCDeciderProps.property.lambdaTimeout"></a>

```typescript
public readonly lambdaTimeout: number;
```

- *Type:* number

---



