"""Parse the output of the ENHSP planner so that the algorithms will be able to use it."""
import logging
import sys

from pathlib import Path
from typing import NoReturn, List


class ENHSPParser:
    """Parse metricFF plans and exports then into standard output file."""

    logger: logging.Logger

    def __init__(self):
        self.logger = logging.getLogger(__name__)

    @staticmethod
    def parse_plan_content(input_path: Path) -> List[str]:
        """Parse the content of the file and export the action sequence.

        :param input_path: the path to the plan sequence file generated by the solver.
        :return: the action sequence.
        """
        plan_seq = []
        with open(input_path, "rt") as plan_file:
            for line in plan_file.readlines():
                plan_seq.append(line.lower())

        return plan_seq

    def parse_plan(self, input_path: Path) -> NoReturn:
        """Parse the output file and exports a plan if exists.

        :param input_path: the path to the output log of metricFF planner.
        """
        action_sequence = self.parse_plan_content(input_path)
        with open(input_path, "wt") as output_file:
            output_file.writelines(action_sequence)


if __name__ == '__main__':
    ENHSPParser().parse_plan(Path(sys.argv[1]))
