# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aiosignald']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'aiosignald',
    'version': '0.2.1',
    'description': 'Python bindings for signald',
    'long_description': 'Signald python bindings\n=======================\n\n\n[![pypi](https://badge.fury.io/py/aiosignald.svg)](https://pypi.org/project/aiosignald/)\n[![Documentation Status](https://readthedocs.org/projects/aiosignald/badge/?version=latest)](https://aiosignald.readthedocs.io/en/latest/)\n\nMost of the content here is generated by the `generate.py` script that\nuses <https://signald.org/protocol.json>.\n\nInstall\n-------\n\n`pip install aiosignald`\n\nHave signald running. See [their\ndocs](https://signald.org/articles/install/) about it.\n\nIssue tracker: https://todo.sr.ht/~nicoco/aiosignald\n\nPart of the [slidge project](https://sr.ht/~nicoco/slidge) (but can be used independently)\n\nUsage\n-----\n\n### Example: registration\n\n```py\nimport asyncio\n\nfrom aiosignald import SignaldAPI\n\nasync def main():\n    loop = asyncio.get_running_loop()\n    _, signald = await loop.create_unix_connection(\n        SignaldAPI, path=SIGNALD_SOCKET_PATH)\n    await signald.register(username="+XXXXXX")\n    # Some async code to get the SMS code\n    await signald.verify(username="+XXXXXX", code=code)\n    await signald.on_con_lost\n\n# See https://signald.org/articles/protocol/ for more info about this\nSIGNALD_SOCKET_PATH = "/var/run/signald/signald.sock"\n\nasyncio.run(main())\n```\n\nDocs are available on [readthedocs](https://aiosignald.readthedocs.org).\n',
    'author': 'Nicolas Cedilnik',
    'author_email': 'nicoco@nicoco.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://git.sr.ht/~nicoco/aiosignald',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
