Signald python bindings
=======================


[![pypi](https://badge.fury.io/py/aiosignald.svg)](https://pypi.org/project/aiosignald/)
[![Documentation Status](https://readthedocs.org/projects/aiosignald/badge/?version=latest)](https://aiosignald.readthedocs.io/en/latest/)

Most of the content here is generated by the `generate.py` script that
uses <https://signald.org/protocol.json>.

Install
-------

`pip install aiosignald`

Have signald running. See [their
docs](https://signald.org/articles/install/) about it.

Issue tracker: https://todo.sr.ht/~nicoco/aiosignald

Part of the [slidge project](https://sr.ht/~nicoco/slidge) (but can be used independently)

Usage
-----

### Example: registration

```py
import asyncio

from aiosignald import SignaldAPI

async def main():
    loop = asyncio.get_running_loop()
    _, signald = await loop.create_unix_connection(
        SignaldAPI, path=SIGNALD_SOCKET_PATH)
    await signald.register(username="+XXXXXX")
    # Some async code to get the SMS code
    await signald.verify(username="+XXXXXX", code=code)
    await signald.on_con_lost

# See https://signald.org/articles/protocol/ for more info about this
SIGNALD_SOCKET_PATH = "/var/run/signald/signald.sock"

asyncio.run(main())
```

Docs are available on [readthedocs](https://aiosignald.readthedocs.org).
