# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ttp_templates']

package_data = \
{'': ['*'],
 'ttp_templates': ['misc/N2G/cli_ip_data/*',
                   'misc/N2G/cli_isis_data/*',
                   'misc/N2G/cli_l2_data/*',
                   'misc/N2G/cli_ospf_data/*',
                   'misc/Netmiko/*',
                   'misc/ttp_templates_tests/*',
                   'platform/*',
                   'yang/*']}

install_requires = \
['ttp>=0.6.0']

extras_require = \
{'docs:python_version >= "3.7"': ['mkdocs==1.2.4',
                                  'mkdocs-material==7.2.2',
                                  'mkdocs-material-extensions==1.0.1',
                                  'mkdocstrings[python]>=0.18.0,<0.19.0',
                                  'pygments==2.11',
                                  'pymdown-extensions==9.3']}

setup_kwargs = {
    'name': 'ttp-templates',
    'version': '0.3.1',
    'description': 'Template Text Parser Templates collections',
    'long_description': '[![Downloads](https://pepy.tech/badge/ttp_templates)](https://pepy.tech/project/ttp_templates)\n[![PyPI versions](https://img.shields.io/pypi/pyversions/ttp.svg)](https://pypi.python.org/pypi/ttp_templates/)\n\n# Template Text Parser Templates\n\nThis repository contains a collection of [TTP](https://github.com/dmulyalin/ttp) templates.\n\nIf you solved a problem using TTP and feel that your work can be useful to other people, feel \nfree to raise an issue or submit pull request to include your template(s) in this repository.\nRefer to [Contribute Guide](contribute.md) for details.\n\nDocumentation: [https://dmulyalin.github.io/ttp_templates/](https://dmulyalin.github.io/ttp_templates/)\n\nRepository: [https://github.com/dmulyalin/ttp_templates](https://github.com/dmulyalin/ttp_templates)\n\nTTP: [https://ttp.readthedocs.io/](https://ttp.readthedocs.io/)\n\n## Installation\n\nFrom PyPi:\n\n`pip install ttp-templates`\n\nor latest from GitHub master branch (need Git installed on the system):\n\n`pip install git+https://github.com/dmulyalin/ttp_templates.git`\n \n## Sample usage\n\nThis example demonstrates how to parse `Test Platform` output for `show run | sec interface` command using `platform/test_platform_show_run_pipe_sec_interface.txt` template.\n<details><summary>Code</summary>\n\n```python\nfrom ttp_templates import parse_output\nimport pprint\n\ndata = """\ninterface GigabitEthernet1/3.251\n description Customer #32148\n encapsulation dot1q 251\n ip address 172.16.33.10 255.255.255.128\n shutdown\n!\ninterface GigabitEthernet1/3.251\n description Customer #32148\n encapsulation dot1q 251\n ip address 172.16.33.10 255.255.255.128\n shutdown\n"""\n\nresult = parse_output(\n    data=data,\n    platform="Test Platform",\n    command="show run | sec interface"\n)\n\npprint.pprint(result)\n\n# prints:\n# [[[{\'description\': \'Customer #32148\',\n#     \'disabled\': True,\n#     \'dot1q\': \'251\',\n#     \'interface\': \'GigabitEthernet1/3.251\',\n#     \'ip\': \'172.16.33.10\',\n#     \'mask\': \'255.255.255.128\'},\n#    {\'description\': \'Customer #32148\',\n#     \'disabled\': True,\n#     \'dot1q\': \'251\',\n#     \'interface\': \'GigabitEthernet1/3.251\',\n#     \'ip\': \'172.16.33.10\',\n#     \'mask\': \'255.255.255.128\'}]]]\n```\n</details>\n\nSample code to parse `Cisco IOS` output in a structure compatible with `ietf-interfaces` YANG module.\n<details><summary>Code</summary>\n\n```python\nfrom ttp_templates import get_template\nfrom ttp import ttp\nimport pprint\n\ndata1 = """\ninterface GigabitEthernet1/3.251\n description Customer #32148\n encapsulation dot1q 251\n ip address 172.16.33.10 255.255.255.128\n shutdown\n!\ninterface GigabitEthernet1/4\n description vCPEs access control\n ip address 172.16.33.10 255.255.255.128\n!\n"""\ndata2 = """\ninterface GigabitEthernet1/5\n description Works data\n ip mtu 9000\n!\ninterface GigabitEthernet1/7\n description Works data v6\n ipv6 address 2001::1/64\n ipv6 address 2001:1::1/64    \n"""\n\ntemplate = get_template(yang="ietf-interfaces", platform="cisco_ios")\nparser = ttp(template=template)\n\nparser.add_input(data1)\nparser.add_input(data2)\n\nparser.parse()\nres = parser.result()\npprint.pprint(res)\n\n# prints:\n# [{\'comment\': \'\',\n#   \'exception\': {},\n#   \'result\': [{\'ietf-interfaces:interfaces\': {\'interface\': [{\'admin-status\': \'down\',\n#                                                             \'description\': \'Customer \'\n#                                                                            \'#32148\',\n#                                                             \'enabled\': False,\n#                                                             \'ietf-ip:ipv4\': {\'address\': [{\'ip\': \'172.16.33.10\',\n#                                                                                           \'netmask\': \'255.255.255.128\',\n#                                                                                           \'origin\': \'static\'}]},\n#                                                             \'if-index\': 1,\n#                                                             \'link-up-down-trap-enable\': \'enabled\',\n#                                                             \'name\': \'GigabitEthernet1/3.251\',\n#                                                             \'oper-status\': \'unknown\',\n#                                                             \'statistics\': {\'discontinuity-time\': \'1970-01-01T00:00:00+00:00\'},\n#                                                             \'type\': \'iana-if-type:ethernetCsmacd\'},\n#                                                            {\'admin-status\': \'up\',\n#                                                             \'description\': \'vCPEs \'\n#                                                                            \'access \'\n#                                                                            \'control\',\n#                                                             \'enabled\': True,\n#                                                             \'ietf-ip:ipv4\': {\'address\': [{\'ip\': \'172.16.33.10\',\n#                                                                                           \'netmask\': \'255.255.255.128\',\n#                                                                                           \'origin\': \'static\'}]},\n#                                                             \'if-index\': 1,\n#                                                             \'link-up-down-trap-enable\': \'enabled\',\n#                                                             \'name\': \'GigabitEthernet1/4\',\n#                                                             \'oper-status\': \'unknown\',\n#                                                             \'statistics\': {\'discontinuity-time\': \'1970-01-01T00:00:00+00:00\'},\n#                                                             \'type\': \'iana-if-type:ethernetCsmacd\'}]}},\n#              {\'ietf-interfaces:interfaces\': {\'interface\': [{\'admin-status\': \'up\',\n#                                                             \'description\': \'Works \'\n#                                                                            \'data\',\n#                                                             \'enabled\': True,\n#                                                             \'ietf-ip:ipv4\': {\'mtu\': 9000},\n#                                                             \'if-index\': 1,\n#                                                             \'link-up-down-trap-enable\': \'enabled\',\n#                                                             \'name\': \'GigabitEthernet1/5\',\n#                                                             \'oper-status\': \'unknown\',\n#                                                             \'statistics\': {\'discontinuity-time\': \'1970-01-01T00:00:00+00:00\'},\n#                                                             \'type\': \'iana-if-type:ethernetCsmacd\'},\n#                                                            {\'admin-status\': \'up\',\n#                                                             \'description\': \'Works \'\n#                                                                            \'data \'\n#                                                                            \'v6\',\n#                                                             \'enabled\': True,\n#                                                             \'ietf-ip:ipv6\': {\'address\': [{\'ip\': \'2001::1\',\n#                                                                                           \'origin\': \'static\',\n#                                                                                           \'prefix-length\': 64},\n#                                                                                          {\'ip\': \'2001:1::1\',\n#                                                                                           \'origin\': \'static\',\n#                                                                                           \'prefix-length\': 64}]},\n#                                                             \'if-index\': 1,\n#                                                             \'link-up-down-trap-enable\': \'enabled\',\n#                                                             \'name\': \'GigabitEthernet1/7\',\n#                                                             \'oper-status\': \'unknown\',\n#                                                             \'statistics\': {\'discontinuity-time\': \'1970-01-01T00:00:00+00:00\'},\n#                                                             \'type\': \'iana-if-type:ethernetCsmacd\'}]}}],\n#   \'valid\': {0: True, 1: True}}]\n```\n</details>\n\n## How templates collections structured\n\nThis repository contains three collections of templates corresponding to folder names:\n\n* `platform` collection - mimics [ntc-templates](https://github.com/networktocode/ntc-templates) API and follows same naming rule\n* `yang` collection - contains templates capable of producing YANG compatible structures out of text data\n* `misc` collection - miscellaneous templates for various use cases organized in folders\n\n### Platform collection templates files naming rule\n\n`{{ vendor_os }}_{{ command_with_underscores }}.txt` - lower case only. \n\nNaming rules details:\n\n* All space symbols `\' \'` replaced with underscores.\n* Pipe symbol `|` replaced with `pipe` in template name. For example, \n  template to parse Cisco IOS `show run | section interface` command output \n  must be named `cisco_ios_show_running_config_pipe_section_interface.txt`\n* Dash symbols `-` replaced with underscores. For example, template to parse \n  Huawei `display current-configuration interface` command output  must be \n  named `huawei_display_current_configuration_interface.txt`\n\n### YANG collection templates files naming rule\n\n`{{ YANG module name }}_{{ platform_name }}.txt` - lower case only\n\nNaming rules details:\n\n* All space symbols `\' \'` replaced with underscore.\n* Dash symbol `-` **does not** replaced with underscore. For example, template\n  to produce output compatible with openconfig-lldp YANG model for Cisco IOS\n  must be named `openconfig-lldp_cisco_xr.txt`\n\n### Misc collection templates files naming rule\n\n`{{ usecase folder }}/{{ template name }}.txt` - upper or lower case\n\nNaming rules details:\n\n* Nothing replaced with anything, provided template name used as is.\n\n## Additional Templates Resources\n\nList of resources with TTP templates:\n\n- TTP SrosParser - https://pypi.org/project/ttp-sros-parser/ by [h4ndzdatm0ld](https://github.com/h4ndzdatm0ld)\n- Template for parsing "show run" for Cisco IOS - https://github.com/tbotnz/ios-show-run-ttp by [tbotnz](https://github.com/tbotnz)\n- Template for Cisco ASA configuration - https://gist.github.com/consentfactory/85872fc83453d1735b15aed3e47a9763 by [consentfactory](https://gist.github.com/consentfactory)',
    'author': 'Denis Mulyalin',
    'author_email': 'd.mulyalin@gmail.com',
    'maintainer': 'Denis Mulyalin',
    'maintainer_email': 'd.mulyalin@gmail.com',
    'url': 'https://github.com/dmulyalin/ttp_templates',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
