/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.JSONEntry;
import org.jooq.JSONObjectNullStep;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.JSONArray;
import org.jooq.impl.JSONArrayAgg;
import org.jooq.impl.JSONNull;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.ScalarSubquery;

final class JSONObject<J>
extends AbstractField<J>
implements JSONObjectNullStep<J> {
    private static final long serialVersionUID = 1772007627336725780L;
    private final QueryPartList<JSONEntry<?>> args;
    private final JSONNull.JSONNullType nullType;

    JSONObject(DataType<J> type, Collection<? extends JSONEntry<?>> args) {
        this(type, args, null);
    }

    JSONObject(DataType<J> type, Collection<? extends JSONEntry<?>> args, JSONNull.JSONNullType nullType) {
        super(Names.N_JSON_OBJECT, type);
        this.args = new QueryPartList((Iterable<JSONEntry<?>>)args);
        this.nullType = nullType;
    }

    @Override
    public final JSONObject<J> nullOnNull() {
        return new JSONObject(this.getDataType(), this.args, JSONNull.JSONNullType.NULL_ON_NULL);
    }

    @Override
    public final JSONObject<J> absentOnNull() {
        return new JSONObject(this.getDataType(), this.args, JSONNull.JSONNullType.ABSENT_ON_NULL);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                if (this.nullType == JSONNull.JSONNullType.ABSENT_ON_NULL) {
                    ctx.visit(DSL.unquotedName(this.getDataType().getType() == JSONB.class ? "jsonb_strip_nulls" : "json_strip_nulls")).sql('(');
                }
                ctx.visit(DSL.unquotedName(this.getDataType().getType() == JSONB.class ? "jsonb_build_object" : "json_build_object")).sql('(').visit(this.args).sql(')');
                if (this.nullType != JSONNull.JSONNullType.ABSENT_ON_NULL) break;
                ctx.sql(')');
                break;
            }
            case MARIADB: {
                if (this.args.size() > 1) {
                    ctx.visit(Names.N_JSON_MERGE).sql('(').visit(DSL.inline("{}")).formatIndentStart();
                    for (JSONEntry jSONEntry : this.args) {
                        ctx.sql(',').formatSeparator().visit(DSL.jsonObject(jSONEntry));
                    }
                    ctx.formatIndentEnd().formatNewLine().sql(')');
                    break;
                }
                if (!this.args.isEmpty() && JSONObject.isJSONArray(((JSONEntry)this.args.get(0)).value())) {
                    ctx.visit(DSL.jsonObject(DSL.key(((JSONEntry)this.args.get(0)).key()).value(DSL.field("{0}({1}, {2})", this.getDataType(), new QueryPart[]{Names.N_JSON_MERGE, DSL.inline("[]"), ((JSONEntry)this.args.get(0)).value()}))));
                    break;
                }
                this.acceptStandard(ctx);
                break;
            }
            default: {
                this.acceptStandard(ctx);
            }
        }
    }

    private static final boolean isJSONArray(Field<?> field) {
        return field instanceof JSONArray || field instanceof JSONArrayAgg || field instanceof ScalarSubquery && JSONObject.isJSONArray(((ScalarSubquery)field).query.getSelect().get(0));
    }

    private final void acceptStandard(Context<?> ctx) {
        JSONNull jsonNull = this.args.isEmpty() && ctx.family() == SQLDialect.H2 ? new JSONNull(JSONNull.JSONNullType.NULL_ON_NULL) : new JSONNull(this.nullType);
        ctx.visit(Keywords.K_JSON_OBJECT).sql('(').visit(QueryPartListView.wrap((QueryPart[])new AbstractQueryPart[]{this.args, jsonNull}).separator("")).sql(')');
    }
}

