/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx.pipeline;

import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.ChunkMergeSortHelper;
import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.service.ndx.pipeline.AbstractMasterStats;
import com.bigdata.service.ndx.pipeline.AbstractMasterTask;
import com.bigdata.service.ndx.pipeline.AbstractSubtaskStats;
import com.bigdata.service.ndx.pipeline.IdleTimeoutException;
import com.bigdata.service.ndx.pipeline.MasterExhaustedException;
import com.bigdata.util.concurrent.AbstractHaltableProcess;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AbstractSubtask<HS extends AbstractSubtaskStats, M extends AbstractMasterTask<? extends AbstractMasterStats<L, HS>, E, ? extends AbstractSubtask, L>, E, L>
implements Callable<HS> {
    protected static final transient Logger log = Logger.getLogger(AbstractSubtask.class);
    protected final M master;
    protected final L locator;
    protected final BlockingBuffer<E[]> buffer;
    protected final IAsynchronousIterator<E[]> src;
    protected final HS stats;
    protected volatile long lastChunkNanos;
    protected volatile long lastChunkAvailableNanos;

    public String toString() {
        return this.getClass().getName() + "{locator=" + this.locator + ", open=" + this.buffer.isOpen() + "}";
    }

    public AbstractSubtask(M master, L locator, BlockingBuffer<E[]> buffer) {
        this.lastChunkAvailableNanos = this.lastChunkNanos = System.nanoTime();
        if (master == null) {
            throw new IllegalArgumentException();
        }
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        this.master = master;
        this.locator = locator;
        this.buffer = buffer;
        this.src = buffer.iterator();
        this.stats = ((AbstractMasterStats)((AbstractMasterTask)master).stats).getSubtaskStats(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HS call() throws Exception {
        try {
            NonBlockingChunkedIterator itr = new NonBlockingChunkedIterator(this.src);
            long lastHandledChunkNanos = System.nanoTime();
            while (itr.hasNext()) {
                E[] chunk = itr.next();
                long elapsedChunkWaitNanos = System.nanoTime() - lastHandledChunkNanos;
                Object object = ((AbstractMasterTask)this.master).stats;
                synchronized (object) {
                    ((AbstractMasterStats)((AbstractMasterTask)this.master).stats).elapsedSinkChunkWaitingNanos += elapsedChunkWaitNanos;
                }
                object = this.stats;
                synchronized (object) {
                    ((AbstractSubtaskStats)this.stats).elapsedChunkWaitingNanos += elapsedChunkWaitNanos;
                }
                if (this.handleChunk(chunk)) {
                    if (!log.isInfoEnabled()) break;
                    log.info((Object)"Eager termination.");
                    break;
                }
                lastHandledChunkNanos = System.nanoTime();
            }
            if (this.buffer.isOpen()) {
                throw new AssertionError((Object)this.toString());
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Done: " + this.locator));
            }
            this.awaitPending();
            HS HS = this.stats;
            return HS;
        }
        catch (Throwable t) {
            if (log.isInfoEnabled()) {
                log.warn((Object)this, t);
            } else {
                log.warn((Object)(this + " : " + t));
            }
            this.buffer.abort(t);
            this.buffer.clear();
            this.cancelRemoteTask(true);
            throw ((AbstractHaltableProcess)this.master).halt((RuntimeException)new RuntimeException(this.toString(), t));
        }
        finally {
            ((AbstractMasterTask)this.master).notifySubtaskDone(this);
        }
    }

    protected void awaitPending() throws InterruptedException {
    }

    protected void cancelRemoteTask(boolean mayInterruptIfRunning) throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRedirect(E[] chunk, Throwable cause) throws InterruptedException {
        if (chunk == null) {
            throw new IllegalArgumentException();
        }
        if (cause == null) {
            throw new IllegalArgumentException();
        }
        long begin = System.nanoTime();
        this.notifyClientOfRedirect(this.locator, cause);
        this.buffer.abort(cause);
        ((AbstractMasterTask)this.master).redirectChunk(chunk);
        while (this.src.hasNext()) {
            ((AbstractMasterTask)this.master).redirectChunk((Object[])((Object[])this.src.next()));
        }
        Object h = ((AbstractMasterTask)this.master).stats;
        synchronized (h) {
            ((AbstractMasterStats)((AbstractMasterTask)this.master).stats).elapsedRedirectNanos += System.nanoTime() - begin;
            ((AbstractMasterStats)((AbstractMasterTask)this.master).stats).redirectCount.incrementAndGet();
        }
    }

    protected abstract boolean handleChunk(E[] var1) throws Exception;

    protected abstract void notifyClientOfRedirect(L var1, Throwable var2);

    private class NonBlockingChunkedIterator {
        private final IAsynchronousIterator<E[]> src;
        private int chunkSize;
        private LinkedList<E[]> chunks = new LinkedList();

        private void clear() {
            this.chunkSize = 0;
            this.chunks = new LinkedList();
        }

        public String toString() {
            return AbstractSubtask.this.toString() + "{chunkSize=" + this.chunkSize + "}";
        }

        public NonBlockingChunkedIterator(IAsynchronousIterator<E[]> src) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            this.src = src;
        }

        public boolean hasNext() throws InterruptedException {
            long begin = System.nanoTime();
            while (true) {
                boolean idle;
                ((AbstractHaltableProcess)AbstractSubtask.this.master).halted();
                if (Thread.interrupted()) {
                    throw ((AbstractHaltableProcess)AbstractSubtask.this.master).halt((InterruptedException)new InterruptedException(this.toString()));
                }
                long now = System.nanoTime();
                long elapsedNanos = now - begin;
                long elapsedSinceLastChunk = now - AbstractSubtask.this.lastChunkNanos;
                long elapsedSinceLastChunkAvailable = now - AbstractSubtask.this.lastChunkAvailableNanos;
                boolean bl = idle = elapsedSinceLastChunk > ((AbstractMasterTask)AbstractSubtask.this.master).sinkIdleTimeoutNanos && elapsedSinceLastChunkAvailable > ((AbstractMasterTask)AbstractSubtask.this.master).sinkIdleTimeoutNanos;
                if ((idle || ((AbstractMasterTask)AbstractSubtask.this.master).src.isExhausted()) && AbstractSubtask.this.buffer.isOpen() && AbstractSubtask.this.buffer.isEmpty()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Closing buffer: idle=" + idle + " : " + this));
                    }
                    if (idle) {
                        AbstractSubtask.this.buffer.abort(new IdleTimeoutException());
                        ((AbstractMasterStats)((AbstractMasterTask)AbstractSubtask.this.master).stats).subtaskIdleTimeoutCount.incrementAndGet();
                    } else {
                        AbstractSubtask.this.buffer.abort(new MasterExhaustedException());
                    }
                    if (this.chunkSize == 0 && !this.src.hasNext()) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("No more data: " + this));
                        }
                        return false;
                    }
                }
                if (this.chunkSize >= AbstractSubtask.this.buffer.getMinimumChunkSize()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Full chunk: " + this.chunkSize + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsedNanos) + " : " + this));
                    }
                    return true;
                }
                if (this.chunkSize > 0 && (elapsedNanos > AbstractSubtask.this.buffer.getChunkTimeout() || !AbstractSubtask.this.buffer.isOpen() && !this.src.hasNext())) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Partial chunk: " + this.chunkSize + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsedNanos) + " : " + this));
                    }
                    return true;
                }
                if (this.src.hasNext(((AbstractMasterTask)AbstractSubtask.this.master).sinkPollTimeoutNanos, TimeUnit.NANOSECONDS)) {
                    Object[] a = this.src.next(1L, TimeUnit.NANOSECONDS);
                    assert (a != null);
                    assert (a.length != 0);
                    assert (a[0] != null) : "chunk with nulls: chunkSize=" + a.length + ", chunk=" + Arrays.toString(a);
                    this.chunks.add(a);
                    this.chunkSize += a.length;
                    ((AbstractMasterStats)((AbstractMasterTask)AbstractSubtask.this.master).stats).elementsOnSinkQueues.addAndGet(-a.length);
                    AbstractSubtask.this.lastChunkAvailableNanos = System.nanoTime();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Combining chunks: chunkSize=" + a.length + ", ncombined=" + this.chunks.size() + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - begin)));
                    continue;
                }
                if (this.chunkSize == 0 && !AbstractSubtask.this.buffer.isOpen() && !this.src.hasNext()) break;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("No more data: " + this));
            }
            return false;
        }

        public E[] next() {
            if (this.chunkSize == 0) {
                throw new NoSuchElementException();
            }
            E[] firstChunk = this.chunks.getFirst();
            assert (firstChunk != null);
            assert (firstChunk.length != 0);
            assert (firstChunk[0] != null);
            Object[] a = (Object[])Array.newInstance(firstChunk.getClass().getComponentType(), this.chunkSize);
            int dstpos = 0;
            int ncombined = 0;
            for (Object[] objectArray : this.chunks) {
                int len = objectArray.length;
                System.arraycopy(objectArray, 0, a, dstpos, len);
                dstpos += len;
                ++ncombined;
            }
            if (ncombined > 0 && AbstractSubtask.this.buffer.isOrdered()) {
                ChunkMergeSortHelper.mergeSort(a);
            }
            this.clear();
            return a;
        }
    }
}

