/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.KeyOutOfRangeException;
import com.bigdata.btree.filter.Advancer;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.impl.extensions.GeoSpatialLiteralExtension;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.service.geospatial.GeoSpatialCounters;
import com.bigdata.service.geospatial.ZOrderRangeScanUtil;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ZOrderIndexBigMinAdvancer
extends Advancer<SPO> {
    private static final long serialVersionUID = -6438977707376228799L;
    private static final transient Logger log = Logger.getLogger(ZOrderIndexBigMinAdvancer.class);
    private final byte[] searchMinZOrder;
    private final byte[] searchMaxZOrder;
    private final int zOrderComponentPos;
    private final GeoSpatialLiteralExtension<BigdataValue> litExt;
    private final ZOrderRangeScanUtil rangeScanUtil;
    private final GeoSpatialCounters geoSpatialCounters;
    private transient IKeyBuilder keyBuilder;

    public ZOrderIndexBigMinAdvancer(byte[] searchMinZOrder, byte[] searchMaxZOrder, GeoSpatialLiteralExtension<BigdataValue> litExt, int zOrderComponentPos, GeoSpatialCounters geoSpatialCounters) {
        this.litExt = litExt;
        this.searchMinZOrder = litExt.unpadLeadingZero(searchMinZOrder);
        this.searchMaxZOrder = litExt.unpadLeadingZero(searchMaxZOrder);
        this.zOrderComponentPos = zOrderComponentPos;
        this.geoSpatialCounters = geoSpatialCounters;
        this.rangeScanUtil = new ZOrderRangeScanUtil(this.searchMinZOrder, this.searchMaxZOrder, litExt.getNumDimensions());
    }

    @Override
    protected void advance(ITuple<SPO> tuple) {
        if (this.keyBuilder == null) {
            this.keyBuilder = KeyBuilder.newInstance();
        }
        ITuple<SPO> curTuple = tuple;
        while (curTuple != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Advancor visiting tuple:    " + curTuple));
            }
            long rangeCheckCalStart = System.nanoTime();
            byte[] key = curTuple.getKey();
            this.keyBuilder.reset();
            IV[] ivs = IVUtility.decode(key, this.zOrderComponentPos + 1);
            for (int i = 0; i < ivs.length - 1; ++i) {
                IVUtility.encode(this.keyBuilder, ivs[i]);
            }
            LiteralExtensionIV zOrderIv = (LiteralExtensionIV)ivs[ivs.length - 1];
            byte[] dividingRecord = this.litExt.toZOrderByteArray(zOrderIv.getDelegate());
            boolean inRange = this.rangeScanUtil.isInSearchRange(dividingRecord);
            long rangeCheckCalEnd = System.nanoTime();
            this.geoSpatialCounters.addRangeCheckCalculationTime(rangeCheckCalEnd - rangeCheckCalStart);
            if (!inRange) {
                this.geoSpatialCounters.registerZOrderIndexMiss();
                long bigMinCalStart = System.nanoTime();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("-> tuple " + curTuple + " not in range"));
                }
                byte[] bigMin = this.rangeScanUtil.calculateBigMin(dividingRecord);
                LiteralExtensionIV bigMinIv = this.litExt.createIVFromZOrderByteArray(bigMin);
                IVUtility.encode(this.keyBuilder, bigMinIv);
                long bigMinCalEnd = System.nanoTime();
                this.geoSpatialCounters.addBigMinCalculationTime(bigMinCalEnd - bigMinCalStart);
                try {
                    ITuple next;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("-> advancing to bigmin: " + bigMinIv));
                    }
                    if ((next = this.src.seek(this.keyBuilder.getKey())) == null) {
                        next = this.src.next();
                    }
                    curTuple = next;
                    continue;
                }
                catch (NoSuchElementException e) {
                    throw new KeyOutOfRangeException("Advancer out of search range");
                }
            }
            this.geoSpatialCounters.registerZOrderIndexHit();
            return;
        }
    }
}

