/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTree;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.ISimpleSplitHandler;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.Leaf;
import com.bigdata.btree.Node;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.resources.AbstractResourceManagerTask;
import com.bigdata.resources.BuildResult;
import com.bigdata.resources.IPartitionIdFactory;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.SplitResult;
import com.bigdata.resources.ViewMetadata;
import com.bigdata.service.Event;
import com.bigdata.service.Split;
import com.bigdata.util.BytesUtil;
import com.bigdata.util.concurrent.ExecutionExceptions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SplitUtility {
    private static final Logger log = Logger.getLogger(SplitUtility.class);

    private static int assertEntryCount(long entryCount) {
        if (entryCount >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("More than GT MAX_INT tuples: n=" + entryCount);
        }
        return (int)entryCount;
    }

    public static void validateSplits(IIndex src, Split[] splits) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (splits == null) {
            throw new IllegalArgumentException();
        }
        LocalPartitionMetadata pmd = src.getIndexMetadata().getPartitionMetadata();
        if (pmd == null) {
            throw new IllegalArgumentException();
        }
        SplitUtility.validateSplits(pmd, splits, true);
    }

    public static void validateSplits(LocalPartitionMetadata originalPartitionMetadata, Split[] splits, boolean checkFromToIndex) {
        if (originalPartitionMetadata == null) {
            throw new IllegalArgumentException();
        }
        if (splits == null) {
            throw new IllegalArgumentException("splits[] is null.");
        }
        int nsplits = splits.length;
        if (nsplits <= 1) {
            throw new AssertionError((Object)("Expecting at least two splits, but found " + nsplits));
        }
        int lastToIndex = -1;
        byte[] fromKey = originalPartitionMetadata.getLeftSeparatorKey();
        for (int i = 0; i < nsplits; ++i) {
            Split split = splits[i];
            if (split == null) {
                throw new AssertionError();
            }
            if (split.pmd == null) {
                throw new AssertionError();
            }
            if (!(split.pmd instanceof LocalPartitionMetadata)) {
                throw new AssertionError();
            }
            LocalPartitionMetadata pmd = (LocalPartitionMetadata)split.pmd;
            if (pmd.getLeftSeparatorKey() == null) {
                throw new AssertionError();
            }
            if (!BytesUtil.bytesEqual((byte[])fromKey, (byte[])pmd.getLeftSeparatorKey())) {
                throw new AssertionError();
            }
            if (pmd.getRightSeparatorKey() != null && BytesUtil.compareBytes((byte[])fromKey, (byte[])pmd.getRightSeparatorKey()) >= 0) {
                throw new AssertionError();
            }
            fromKey = pmd.getRightSeparatorKey();
            if (checkFromToIndex) {
                if (i == 0) {
                    if (split.fromIndex != 0) {
                        throw new AssertionError();
                    }
                    if (split.toIndex <= split.fromIndex) {
                        throw new AssertionError();
                    }
                } else if (split.fromIndex != lastToIndex) {
                    throw new AssertionError();
                }
                if (i + 1 == nsplits && split.toIndex == 0) {
                    if (split.ntuples != 0) {
                        throw new AssertionError();
                    }
                    log.warn((Object)"Last split has no definate tuple count");
                } else if (split.toIndex - split.fromIndex != split.ntuples) {
                    throw new AssertionError();
                }
            }
            lastToIndex = split.toIndex;
        }
        if (!BytesUtil.bytesEqual((byte[])originalPartitionMetadata.getLeftSeparatorKey(), (byte[])splits[0].pmd.getLeftSeparatorKey())) {
            throw new AssertionError((Object)("leftSeparator[0]: expected=" + BytesUtil.toString((byte[])originalPartitionMetadata.getLeftSeparatorKey()) + ", actual=" + BytesUtil.toString((byte[])splits[0].pmd.getLeftSeparatorKey())));
        }
        byte[] rightSeparator = ((LocalPartitionMetadata)splits[splits.length - 1].pmd).getRightSeparatorKey();
        if (rightSeparator == null) {
            if (originalPartitionMetadata.getRightSeparatorKey() != null) {
                throw new AssertionError((Object)("rightSeparator for lastSplit: expected=" + BytesUtil.toString((byte[])originalPartitionMetadata.getRightSeparatorKey()) + ", actual=null"));
            }
        } else if (!rightSeparator.equals(originalPartitionMetadata.getRightSeparatorKey())) {
            throw new AssertionError((Object)("rightSeparator for lastSplit: expected=" + BytesUtil.toString((byte[])originalPartitionMetadata.getRightSeparatorKey()) + ", actual=" + BytesUtil.toString((byte[])rightSeparator)));
        }
    }

    public static Split[] tailSplit(ResourceManager resourceManager, BTree btree) {
        byte[] separatorKey;
        if (resourceManager == null) {
            throw new IllegalArgumentException();
        }
        if (btree == null) {
            throw new IllegalArgumentException();
        }
        if (btree.getHeight() == 0) {
            throw new IllegalArgumentException("B+Tree is only a root leaf.");
        }
        String name = btree.getIndexMetadata().getName();
        LocalPartitionMetadata oldpmd = btree.getIndexMetadata().getPartitionMetadata();
        if (oldpmd == null) {
            throw new RuntimeException("Not an index partition?");
        }
        Node node = (Node)btree.getRightMostNode(true);
        boolean childIndex = false;
        Leaf leaf = (Leaf)node.getChild(0);
        byte[] byArray = separatorKey = leaf == null ? null : leaf.getKeys().get(0);
        if (leaf == null || separatorKey == null) {
            throw new RuntimeException("Could not locate separator key? Node=" + node + ", nchildren=" + node.getChildCount() + ", childIndex=" + 0 + ", leaf=" + leaf + (leaf == null ? "" : "nkeys=" + leaf.getKeyCount() + ", keys=" + leaf.getKeys()));
        }
        int separatorIndex = SplitUtility.assertEntryCount(btree.indexOf(separatorKey));
        assert (separatorIndex >= 0);
        Split[] splits = new Split[2];
        int partitionId = resourceManager.nextPartitionId(name);
        byte[] fromKey = oldpmd.getLeftSeparatorKey();
        LocalPartitionMetadata pmd = new LocalPartitionMetadata(partitionId, -1, fromKey, separatorKey, null, null);
        boolean fromIndex = false;
        splits[0] = new Split(pmd, 0, separatorIndex);
        partitionId = resourceManager.nextPartitionId(name);
        byte[] toKey = oldpmd.getRightSeparatorKey();
        pmd = new LocalPartitionMetadata(partitionId, -1, separatorKey, toKey, null, null);
        splits[1] = new Split(pmd, separatorIndex, (int)btree.getEntryCount());
        return splits;
    }

    public static SplitResult buildSplits(ViewMetadata vmd, Split[] splits, Event parentEvent) throws InterruptedException, ExecutionExceptions {
        if (vmd == null) {
            throw new IllegalArgumentException();
        }
        if (splits == null) {
            throw new IllegalArgumentException();
        }
        int nsplits = splits.length;
        ArrayList<BuildIndexSegmentSplitTask> tasks = new ArrayList<BuildIndexSegmentSplitTask>(nsplits);
        for (int i = 0; i < splits.length; ++i) {
            Split split = splits[i];
            BuildIndexSegmentSplitTask task = new BuildIndexSegmentSplitTask(vmd, split, parentEvent);
            tasks.add(task);
        }
        List futures = vmd.resourceManager.getConcurrencyManager().invokeAll(tasks);
        BuildResult[] buildResults = new BuildResult[nsplits];
        LinkedList<Throwable> causes = new LinkedList<Throwable>();
        int i = 0;
        for (Future f : futures) {
            try {
                buildResults[i] = (BuildResult)f.get();
            }
            catch (Throwable t) {
                causes.add(t);
                log.error((Object)t.getLocalizedMessage());
            }
            ++i;
        }
        if (!causes.isEmpty()) {
            for (BuildResult result : buildResults) {
                if (result == null) continue;
                vmd.resourceManager.retentionSetRemove(result.segmentMetadata.getUUID());
                vmd.resourceManager.deleteResource(result.segmentMetadata.getUUID(), false);
            }
            throw new ExecutionExceptions(causes);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Generated " + splits.length + " index segments: name=" + vmd.name));
        }
        SplitResult result = new SplitResult(vmd.name, vmd.indexMetadata, splits, buildResults);
        return result;
    }

    public static Split[] getSplits(IPartitionIdFactory partitionIdFactory, LocalPartitionMetadata oldpmd, IndexSegment seg, long nominalShardSize, ISimpleSplitHandler splitHandler) {
        if (partitionIdFactory == null) {
            throw new IllegalArgumentException();
        }
        if (oldpmd == null) {
            throw new IllegalArgumentException();
        }
        if (seg == null) {
            throw new IllegalArgumentException();
        }
        if (nominalShardSize <= 0L) {
            throw new IllegalArgumentException();
        }
        if (!seg.getStore().getCheckpoint().compactingMerge) {
            throw new IllegalArgumentException();
        }
        int N1 = (int)((double)seg.getStore().size() / ((double)nominalShardSize / 2.0));
        if (N1 < 2) {
            return null;
        }
        int entryCount = SplitUtility.assertEntryCount(seg.getEntryCount());
        int N = entryCount < N1 ? entryCount : N1;
        String scaleOutIndexName = seg.getIndexMetadata().getName();
        if (log.isInfoEnabled()) {
            log.info((Object)("segSize=" + seg.getStore().size() + ", nominalShardSize=" + nominalShardSize + ", N1=" + N1 + ", entryCount=" + entryCount + ", N=" + N + (N != N1 ? " [#splits adjusted down to the entryCount]." : "")));
        }
        ArrayList<Split> splits = new ArrayList<Split>(N);
        int low = 0;
        int high = entryCount - 1;
        byte[] lastSeparatorKey = oldpmd.getLeftSeparatorKey();
        boolean didLastSplit = false;
        while (low < high) {
            int toIndex;
            byte[] toKey;
            int rangeCount = high - low + 1;
            int splitCount = splits.size();
            int remainingSplits = N - splitCount;
            int fromIndex = low;
            byte[] fromKey = lastSeparatorKey;
            if (remainingSplits == 1) {
                toKey = oldpmd.getRightSeparatorKey();
                toIndex = high;
                didLastSplit = true;
            } else {
                int splitAt = rangeCount / remainingSplits + low;
                assert (splitAt > low && splitAt <= high) : "low=" + low + ", high=" + high + ", splitAt=" + splitAt;
                if (splitHandler != null) {
                    byte[] chosenKey = splitHandler.getSeparatorKey(seg, fromIndex, high + 1, splitAt);
                    if (chosenKey == null) {
                        double overextension = (double)seg.getStore().size() / (double)nominalShardSize;
                        if (splits.isEmpty() && overextension > 2.0) {
                            log.error((Object)("Segment overextended: " + overextension + "x : application refuses to split shard: " + scaleOutIndexName + "#" + oldpmd.getPartitionId()));
                        }
                        if (splits.isEmpty()) {
                            return null;
                        }
                        toKey = oldpmd.getRightSeparatorKey();
                        toIndex = high;
                        didLastSplit = true;
                    } else {
                        int pos = SplitUtility.assertEntryCount(seg.indexOf(chosenKey));
                        int n = toIndex = pos < 0 ? -(pos + 1) : pos;
                        if (toIndex < low || toIndex > high) {
                            throw new RuntimeException("bad split override: name=" + scaleOutIndexName + ", fromIndex=" + fromIndex + ", toIndex=" + (high + 1) + ", recommendedSplitAt=" + splitAt + ", but split choose at " + toIndex);
                        }
                        if (toIndex == high) {
                            toKey = oldpmd.getRightSeparatorKey();
                            didLastSplit = true;
                        } else {
                            toKey = chosenKey;
                        }
                    }
                } else {
                    if (splitAt == high) {
                        toKey = oldpmd.getRightSeparatorKey();
                        didLastSplit = true;
                    } else {
                        toKey = seg.keyAt(splitAt);
                    }
                    toIndex = splitAt;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("splitCount=" + splitCount + ", remainingSplits=" + remainingSplits + ", low=" + low + ", high=" + high + ", rangeCount=" + rangeCount + ", fromIndex=" + fromIndex + ", toIndex=" + toIndex + ", ntuples=" + (toIndex - fromIndex) + ", separatorKey=" + BytesUtil.toString((byte[])toKey)));
            }
            int partitionId = partitionIdFactory.nextPartitionId(scaleOutIndexName);
            LocalPartitionMetadata newpmd = new LocalPartitionMetadata(partitionId, -1, fromKey, toKey, null, null);
            Split split = new Split(newpmd, fromIndex, toIndex);
            splits.add(split);
            low = toIndex;
            lastSeparatorKey = toKey;
        }
        if (!didLastSplit) {
            throw new AssertionError();
        }
        return splits.toArray(new Split[splits.size()]);
    }

    protected static class BuildIndexSegmentSplitTask
    extends AbstractResourceManagerTask<BuildResult> {
        private final ViewMetadata vmd;
        private final Split split;
        private final Event parentEvent;

        public BuildIndexSegmentSplitTask(ViewMetadata vmd, Split split, Event parentEvent) {
            super(vmd.resourceManager, TimestampUtility.asHistoricalRead(vmd.commitTime), vmd.name);
            if (split == null) {
                throw new IllegalArgumentException();
            }
            this.vmd = vmd;
            this.split = split;
            this.parentEvent = parentEvent;
        }

        @Override
        protected BuildResult doTask() throws Exception {
            if (this.resourceManager.isOverflowAllowed()) {
                throw new IllegalStateException();
            }
            String name = this.getOnlyResource();
            ILocalBTreeView src = this.getIndex(name);
            if (log.isInfoEnabled()) {
                BTree btree = src.getMutableBTree();
                log.info((Object)("src=" + name + ",counter=" + src.getCounter().get() + ",checkpoint=" + btree.getCheckpoint()));
            }
            LocalPartitionMetadata pmd = (LocalPartitionMetadata)this.split.pmd;
            byte[] fromKey = pmd.getLeftSeparatorKey();
            byte[] toKey = pmd.getRightSeparatorKey();
            if (fromKey == null && toKey == null) {
                throw new RuntimeException("Not a key-range?");
            }
            BuildResult result = this.resourceManager.buildIndexSegment(name, src, true, this.vmd.commitTime, fromKey, toKey, this.parentEvent);
            return result;
        }
    }
}

