/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.Banner;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.RelationSchema;
import com.bigdata.sparse.ITPS;
import info.aduna.iteration.CloseableIteration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.sail.SailException;

public class ExportKB {
    private static final Logger log = Logger.getLogger(ExportKB.class);
    private final AbstractTripleStore kb;
    private final String namespace;
    private final File kbdir;
    private final RDFFormat format;
    private final boolean includeInferred;

    public ExportKB(AbstractTripleStore kb, File kbdir, RDFFormat format, boolean includeInferred) {
        if (kb == null) {
            throw new IllegalArgumentException("KB not specified.");
        }
        if (kbdir == null) {
            throw new IllegalArgumentException("Output directory not specified.");
        }
        if (format == null) {
            throw new IllegalArgumentException("RDFFormat not specified.");
        }
        if (kb.isStatementIdentifiers() && !RDFFormat.RDFXML.equals((Object)format)) {
            throw new IllegalArgumentException("SIDs mode requires RDF/XML interchange.");
        }
        if (kb.isQuads() && !format.supportsContexts()) {
            throw new IllegalArgumentException("RDFFormat does not support quads: " + format);
        }
        this.kb = kb;
        this.namespace = kb.getNamespace();
        this.kbdir = kbdir;
        this.format = format;
        this.includeInferred = includeInferred;
    }

    private static String munge(String s) {
        return s.replaceAll("[\\W]", "_");
    }

    public void export() throws IOException, SailException, RDFHandlerException {
        System.out.println("Effective output directory: " + this.kbdir);
        this.prepare();
        this.exportProperties();
        this.exportData();
    }

    public void prepare() throws IOException {
        if (!this.kbdir.exists() && !this.kbdir.mkdirs()) {
            throw new IOException("Could not create directory: " + this.kbdir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportProperties() throws IOException {
        this.prepare();
        StringBuilder comments = new StringBuilder("Configuration properties.\n");
        if (this.kb.getIndexManager() instanceof IRawStore) {
            comments.append("source=" + ((IRawStore)((Object)this.kb.getIndexManager())).getFile() + "\n");
            comments.append("namespace=" + this.namespace + "\n");
            comments.append("timestamp=" + this.kb.getTimestamp() + "\n");
            comments.append("fastStatementCount=" + this.kb.getStatementCount(false) + "\n");
            comments.append("uriCount=" + this.kb.getURICount() + "\n");
            comments.append("literalCount=" + this.kb.getLiteralCount() + "\n");
            comments.append("bnodeCount=" + this.kb.getBNodeCount() + "\n");
        }
        Properties properties = ExportKB.flatCopy(this.kb.getProperties());
        File file = new File(this.kbdir, "kb.properties");
        System.out.println("Writing " + file);
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            properties.store(os, comments.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportData() throws IOException, SailException, RDFHandlerException {
        this.prepare();
        BigdataSail sail = new BigdataSail(this.kb);
        try {
            sail.initialize();
            try (BigdataSail.BigdataSailConnection conn = sail.getReadOnlyConnection();
                 CloseableIteration itr = conn.getStatements(null, null, null, this.includeInferred, new Resource[0]);){
                File file = new File(this.kbdir, "data." + this.format.getDefaultFileExtension() + ".gz");
                System.out.println("Writing " + file);
                try (GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(file));){
                    RDFWriter writer = ((RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)this.format)).getWriter((OutputStream)os);
                    writer.startRDF();
                    while (itr.hasNext()) {
                        Statement stmt = (Statement)itr.next();
                        writer.handleStatement(stmt);
                    }
                    writer.endRDF();
                }
            }
        }
        finally {
            sail.shutDown();
        }
    }

    static List<String> getNamespaces(IIndexManager indexManager) {
        LinkedList<String> namespaces = new LinkedList<String>();
        Iterator<? extends ITPS> itr = indexManager.getGlobalRowStore().rangeIterator(RelationSchema.INSTANCE);
        while (itr.hasNext()) {
            ITPS tps = itr.next();
            String namespace = (String)tps.getPrimaryKey();
            String className = (String)tps.get(RelationSchema.CLASS).getValue();
            try {
                Class<?> cls = Class.forName(className);
                if (!AbstractTripleStore.class.isAssignableFrom(cls)) continue;
                namespaces.add(namespace);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return namespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File file) throws IOException {
        Properties p = new Properties();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            p.load(is);
        }
        return p;
    }

    public static Properties flatCopy(Properties props) {
        Properties tmp = new Properties();
        tmp.putAll(ExportKB.flatten(props));
        return tmp;
    }

    private static Map<String, String> flatten(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            String propertyValue = properties.getProperty(property);
            if (propertyValue == null) continue;
            out.put(property, propertyValue);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String[] overrides;
        String s;
        Banner.banner();
        boolean nothing = false;
        boolean includeInferred = false;
        RDFFormat format = null;
        File propertyFile = null;
        File outdir = new File(".");
        LinkedList<String> namespaces = new LinkedList<String>();
        int i = 0;
        while (i < args.length && (s = args[i]).startsWith("-")) {
            ++i;
            if (s.equals("-n")) {
                nothing = true;
                continue;
            }
            if (s.equals("-help")) {
                ExportKB.usage();
                System.exit(0);
                continue;
            }
            if (s.equals("-format")) {
                format = RDFFormat.valueOf((String)args[i++]);
                continue;
            }
            if (s.equals("-includeInferred")) {
                includeInferred = true;
                continue;
            }
            if (s.equals("-outdir")) {
                outdir = new File(args[i++]);
                continue;
            }
            System.err.println("Unknown option: " + s);
            ExportKB.usage();
            System.exit(1);
        }
        if (i == args.length) {
            ExportKB.usage();
            System.exit(1);
        } else if (!(propertyFile = new File(args[i++])).exists()) {
            System.err.println("No such file: " + propertyFile);
            System.exit(1);
        }
        Properties properties = ExportKB.loadProperties(propertyFile);
        for (String s2 : overrides = new String[]{Options.FILE}) {
            if (System.getProperty(s2) == null) continue;
            String v = System.getProperty(s2);
            System.out.println("Using: " + s2 + "=" + v);
            properties.setProperty(s2, v);
        }
        try (Journal indexManager = new Journal(properties);){
            long commitTime = indexManager.getLastCommitTime();
            if (i == args.length) {
                namespaces.addAll(ExportKB.getNamespaces(indexManager));
            } else {
                while (i < args.length) {
                    String namespace = args[i++];
                    Object kb = indexManager.getResourceLocator().locate(namespace, commitTime);
                    if (kb == null) {
                        throw new RuntimeException("No such namespace: " + namespace);
                    }
                    if (!(kb instanceof AbstractTripleStore)) {
                        throw new RuntimeException("Not a KB: " + namespace);
                    }
                    namespaces.add(namespace);
                }
            }
            for (String namespace : namespaces) {
                AbstractTripleStore kb = (AbstractTripleStore)indexManager.getResourceLocator().locate(namespace, commitTime);
                File kbdir = new File(outdir, ExportKB.munge(namespace));
                RDFFormat fmt = format;
                if (fmt == null) {
                    fmt = kb.isStatementIdentifiers() ? RDFFormat.RDFXML : (kb.isQuads() ? RDFFormat.TRIX : RDFFormat.RDFXML);
                }
                System.out.println("Exporting " + namespace + " as " + fmt.getName() + " on " + kbdir);
                if (nothing) continue;
                new ExportKB(kb, kbdir, fmt, includeInferred).export();
            }
            System.out.println("Done");
        }
    }

    private static void usage() {
        System.err.println("usage: [options] propertyFile namespace*");
    }
}

