/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.NV;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import java.util.UUID;

public class UUIDBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 9136864442064392445L;

    public UUIDBOp(GlobalAnnotations globals, boolean str) {
        this(BOp.NOARGS, UUIDBOp.anns(globals, new NV(Annotations.STR, str)));
    }

    public UUIDBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public UUIDBOp(UUIDBOp op) {
        super(op);
    }

    public final IV get(IBindingSet bs) {
        BigdataValueFactory vf = super.getValueFactory();
        UUID uuid = UUID.randomUUID();
        if (this.str()) {
            BigdataLiteral l = vf.createLiteral(uuid.toString());
            return DummyConstantNode.toDummyIV(l);
        }
        BigdataURI uri = vf.createURI("urn:uuid:" + uuid.toString());
        return DummyConstantNode.toDummyIV(uri);
    }

    public boolean str() {
        return (Boolean)this.getProperty(Annotations.STR);
    }

    @Override
    public String toString() {
        return this.str() ? "struuid()" : "uuid()";
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.NEVER;
    }

    public static interface Annotations
    extends BOp.Annotations {
        public static final String STR = UUIDBOp.class.getName() + ".str";
    }
}

