/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import java.math.BigInteger;
import org.apache.log4j.Logger;

public class InlineSignedIntegerURIHandler
extends InlineURIHandler {
    private static final Logger log = Logger.getLogger(InlineSignedIntegerURIHandler.class);
    private static final BigInteger MIN_LONG_AS_BIGINT = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_LONG_AS_BIGINT = BigInteger.valueOf(Long.MAX_VALUE);

    public InlineSignedIntegerURIHandler(String namespace) {
        super(namespace);
    }

    @Override
    protected AbstractLiteralIV createInlineIV(String localName) {
        BigInteger value;
        try {
            value = new BigInteger(localName, 10);
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid integer", (Throwable)e);
            }
            return null;
        }
        return InlineSignedIntegerURIHandler.createInlineIV(value);
    }

    public static AbstractLiteralIV createInlineIV(BigInteger value) {
        if (value.compareTo(MIN_LONG_AS_BIGINT) < 0 || value.compareTo(MAX_LONG_AS_BIGINT) > 0) {
            return new XSDIntegerIV(value);
        }
        return InlineSignedIntegerURIHandler.createInlineIV(value.longValue());
    }

    public static AbstractLiteralIV createInlineIV(long value) {
        if (-128L <= value && value <= 127L) {
            return new XSDNumericIV((byte)value);
        }
        if (-32768L <= value && value <= 32767L) {
            return new XSDNumericIV((short)value);
        }
        if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            return new XSDNumericIV((int)value);
        }
        return new XSDNumericIV(value);
    }
}

