/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.results;

import java.sql.SQLException;
import org.apache.jena.jdbc.results.JenaResultSet;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.apache.jena.query.QueryExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryExecutionResults
extends JenaResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryExecutionResults.class);
    private QueryExecution qe;
    private boolean commit = false;

    public QueryExecutionResults(JenaStatement statement, QueryExecution qe, boolean commit) throws SQLException {
        super(statement);
        if (qe == null) {
            throw new SQLException("Query Execution cannot be null");
        }
        this.qe = qe;
        this.commit = commit;
    }

    @Override
    public final void close() throws SQLException {
        if (this.qe != null) {
            try {
                this.qe.close();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error closing underlying Jena query execution", (Throwable)e);
                throw new SQLException("Unexpected error closing the query execution", e);
            }
            finally {
                this.qe = null;
                if (this.commit) {
                    LOGGER.info("Result Set associated with an auto-committing transaction, performing a commit now");
                    this.getStatement().getConnection().commit();
                }
            }
        }
        this.closeInternal();
    }

    protected abstract void closeInternal() throws SQLException;

    @Override
    public final boolean isClosed() {
        return this.qe == null;
    }
}

