/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.collection;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class WeakSoftTable {
    private final Map hash = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    private void processQueue() {
        Reference ref;
        while ((ref = this.queue.poll()) != null) {
            if (!(ref instanceof RemovableReference)) continue;
            ((RemovableReference)((Object)ref)).cleared(this.hash);
        }
    }

    public SoftValue get(WeakKey key, int index) {
        List list = (List)this.hash.get(key);
        if (list != null && index < list.size()) {
            return (SoftValue)list.get(index);
        }
        return null;
    }

    public void add(WeakKey key, SoftValue value) {
        this.processQueue();
        LinkedList<RemovableReference> list = (LinkedList<RemovableReference>)this.hash.get(key);
        if (list == null) {
            list = new LinkedList<RemovableReference>();
            this.hash.put(key.copy(this.queue), list);
        }
        list.add(value.copy(this.queue));
    }

    public SoftValue remove(WeakKey key, int index) {
        this.processQueue();
        List list = (List)this.hash.get(key);
        if (list != null && index < list.size()) {
            return (SoftValue)list.remove(index);
        }
        return null;
    }

    public String toString() {
        return this.hash.toString();
    }

    public static class SoftValue
    extends SoftReference
    implements RemovableReference {
        protected final WeakKey key;

        public SoftValue(WeakKey key, Object value) {
            super(value);
            this.key = key;
        }

        protected SoftValue(SoftValue softValue, ReferenceQueue queue) {
            super(softValue.get(), queue);
            this.key = softValue.key;
        }

        public RemovableReference copy(ReferenceQueue queue) {
            return new SoftValue(this, queue);
        }

        public void cleared(Map map) {
            List list = (List)map.get(this.key);
            if (list != null && list.remove(this) && list.isEmpty()) {
                map.remove(this.key);
            }
        }
    }

    public static class WeakKey
    extends WeakReference
    implements RemovableReference {
        private final boolean nullKey;
        private final int hashCode;

        public WeakKey(Object key) {
            super(key);
            this.nullKey = key == null;
            this.hashCode = this.getClass().hashCode() ^ System.identityHashCode(key);
        }

        protected WeakKey(WeakKey weakKey, ReferenceQueue queue) {
            super(weakKey.get(), queue);
            this.nullKey = weakKey.nullKey;
            this.hashCode = weakKey.hashCode;
        }

        public RemovableReference copy(ReferenceQueue queue) {
            return new WeakKey(this, queue);
        }

        public void cleared(Map map) {
            map.remove(this);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            WeakKey weakKey = (WeakKey)o;
            if (weakKey.nullKey != this.nullKey) {
                return false;
            }
            if (this.nullKey) {
                return true;
            }
            Object key = weakKey.get();
            return key != null && key == this.get();
        }
    }

    public static interface RemovableReference {
        public RemovableReference copy(ReferenceQueue var1);

        public void cleared(Map var1);
    }
}

