/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.timeseries;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.jooq.CreateTableColumnStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertValuesStep4;
import org.jooq.InsertValuesStepN;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeries;

public class TimeSeriesRDBClient<T> {
    private String rdbURL = null;
    private String rdbUser = null;
    private String rdbPassword = null;
    private Connection conn = null;
    private DSLContext context;
    private final Field<T> timeColumn;
    private static final SQLDialect dialect = SQLDialect.POSTGRES;
    private static final String dbTableName = "dbTable";
    private static final Field<String> dataIRIcolumn = DSL.field(DSL.name("dataIRI"), String.class);
    private static final Field<String> tsIRIcolumn = DSL.field(DSL.name("timeseriesIRI"), String.class);
    private static final Field<String> tsTableNameColumn = DSL.field(DSL.name("tableName"), String.class);
    private static final Field<String> columnNameColumn = DSL.field(DSL.name("columnName"), String.class);
    private final String exceptionPrefix = this.getClass().getSimpleName() + ": ";

    public TimeSeriesRDBClient(Class<T> timeClass) {
        this.timeColumn = DSL.field(DSL.name("time"), timeClass);
    }

    public void setRdbURL(String rdbURL) {
        this.rdbURL = rdbURL;
    }

    public String getRdbURL() {
        return this.rdbURL;
    }

    public void setRdbUser(String user) {
        this.rdbUser = user;
    }

    public String getRdbUser() {
        return this.rdbUser;
    }

    public void setRdbPassword(String password) {
        this.rdbPassword = password;
    }

    protected void loadRdbConfigs(String filepath) throws IOException {
        block16: {
            File file = new File(filepath);
            if (!file.exists()) {
                throw new JPSRuntimeException(this.exceptionPrefix + "No properties file found at specified filepath: " + filepath);
            }
            try (FileInputStream input = new FileInputStream(file);){
                Properties prop = new Properties();
                prop.load(input);
                if (!prop.containsKey("db.url")) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"db.url=<rdb_url>\" ");
                }
                this.setRdbURL(prop.getProperty("db.url"));
                if (!prop.containsKey("db.user")) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"db.user=<rdb_username>\" ");
                }
                this.setRdbUser(prop.getProperty("db.user"));
                if (prop.containsKey("db.password")) {
                    this.setRdbPassword(prop.getProperty("db.password"));
                    break block16;
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"db.password=<rdb_password>\" ");
            }
        }
    }

    protected void initTimeSeriesTable(List<String> dataIRI, List<Class<?>> dataClass, String tsIRI) {
        String tsTableName = UUID.randomUUID().toString();
        this.connect();
        try {
            String condition = String.format("table_name = '%s'", dbTableName);
            if (this.context.select(DSL.count()).from("information_schema.tables").where(condition).fetchOne(0, Integer.TYPE) == 0) {
                this.initCentralTable();
            }
            for (String s : dataIRI) {
                if (!this.checkDataHasTimeSeries(s)) continue;
                throw new JPSRuntimeException(this.exceptionPrefix + "<" + s + "> already has an assigned time series instance");
            }
            if (dataIRI.size() != dataClass.size()) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Length of dataClass is different from number of data IRIs");
            }
            HashMap<String, String> dataColumnNames = new HashMap<String, String>();
            int i = 1;
            for (String s : dataIRI) {
                dataColumnNames.put(s, "column" + i);
                ++i;
            }
            this.populateCentralTable(tsTableName, dataIRI, dataColumnNames, tsIRI);
            this.createEmptyTimeSeriesTable(tsTableName, dataColumnNames, dataIRI, dataClass);
        }
        catch (JPSRuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (Exception e) {
            this.disconnect();
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    protected void addTimeSeriesData(TimeSeries<T> ts) {
        List<String> dataIRI = ts.getDataIRIs();
        this.connect();
        try {
            String condition = String.format("table_name = '%s'", dbTableName);
            if (this.context.select(DSL.count()).from("information_schema.tables").where(condition).fetchOne(0, Integer.TYPE) == 0) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Central RDB lookup table has not been initialised yet");
            }
            this.checkDataIsInSameTable(dataIRI);
            String tsTableName = this.getTimeseriesTableName(dataIRI.get(0));
            HashMap<String, String> dataColumnNames = new HashMap<String, String>();
            for (String s : dataIRI) {
                dataColumnNames.put(s, this.getColumnName(s));
            }
            this.populateTimeSeriesTable(tsTableName, ts, dataColumnNames);
        }
        catch (JPSRuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (Exception e) {
            this.disconnect();
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    public TimeSeries<T> getTimeSeriesWithinBounds(List<String> dataIRI, T lowerBound, T upperBound) {
        this.connect();
        try {
            String condition = String.format("table_name = '%s'", dbTableName);
            if (this.context.select(DSL.count()).from("information_schema.tables").where(condition).fetchOne(0, Integer.TYPE) == 0) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Central RDB lookup table has not been initialised yet");
            }
            this.checkDataIsInSameTable(dataIRI);
            Table<?> table = this.getTimeseriesTable(dataIRI.get(0));
            HashMap<String, Field<Object>> dataColumnFields = new HashMap<String, Field<Object>>();
            for (String string : dataIRI) {
                String columnName = this.getColumnName(string);
                Field<Object> field = DSL.field(DSL.name(columnName));
                dataColumnFields.put(string, field);
            }
            ArrayList<Field<Object>> columnList = new ArrayList<Field<Object>>();
            columnList.add(this.timeColumn);
            for (String data : dataIRI) {
                columnList.add((Field<Object>)dataColumnFields.get(data));
            }
            if (lowerBound == null) {
                lowerBound = this.context.select(DSL.min(this.timeColumn)).from((TableLike<?>)table).fetch(DSL.min(this.timeColumn)).get(0);
            }
            if (upperBound == null) {
                upperBound = this.context.select(DSL.max(this.timeColumn)).from((TableLike<?>)table).fetch(DSL.max(this.timeColumn)).get(0);
            }
            Result result = this.context.select(columnList).from((TableLike<?>)table).where(this.timeColumn.between(lowerBound, upperBound)).orderBy(this.timeColumn.asc()).fetch();
            List<T> timeValues = result.getValues(this.timeColumn);
            ArrayList dataValues = new ArrayList();
            for (String data : dataIRI) {
                List column = result.getValues((Field)dataColumnFields.get(data));
                dataValues.add(column);
            }
            return new TimeSeries<T>(timeValues, dataIRI, dataValues);
        }
        catch (JPSRuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (Exception e) {
            this.disconnect();
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    public TimeSeries<T> getTimeSeries(List<String> dataIRI) {
        return this.getTimeSeriesWithinBounds(dataIRI, null, null);
    }

    public double getAverage(String dataIRI) {
        return this.getAggregate(dataIRI, AggregateFunction.AVERAGE);
    }

    public double getMaxValue(String dataIRI) {
        return this.getAggregate(dataIRI, AggregateFunction.MAX);
    }

    public double getMinValue(String dataIRI) {
        return this.getAggregate(dataIRI, AggregateFunction.MIN);
    }

    public T getMaxTime(String dataIRI) {
        this.connect();
        try {
            Table<?> table = this.getTimeseriesTable(dataIRI);
            List<T> queryResult = this.context.select(DSL.max(this.timeColumn)).from((TableLike<?>)table).fetch(DSL.max(this.timeColumn));
            return queryResult.get(0);
        }
        catch (JPSRuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (Exception e) {
            this.disconnect();
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    public T getMinTime(String dataIRI) {
        this.connect();
        try {
            Table<?> table = this.getTimeseriesTable(dataIRI);
            List<T> queryResult = this.context.select(DSL.min(this.timeColumn)).from((TableLike<?>)table).fetch(DSL.min(this.timeColumn));
            return queryResult.get(0);
        }
        catch (JPSRuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (Exception e) {
            this.disconnect();
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    protected void deleteRows(String dataIRI, T lowerBound, T upperBound) {
        this.connect();
        try {
            Table<?> table = this.getTimeseriesTable(dataIRI);
            this.context.delete(table).where(this.timeColumn.between(lowerBound, upperBound)).execute();
        }
        catch (JPSRuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (Exception e) {
            this.disconnect();
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    protected void deleteTimeSeries(String dataIRI) {
        this.connect();
        try {
            String columnName = this.getColumnName(dataIRI);
            String tsTableName = this.getTimeseriesTableName(dataIRI);
            String condition = String.format("table_name = '%s'", tsTableName);
            if (this.context.select(DSL.count()).from("information_schema.columns").where(condition).fetchOne(0, Integer.TYPE) > 2) {
                this.context.alterTable(tsTableName).drop(columnName).execute();
                Table<Record> dbTable = DSL.table(DSL.name(dbTableName));
                this.context.delete(dbTable).where(dataIRIcolumn.equal(dataIRI)).execute();
            } else {
                this.deleteTimeSeriesTable(dataIRI);
            }
        }
        catch (JPSRuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (Exception e) {
            this.disconnect();
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    protected void deleteTimeSeriesTable(String dataIRI) {
        this.connect();
        try {
            String tsIRI = this.getTimeSeriesIRI(dataIRI);
            String tsTableName = this.getTimeseriesTableName(dataIRI);
            this.context.dropTable(DSL.table(DSL.name(tsTableName))).execute();
            Table<Record> dbTable = DSL.table(DSL.name(dbTableName));
            this.context.delete(dbTable).where(tsIRIcolumn.equal(tsIRI)).execute();
        }
        catch (JPSRuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (Exception e) {
            this.disconnect();
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    protected void deleteAll() {
        this.connect();
        try {
            String condition = String.format("table_name = '%s'", dbTableName);
            if (this.context.select(DSL.count()).from("information_schema.tables").where(condition).fetchOne(0, Integer.TYPE) == 1) {
                Table<Record> dbTable = DSL.table(DSL.name(dbTableName));
                List<String> queryResult = this.context.selectDistinct(tsTableNameColumn).from((TableLike<?>)dbTable).fetch(tsTableNameColumn);
                if (!queryResult.isEmpty()) {
                    for (String table : queryResult) {
                        this.context.dropTable(DSL.table(DSL.name(table))).execute();
                    }
                    this.context.dropTable(dbTable).execute();
                }
            }
        }
        catch (Exception e) {
            this.disconnect();
            throw new JPSRuntimeException("Error while executing SQL command", e);
        }
    }

    protected void connect() {
        try {
            if (this.conn == null || this.conn.isClosed()) {
                Class.forName("org.postgresql.Driver");
                this.conn = DriverManager.getConnection(this.rdbURL, this.rdbUser, this.rdbPassword);
                this.context = DSL.using(this.conn, dialect);
                System.out.println("Connecting successful: " + this.rdbURL);
            }
        }
        catch (Exception e) {
            System.out.println("Connecting failed: " + this.rdbURL);
            throw new JPSRuntimeException(this.exceptionPrefix + "Establishing database connection failed");
        }
    }

    void disconnect() {
        try {
            this.conn.close();
            System.out.println("Disconnecting successful");
        }
        catch (Exception e) {
            System.out.println("Disconnecting failed");
            throw new JPSRuntimeException(this.exceptionPrefix + "Closing database connection failed");
        }
    }

    private void initCentralTable() {
        this.context.createTableIfNotExists(dbTableName).column(dataIRIcolumn).column(tsIRIcolumn).column(tsTableNameColumn).column(columnNameColumn).execute();
    }

    private void populateCentralTable(String tsTable, List<String> dataIRI, Map<String, String> dataColumnNames, String tsIRI) {
        InsertValuesStep4<Record, String, String, String, String> insertValueStep = this.context.insertInto(DSL.table(DSL.name(dbTableName)), dataIRIcolumn, tsIRIcolumn, tsTableNameColumn, columnNameColumn);
        for (String s : dataIRI) {
            insertValueStep = insertValueStep.values(s, tsIRI, tsTable, dataColumnNames.get(s));
        }
        insertValueStep.execute();
    }

    private void createEmptyTimeSeriesTable(String tsTable, Map<String, String> dataColumnNames, List<String> dataIRI, List<Class<?>> dataClass) {
        CreateTableColumnStep createStep = this.context.createTableIfNotExists(tsTable);
        createStep = createStep.column(this.timeColumn);
        for (int i = 0; i < dataIRI.size(); ++i) {
            createStep = createStep.column(dataColumnNames.get(dataIRI.get(i)), DefaultDataType.getDataType(dialect, dataClass.get(i)));
        }
        createStep.execute();
    }

    private void populateTimeSeriesTable(String tsTable, TimeSeries<T> ts, Map<String, String> dataColumnNames) {
        List<String> dataIRIs = ts.getDataIRIs();
        Table<Record> table = DSL.table(DSL.name(tsTable));
        ArrayList<Field<T>> columnList = new ArrayList<Field<T>>();
        columnList.add(this.timeColumn);
        for (String data : dataIRIs) {
            columnList.add(DSL.field(DSL.name(dataColumnNames.get(data))));
        }
        InsertValuesStepN<Record> insertValueStep = this.context.insertInto(table, columnList);
        for (int i = 0; i < ts.getTimes().size(); ++i) {
            Object[] newValues = new Object[dataIRIs.size() + 1];
            newValues[0] = ts.getTimes().get(i);
            for (int j = 0; j < ts.getDataIRIs().size(); ++j) {
                newValues[j + 1] = ts.getValues(dataIRIs.get(j)).get(i);
            }
            insertValueStep = insertValueStep.values(newValues);
        }
        insertValueStep.execute();
    }

    boolean checkDataHasTimeSeries(String dataIRI) {
        this.connect();
        Table<Record> table = DSL.table(DSL.name(dbTableName));
        return this.context.fetchExists(DSL.selectFrom(table).where(dataIRIcolumn.eq(dataIRI)));
    }

    private void checkDataIsInSameTable(List<String> dataIRI) {
        String tsIRI = this.getTimeSeriesIRI(dataIRI.get(0));
        if (dataIRI.size() > 1) {
            for (int i = 1; i < dataIRI.size(); ++i) {
                String curTsIRI = this.getTimeSeriesIRI(dataIRI.get(i));
                if (curTsIRI.contentEquals(tsIRI)) continue;
                throw new JPSRuntimeException(this.exceptionPrefix + "Provided data is not within the same RDB table");
            }
        }
    }

    private String getTimeSeriesIRI(String dataIRI) {
        try {
            Table<Record> table = DSL.table(DSL.name(dbTableName));
            List<String> queryResult = this.context.select(tsIRIcolumn).from((TableLike<?>)table).where(dataIRIcolumn.eq(dataIRI)).fetch(tsIRIcolumn);
            return queryResult.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + "<" + dataIRI + "> does not have an assigned time series instance");
        }
    }

    private String getColumnName(String dataIRI) {
        try {
            Table<Record> table = DSL.table(DSL.name(dbTableName));
            List<String> queryResult = this.context.select(columnNameColumn).from((TableLike<?>)table).where(dataIRIcolumn.eq(dataIRI)).fetch(columnNameColumn);
            return queryResult.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + "<" + dataIRI + "> does not have an assigned time series instance");
        }
    }

    private String getTimeseriesTableName(String dataIRI) {
        try {
            Table<Record> table = DSL.table(DSL.name(dbTableName));
            List<String> queryResult = this.context.select(tsTableNameColumn).from((TableLike<?>)table).where(dataIRIcolumn.eq(dataIRI)).fetch(tsTableNameColumn);
            return queryResult.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + "<" + dataIRI + "> does not have an assigned time series instance");
        }
    }

    private Table<?> getTimeseriesTable(String dataIRI) {
        String tableName = this.getTimeseriesTableName(dataIRI);
        return DSL.table(DSL.name(tableName));
    }

    protected double getAggregate(String dataIRI, AggregateFunction aggregateFunction) {
        this.connect();
        try {
            Table<?> table = this.getTimeseriesTable(dataIRI);
            String columnName = this.getColumnName(dataIRI);
            Field<Double> columnField = DSL.field(DSL.name(columnName), Double.class);
            switch (aggregateFunction) {
                case AVERAGE: {
                    return this.context.select(DSL.avg(columnField)).from((TableLike<?>)table).fetch(DSL.avg(columnField)).get(0).doubleValue();
                }
                case MAX: {
                    return this.context.select(DSL.max(columnField)).from((TableLike<?>)table).fetch(DSL.max(columnField)).get(0);
                }
                case MIN: {
                    return this.context.select(DSL.min(columnField)).from((TableLike<?>)table).fetch(DSL.min(columnField)).get(0);
                }
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Aggregate function " + aggregateFunction.name() + " not valid!");
        }
        catch (JPSRuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (Exception e) {
            this.disconnect();
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    protected static enum AggregateFunction {
        AVERAGE,
        MAX,
        MIN;

    }
}

