/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.handlers.Handler;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.syntax.ElementData;

public class ValuesHandler
implements Handler {
    private Map<Var, List<Node>> valuesTable;
    private Map<Var, Node> valueMap;
    private final Query query;

    public ValuesHandler() {
        this(null);
    }

    public ValuesHandler(Query query) {
        this.query = query;
        this.valuesTable = new LinkedHashMap<Var, List<Node>>();
        this.valueMap = Collections.emptyMap();
    }

    public ElementData asElement() {
        ElementData ed = new ElementData();
        ArrayList<Var> vars = new ArrayList<Var>(this.valuesTable.keySet());
        vars.removeAll(this.valueMap.keySet());
        if (vars.isEmpty()) {
            return ed;
        }
        vars.forEach(var -> ed.add(var));
        int count = this.valuesTable.get(vars.get(0)).size();
        for (int i = 0; i < count; ++i) {
            BindingHashMap b = new BindingHashMap();
            for (Var var2 : vars) {
                List<Node> lst = this.valuesTable.get(var2);
                if (lst.size() != count) {
                    throw new QueryBuildException(String.format("The number of data items for %s (%s) is not the same as for %s (%s)", var2, lst.size(), vars.get(0), count));
                }
                Node n = lst.get(i);
                if (n == null) continue;
                if (this.valueMap.containsKey(n)) {
                    n = this.valueMap.get(n);
                }
                b.add(var2, n);
            }
            if (b.isEmpty()) continue;
            ed.add((Binding)b);
        }
        return ed;
    }

    public boolean isEmpty() {
        return this.valuesTable.isEmpty();
    }

    @Override
    public void setVars(Map<Var, Node> values) {
        this.valueMap = values;
    }

    @Override
    public void build() {
        ElementData ed;
        if (this.query != null && !(ed = this.asElement()).getRows().isEmpty()) {
            this.query.setValuesDataBlock(ed.getVars(), ed.getRows());
        }
    }

    private List<Node> getNodesList(Var var) {
        List<Node> values = this.valuesTable.get(var);
        if (values == null) {
            values = new ArrayList<Node>();
            this.valuesTable.put(var, values);
        }
        return values;
    }

    public void addValueVar(Var var, Collection<Node> nodes) {
        List<Node> values = this.getNodesList(var);
        if (nodes != null) {
            values.addAll(nodes);
        }
    }

    public void addValueRow(Collection<Node> values) {
        if (values.size() != this.valuesTable.size()) {
            throw new IllegalArgumentException(String.format("Number of values (%s) must match number of columns %s", values.size(), this.valuesTable.size()));
        }
        Iterator<Node> iter = values.iterator();
        for (Var v : this.valuesTable.keySet()) {
            List<Node> lst = this.getNodesList(v);
            lst.add(iter.next());
        }
    }

    public void addAll(ValuesHandler handler) {
        if (handler.valuesTable.size() == 0) {
            return;
        }
        int count = 0;
        if (this.valuesTable.size() > 0) {
            count = this.valuesTable.values().iterator().next().size();
        }
        for (Var var : handler.valuesTable.keySet()) {
            List<Node> lst = this.valuesTable.get(var);
            if (lst == null) {
                lst = new ArrayList<Node>();
                lst.addAll(Arrays.asList(new Node[count]));
                this.valuesTable.put(var, lst);
            }
            lst.addAll((Collection<Node>)handler.valuesTable.get(var));
        }
        ArrayList<Var> lst = new ArrayList<Var>(this.valuesTable.keySet());
        lst.removeAll(handler.valuesTable.keySet());
        if (!lst.isEmpty()) {
            count = handler.valuesTable.values().iterator().next().size();
            for (Var var : lst) {
                List<Node> lst2 = this.valuesTable.get(var);
                lst2.addAll(Arrays.asList(new Node[count]));
            }
        }
    }

    public void clear() {
        this.valuesTable.clear();
    }

    public List<Var> getValuesVars() {
        return Collections.unmodifiableList(new ArrayList<Var>(this.valuesTable.keySet()));
    }

    public Map<Var, List<Node>> getValuesMap() {
        LinkedHashMap<Var, List<Node>> m = new LinkedHashMap<Var, List<Node>>();
        for (Var key : this.valuesTable.keySet()) {
            m.put(key, Collections.unmodifiableList(this.valuesTable.get(key)));
        }
        return Collections.unmodifiableMap(m);
    }
}

