/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonLdUrl {
    public String href = "";
    public String protocol = "";
    public String host = "";
    public String auth = "";
    public String user = "";
    public String password = "";
    public String hostname = "";
    public String port = "";
    public String relative = "";
    public String path = "";
    public String directory = "";
    public String file = "";
    public String query = "";
    public String hash = "";
    public String pathname = null;
    public String normalizedPath = null;
    public String authority = null;
    private static Pattern parser = Pattern.compile("^(?:([^:\\/?#]+):)?(?:\\/\\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\\/?#]*)(?::(\\d*))?))?((((?:[^?#\\/]*\\/)*)([^?#]*))(?:\\?([^#]*))?(?:#(.*))?)");

    public static JsonLdUrl parse(String url) {
        JsonLdUrl rval = new JsonLdUrl();
        rval.href = url;
        Matcher matcher = parser.matcher(url);
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                rval.protocol = matcher.group(1);
            }
            if (matcher.group(2) != null) {
                rval.host = matcher.group(2);
            }
            if (matcher.group(3) != null) {
                rval.auth = matcher.group(3);
            }
            if (matcher.group(4) != null) {
                rval.user = matcher.group(4);
            }
            if (matcher.group(5) != null) {
                rval.password = matcher.group(5);
            }
            if (matcher.group(6) != null) {
                rval.hostname = matcher.group(6);
            }
            if (matcher.group(7) != null) {
                rval.port = matcher.group(7);
            }
            if (matcher.group(8) != null) {
                rval.relative = matcher.group(8);
            }
            if (matcher.group(9) != null) {
                rval.path = matcher.group(9);
            }
            if (matcher.group(10) != null) {
                rval.directory = matcher.group(10);
            }
            if (matcher.group(11) != null) {
                rval.file = matcher.group(11);
            }
            if (matcher.group(12) != null) {
                rval.query = matcher.group(12);
            }
            if (matcher.group(13) != null) {
                rval.hash = matcher.group(13);
            }
            if (!"".equals(rval.host) && "".equals(rval.path)) {
                rval.path = "/";
            }
            rval.pathname = rval.path;
            JsonLdUrl.parseAuthority(rval);
            rval.normalizedPath = JsonLdUrl.removeDotSegments(rval.pathname, !"".equals(rval.authority));
            if (!"".equals(rval.query)) {
                rval.path = rval.path + "?" + rval.query;
            }
            if (!"".equals(rval.protocol)) {
                rval.protocol = rval.protocol + ":";
            }
            if (!"".equals(rval.hash)) {
                rval.hash = "#" + rval.hash;
            }
            return rval;
        }
        return rval;
    }

    public static String removeDotSegments(String path, boolean hasAuthority) {
        int i;
        String rval = "";
        if (path.indexOf("/") == 0) {
            rval = "/";
        }
        ArrayList<String> input = new ArrayList<String>(Arrays.asList(path.split("/")));
        if (path.endsWith("/")) {
            input.add("");
        }
        ArrayList<String> output = new ArrayList<String>();
        for (i = 0; i < input.size(); ++i) {
            if (".".equals(input.get(i)) || "".equals(input.get(i)) && input.size() - i > 1) continue;
            if ("..".equals(input.get(i))) {
                if (hasAuthority || output.size() > 0 && !"..".equals(output.get(output.size() - 1))) {
                    if (output.size() <= 0) continue;
                    output.remove(output.size() - 1);
                    continue;
                }
                output.add("..");
                continue;
            }
            output.add((String)input.get(i));
        }
        if (output.size() > 0) {
            rval = rval + (String)output.get(0);
            for (i = 1; i < output.size(); ++i) {
                rval = rval + "/" + (String)output.get(i);
            }
        }
        return rval;
    }

    public static String removeBase(Object baseobj, String iri) {
        int i;
        if (baseobj == null) {
            return iri;
        }
        JsonLdUrl base = baseobj instanceof String ? JsonLdUrl.parse((String)baseobj) : (JsonLdUrl)baseobj;
        String root = "";
        if (!"".equals(base.href)) {
            root = root + base.protocol + "//" + base.authority;
        } else if (iri.indexOf("//") != 0) {
            root = root + "//";
        }
        if (iri.indexOf(root) != 0) {
            return iri;
        }
        JsonLdUrl rel = JsonLdUrl.parse(iri.substring(root.length()));
        ArrayList<String> baseSegments = new ArrayList<String>(Arrays.asList(base.normalizedPath.split("/")));
        if (base.normalizedPath.endsWith("/")) {
            baseSegments.add("");
        }
        ArrayList<String> iriSegments = new ArrayList<String>(Arrays.asList(rel.normalizedPath.split("/")));
        if (rel.normalizedPath.endsWith("/")) {
            iriSegments.add("");
        }
        while (baseSegments.size() > 0 && iriSegments.size() > 0 && ((String)baseSegments.get(0)).equals(iriSegments.get(0))) {
            if (baseSegments.size() > 0) {
                baseSegments.remove(0);
            }
            if (iriSegments.size() <= 0) continue;
            iriSegments.remove(0);
        }
        String rval = "";
        if (baseSegments.size() > 0) {
            if (!base.normalizedPath.endsWith("/") || "".equals(baseSegments.get(0))) {
                baseSegments.remove(baseSegments.size() - 1);
            }
            for (i = 0; i < baseSegments.size(); ++i) {
                rval = rval + "../";
            }
        }
        if (iriSegments.size() > 0) {
            rval = rval + (String)iriSegments.get(0);
        }
        for (i = 1; i < iriSegments.size(); ++i) {
            rval = rval + "/" + (String)iriSegments.get(i);
        }
        if (!"".equals(rel.query)) {
            rval = rval + "?" + rel.query;
        }
        if (!"".equals(rel.hash)) {
            rval = rval + rel.hash;
        }
        if ("".equals(rval)) {
            rval = "./";
        }
        return rval;
    }

    public static String resolve(String baseUri, String pathToResolve) {
        if (baseUri == null) {
            return pathToResolve;
        }
        if (pathToResolve == null || "".equals(pathToResolve.trim())) {
            return baseUri;
        }
        try {
            URI uri = new URI(baseUri);
            if (uri.isOpaque()) {
                String basePath = uri.getPath() != null ? uri.getPath() : uri.getSchemeSpecificPart();
                basePath = basePath.contains("/") ? basePath.substring(0, basePath.lastIndexOf(47) + 1) : "";
                return new URI(uri.getScheme(), basePath + pathToResolve, null).toString();
            }
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), null);
            if (pathToResolve.startsWith("?")) {
                uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null);
                return uri.toString() + pathToResolve;
            }
            if (pathToResolve.startsWith("#")) {
                return uri.toString() + pathToResolve;
            }
            String path = (uri = uri.resolve(pathToResolve)).getPath();
            if (path != null) {
                path = JsonLdUrl.removeDotSegments(path, true);
            }
            return new URI(uri.getScheme(), uri.getAuthority(), path, uri.getQuery(), uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static void parseAuthority(JsonLdUrl parsed) {
        if (parsed.href.indexOf(":") == -1 && parsed.href.indexOf("//") == 0 && "".equals(parsed.host)) {
            parsed.pathname = parsed.pathname.substring(2);
            int idx = parsed.pathname.indexOf("/");
            if (idx == -1) {
                parsed.authority = parsed.pathname;
                parsed.pathname = "";
            } else {
                parsed.authority = parsed.pathname.substring(0, idx);
                parsed.pathname = parsed.pathname.substring(idx);
            }
        } else {
            parsed.authority = parsed.host;
            if (!"".equals(parsed.auth)) {
                parsed.authority = parsed.auth + "@" + parsed.authority;
            }
        }
    }
}

