#
# This code has been auto-generated by the MDE Workbench
# Version: 2.4.0.
#
# File: enums.py
# Date: 2021-07-14 11:34
# Time: 11:34
#


from enum import IntEnum, unique

import jsons


# Atmospheric stability classes.
@unique
class AtmosphericStabilityClass(IntEnum):

	# A
	STABILITY_A = 1

	# A/B
	STABILITY_AB = 2

	# B
	STABILITY_B = 3

	# B/C
	STABILITY_BC = 4

	# C
	STABILITY_C = 5

	# C/D
	STABILITY_CD = 6

	# D
	STABILITY_D = 7

	# E
	STABILITY_E = 8

	# F
	STABILITY_F = 9

	# G
	STABILITY_G = 10

# Type of contour plot or grid
@unique
class ContourType(IntEnum):

	# Footprint (XY plane)
	FOOTPRINT = 1

	# Sideview (XZ plane)
	SIDEVIEW = 2

	# Crosswind (YZ plane)
	CROSSWIND = 3

# Flag to indicate wheather we are in day or nightime
@unique
class DayNight(IntEnum):

	# Day
	DAY = 1

	# Night
	NIGHT = 2

# Choice of input to vary to achieve target design
@unique
class DesignVariable(IntEnum):

	# The length of the flare stack
	PIPE_LENGTH = 1

	# The diameter of the flare stack
	PIPE_DIAMETER = 2

	# The driving pressure in the tank feeding the flare stack
	OPERATING_PRESSURE = 3

# Type of release or cloud
@unique
class DynamicType(IntEnum):

	# Instantaneous
	INSTANTANEOUS = 1

	# Continuous
	CONTINUOUS = 2

	# Time-varying
	TIME_VARYING = 3

# Fire type (Fireball = 1, Pool fire = 2, NOT IN USE = 3, Jet fire = 4)
@unique
class FireType(IntEnum):

	# Fireball
	FIRE__BALL = 1

	# Pool fire
	POOL = 2

	# Cone jet fire
	CONE_JET = 4

# Allow phase change upstream of orifice
@unique
class FlashAtOrifice(IntEnum):

	# No phase change to the orifice
	NO_FLASH_AT_ORIFICE = 0

	# Flashing allowed to the orifice
	FLASH_ALLOWED = 1

	# No flashing of liquid (metastable liquid)
	DISALLOW_LIQUID_FLASH = 2

# Fluid state specification
@unique
class FluidSpec(IntEnum):

	# Specify all of P,T,LF
	PT_LF = 0

	# Specify temperature and pressure
	TP = 1

	# Bubble point at fixed temperature
	T_BUB = 2

	# Bubble point at fixed pressure
	P_BUB = 3

	# Dew point at fixed temperature
	T_DEW = 4

	# Dew point at fixed pressure
	P_DEW = 5

	# Fixed pressure and liquid fraction
	P_LF = 6

	# Fixed temperature and liquid fraction
	T_LF = 7

# MEConfinedMethod
@unique
class MEConfinedMethod(IntEnum):

	# Uniform confined method
	UNIFORM_CONFINED = 3

	# User defined method
	USER_DEFINED = 1

# Method for modelling a mixture (Pseudo component = 0, Multi-component with single aerosol = 1, NOT IN USE = 2, Multi-component with multiple aerosol = 3)
@unique
class MixtureModelling(IntEnum):

	# Pseudo-component treatment of mixtures
	PC = 0

	# Multi-component single aerosol 
	MC___SINGLE_AEROSOL = 1

	# Multi-component multiple aerosol hybrid method
	MC___MULTIPLE_AEROSOL = 3

# Fluid phase (vapour, liquid or two-phase)
@unique
class Phase(IntEnum):

	# Vapour
	VAPOUR = 1

	# Two-phase
	TWO_PHASE = 2

	# Liquid
	LIQUID = 3

# Pool fire type
@unique
class PoolFireType(IntEnum):

	# Immediate pool fire
	IMMEDIATE = 0

	# Early pool fire
	EARLY = 1

	# Late pool fire
	LATE = 2

# Surface type for pools and bunds
@unique
class PoolSurfaceType(IntEnum):

	# Wet soil
	WET_SOIL = 1

	# Dry soil
	DRY_SOIL = 2

	# Concrete
	CONCRETE = 3

	# Insulated concrete
	INSULATED_CONCRETE = 4

	# Deep open water
	DEEP_OPEN_WATER = 5

	# Shallow open water
	SHALLOW_OPEN_WATER = 6

	# Deep river
	DEEP_RIVER = 7

	# Shallow river
	SHALLOW_RIVER = 8

# Choice of property template
@unique
class PropertyTemplate(IntEnum):

	# The PhastMC is the default Phast template
	PHAST_MC = 100

	# Old default Phast property template
	PHAST_64 = 101

	# Acid association template for modelling reactive Hydrogen Fluoride
	ACID_ASSOCIATION = 102

	# Template using the Soave-Redlich-Kwong cubic equation of state
	SOAVE_REDLICK_KWONG = 103

	# Template using the Peng-Robinson cubic equation of state
	PENG_ROBINSON = 104

	# The Soave-Redlich-Kwong template but with ideal fugacities for improved robustness
	SRK_IDEAL_FUGACITY = 107

	# The Peng-Robinson template but with ideal fugacities for improved robustness
	PR_IDEAL_FUGACITY = 106

# Radiation type
@unique
class RadiationType(IntEnum):

	# Radiation dose
	DOSE = 1

	# Radiation probit
	PROBIT = 2

	# Radiation lethality
	LETHALITY = 3

	# View factor
	VIEW_FACTOR = 4

	# Radiation intensity
	INTENSITY = 5

# Rainout and thermodynamic modelling
@unique
class RainoutThermoFlag(IntEnum):

	# No rainout, equilibrium
	NO_RAINOUT_EQUILIBRIUM = -1

	# Rainout, equilibrium
	RAINOUT_EQUILIBRIUM = 1

	# Rainout, non-equilibrium
	RAINOUT_NON_EQUILIBRIUM = 2

# Release direction
@unique
class ReleaseDirection(IntEnum):

	# Vertical
	VERTICAL = 1

	# Horizontal
	HORIZONTAL = 0

# Output resolution (and performance)
@unique
class Resolution(IntEnum):

	# High
	HIGH = 1

	# Medium
	MEDIUM = 2

	# Low
	LOW = 3

	# Very high
	VERY_HIGH = 4

	# Extremely high
	EXTREME = 5

# Response code
@unique
class ResultCode(IntEnum):

	# Success
	SUCCESS = 0

	# Validation fail
	FAIL___VALIDATION = -1

	# Execution fail
	FAIL___EXECUTION = 1

	HTTP_NOT_MODIFIED_ERROR = 30304

	HTTP_USE_PROXY_ERROR = 30305

	HTTP_UNUSED_ERROR = 30306

	HTTP_BAD_REQUEST_ERROR = 30400

	HTTP_UNAUTHORIZED_ERROR = 30401

	HTTP_PAYMENT_REQUIRED_ERROR = 30402

	HTTP_FORBIDDEN_ERROR = 30403

	HTTP_NOT_FOUND_ERROR = 30404

	HTTP_METHOD_NOT_ALLOWED_ERROR = 30405

	HTTP_NOT_ACCEPTABLE_ERROR = 30406

	HTTP_PROXY_AUTHENTICATION_REQUIRED_ERROR = 30407

	HTTP_REQUEST_TIMEOUT_ERROR = 30408

	HTTP_CONFLICT_ERROR = 30409

	HTTP_GONE_ERROR = 30410

	HTTP_LENGTH_REQUIRED_ERROR = 30411

	HTTP_PRECONDITION_FAILED_ERROR = 30412

	HTTP_REQUEST_ENTITY_TOO_LARGE_ERROR = 30413

	HTTP_REQUEST_URI_TOO_LONG_ERROR = 30414

	HTTP_UNSUPPORTED_MEDIA_TYPE_ERROR = 30415

	HTTP_REQUESTED_RANGE_NOT_SATISFIABLE_ERROR = 30416

	HTTP_EXPECTATION_FAILED_ERROR = 30417

	HTTP_UPGRADE_REQUIRED_ERROR = 30426

	HTTP_INTERNAL_SERVER_ERROR_ERROR = 30500

	HTTP_NOT_IMPLEMENTED_ERROR = 30501

	HTTP_BAD_GATEWAY_ERROR = 30502

	HTTP_SERVICE_UNAVAILABLE_ERROR = 30503

	HTTP_GATEWAY_TIMEOUT_ERROR = 30504

	HTTP_HTTP_VERSION_NOT_SUPPORTED_ERROR = 30505

	UNEXPECTED_APPLICATION_ERROR = 21001

	MISSING_PARAMETERS_ERROR = 21002

	INVALID_WORKING_DIRECTORY_ERROR = 21003

	INVALID_APP_ROOT_DIRECTORY_ERROR = 21004

	INVALID_MDE_MODELS_DIRECTORY_ERROR = 21005

	MDE_MODEL_DIRECTORY_NOT_FOUND_ERROR = 21006

	INVALID_PROPERTY_SYSTEM_DIRECTORY_ERROR = 21007

	INPUT_FILE_NOT_SPECIFIED_ERROR = 21008

	INPUT_FILE_NOT_FOUND_ERROR = 21009

	OUTPUT_FILE_NOT_SPECIFIED_ERROR = 21010

	ERROR_READING_INPUT_FILE_ERROR = 21011

	FAILED_TO_INITIALISE_MDE_ERROR_REPORTING_ERROR = 21012

	FAILED_TO_INITIALISE_PROPERTY_SYSTEM_ERROR = 21013

	INVALID_ACCESS_TOKEN_ERROR = 21014

	NO_DISCHARGE_RECORDS_ERROR = 21100

	NO_DISPERSION_RECORDS_ERROR = 21102

	NO_FLAME_RECORDS_ERROR = 21103

	MDE_INITIALIZATION_ERROR = 21104

	MDE_ERROR_REPORTING_INITIALIZATION_ERROR = 21105

	PHYSICAL_PROPERTY_SYSTEM_INITIALIZATION_ERROR = 21106

	DISCHARGE_CALCULATION_INITIALIZATION_ERROR = 21107

	DISPERSION_CALCULATION_INITIALIZATION_ERROR = 21108

	UNABLE_TO_READ_DATA_ERROR = 21109

	CLIENT_ID_NOT_SPECIFIED_ERROR = 21110

	JSON_READER_ERROR = 21111

	INDEX_OUT_OF_RANGE_ERROR = 21112

	DATA_STORAGE_ERROR = 21113

	NO_DISCHARGE_RECORDS_GENERATED_WARNING = 63001

	NO_DISPERSION_RECORDS_GENERATED_WARNING = 63002

	HTTP_AMBIGUOUS_ERROR = 30300

	HTTP_MOVED_ERROR = 30301

	HTTP_REDIRECT_ERROR = 30302

	HTTP_REDIRECT_METHOD_ERROR = 30303

	HTTP_REDIRECT_KEEP_VERB_ERROR = 30307

# Determines whether an entity is globally or workspace scoped.
@unique
class Scope(IntEnum):

	# Entity has global scope.
	GLOBAL = 1

	# Entity has workspace scope.
	WORKSPACE = 2

# Concentrations of interest
@unique
class SpecialConcentration(IntEnum):

	# LFL Fraction
	LFL_FRACTION = 1

	# LFL
	LFL = 2

	# UFL
	UFL = 3

	# Not defined
	NOT_DEFINED = 0

	# Minimum concentration
	MIN = 4

# Dispersing surface type (land or water)
@unique
class SurfaceType(IntEnum):

	# Dispersion over land
	LAND = 1

	# Dispersion over water
	WATER = 2

# Type of result for design constraint
@unique
class TargetVariable(IntEnum):

	# Specify a target mass flow rate
	MASS_FLOW_RATE = 1

	# Specify a target expanded release velocity
	EXPANDED_RELEASE_VELOCITY = 2

	# Specify a target pipe exit pressure
	PIPE_EXIT_PRESSURE = 3

	# Specify a target radiation level at the endpoint of the radiation transect
	RADIATION_LEVEL_TRANSECT_ENDPOINT = 4

# Dynamic modelling of leaks and lines
@unique
class TimeVaryingOption(IntEnum):

	# Use initial rate
	INITIAL_RATE = 1

	# Use time-varying rates
	TIME_VARYING_RATE = 2

# Type of toxic result
@unique
class ToxicResultType(IntEnum):

	# Probability of death
	TOXIC_LETHALITY = 1

	# Toxic probit number
	TOXIC_PROBIT = 2

	# Toxic dose
	TOXIC_DOSE = 3

# The vessel conditions expected by the user (Pure Gas = 1, NOT IN USE = 2, Stratified Two-Phase = 3 or Pressurised liquid = 4)
@unique
class VesselConditions(IntEnum):

	# Pressurised gas vessel
	PURE_GAS = 1

	# Two phase vessel
	STRATIFIED_TWO_PHASE_VESSEL = 3

	# Pressurised liquid vessel
	PRESSURIZED_LIQUID_VESSEL = 4


# Vessel shape
@unique
class VesselShape(IntEnum):

	# Vertical cylinder
	VERTICAL_CYLINDER = 1

	# Horizontal cylinder
	HORIZONTAL_CYLINDER = 2

	# Sphere
	VESSEL_SPHERE = 3

	# Cuboid
	VESSEL_CUBOID = 4


