# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['remove_print_statements']
install_requires = \
['click>=8.0.4,<9.0.0', 'libcst>=0.4.1,<0.5.0']

entry_points = \
{'console_scripts': ['remove-print-statements = remove_print_statements:main']}

setup_kwargs = {
    'name': 'remove-print-statements',
    'version': '0.1.3',
    'description': 'A tool (and pre-commit hook) to remove print statements from your Python project.',
    'long_description': '<div align="center">\n\n# remove-print-statements\n\n[![GitHub Workflow Status](https://img.shields.io/github/workflow/status/dhruvmanila/remove-print-statements/ci?label=CI&logo=github&style=flat-square)](https://github.com/dhruvmanila/remove-print-statements/actions)\n[![Codecov](https://img.shields.io/codecov/c/gh/dhruvmanila/remove-print-statements?label=codecov&logo=codecov&style=flat-square)](https://app.codecov.io/gh/dhruvmanila/remove-print-statements)\n[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/dhruvmanila/remove-print-statements/main.svg)](https://results.pre-commit.ci/latest/github/dhruvmanila/remove-print-statements/main)\n[![PyPi Status](https://img.shields.io/pypi/v/remove-print-statements.svg?logo=python&logoColor=fff&style=flat-square)](https://pypi.org/project/remove-print-statements/)\n![Python versions](https://img.shields.io/pypi/pyversions/remove-print-statements.svg?style=flat-square&logo=python&amp;logoColor=fff)\n[![MIT License](https://img.shields.io/pypi/l/remove-print-statements.svg?style=flat-square)](./LICENSE)\n\nA CLI tool (and pre-commit hook) to remove all the `print` statements from your\nPython project.\n\n</div>\n\nDo you use `print` statements for debugging? We all do, and there\'s nothing wrong\nwith it. After the bug has been resolved, we need to manually open all the files\nwhich we added the print statements in, only if we remember all of them after\nhours of debugging, and remove them. A better way would be to use some sort of\nfind and replace from the editor or command-line, but that\'s still a lot of\nmanual work. Worst case, it gets pushed and deployed to production.\n\nWho wants to do all the manual work in the age of automation? No one. So,\ninstall this tool and forget about removing the print statements manually\nforever. You could either run this tool manually or add it as a `pre-commit`\nhook. You could even preview the print statements along with it\'s location\nwithout removing it. How nice is that!\n\n## Installation\n\nYou can install `remove-print-statements` from the Python Package Index (PyPI)\nwith `pip` or equivalent.\n\n```\npython -m pip install remove-print-statements\n```\n\nOr with [pre-commit](https://pre-commit.com) in the `repos` section of your\n`.pre-commit-config.yaml` file ([docs](https://pre-commit.com/#plugins)):\n\n```yaml\n- repo: https://github.com/dhruvmanila/remove-print-statements\n  rev: \'\'  # Replace with latest tag on GitHub\n  hooks:\n  - id: remove-print-statements\n    args: [\'--verbose\']   # Show all the print statements to be removed\n```\n\n## Usage\n\nRun it on a given set of files:\n```sh\nremove-print-statements foo.py bar.py ...\n# or use globbing\nremove-print-statements *.py\n```\n\nYou can ignore files as well. To specify multiple files to ignore, use the flag\nmultiple times otherwise it\'s difficult to know the difference between the files\nto ignore and the ones to check.\n```sh\nremove-print-statements *.py --ignore foo.py --ignore bar.py\n```\n\nYou can preview the print statements which would be removed without modifying\nthe source files using both `--dry-run` and `--verbose` flags like so:\n\n```console\n$ remove-print-statements --dry-run --verbose test.py\ntest.py:7:0: print("module")\ntest.py:18:8: print("property")\ntest.py:27:4: print("method")\ntest.py:29:8: print("for loop")\n\n1 file would be transformed, 4 print statements would be removed\n```\n\n`remove-print-statements` is a command-line tool that rewrites the files in\nplace. It focuses on upgrading your code and not on making it look nice. Run\nremove-print-statements before formatters like [Black](https://black.readthedocs.io/en/stable/).\n\n`remove-print-statements` does not have any ability to recurse through\ndirectories. Use the pre-commit integration, globbing, or another technique for\napplying to many files such as [with `git ls-files | xargs`][1].\n\n### Exit status\n\n`remove-print-statements` command returns exit statuses as follows:\n\n| Status       | Description                                      |\n| :----------: | ------------------------------------------------ |\n| 0            | No print statements / changes made successfully |\n| 1            | Files would be updated (dry run)                 |\n| 123          | Some error happened                              |\n\n## Development\n\n[![packaing: poetry](https://img.shields.io/badge/packaging-poetry-299bd7?style=flat-square&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAASCAYAAABrXO8xAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAJJSURBVHgBfZLPa1NBEMe/s7tNXoxW1KJQKaUHkXhQvHgW6UHQQ09CBS/6V3hKc/AP8CqCrUcpmop3Cx48eDB4yEECjVQrlZb80CRN8t6OM/teagVxYZi38+Yz853dJbzoMV3MM8cJUcLMSUKIE8AzQ2PieZzFxEJOHMOgMQQ+dUgSAckNXhapU/NMhDSWLs1B24A8sO1xrN4NECkcAC9ASkiIJc6k5TRiUDPhnyMMdhKc+Zx19l6SgyeW76BEONY9exVQMzKExGKwwPsCzza7KGSSWRWEQhyEaDXp6ZHEr416ygbiKYOd7TEWvvcQIeusHYMJGhTwF9y7sGnSwaWyFAiyoxzqW0PM/RjghPxF2pWReAowTEXnDh0xgcLs8l2YQmOrj3N7ByiqEoH0cARs4u78WgAVkoEDIDoOi3AkcLOHU60RIg5wC4ZuTC7FaHKQm8Hq1fQuSOBvX/sodmNJSB5geaF5CPIkUeecdMxieoRO5jz9bheL6/tXjrwCyX/UYBUcjCaWHljx1xiX6z9xEjkYAzbGVnB8pvLmyXm9ep+W8CmsSHQQY77Zx1zboxAV0w7ybMhQmfqdmmw3nEp1I0Z+FGO6M8LZdoyZnuzzBdjISicKRnpxzI9fPb+0oYXsNdyi+d3h9bm9MWYHFtPeIZfLwzmFDKy1ai3p+PDls1Llz4yyFpferxjnyjJDSEy9CaCx5m2cJPerq6Xm34eTrZt3PqxYO1XOwDYZrFlH1fWnpU38Y9HRze3lj0vOujZcXKuuXm3jP+s3KbZVra7y2EAAAAAASUVORK5CYII=)](https://python-poetry.org/)\n[![code style: black](https://img.shields.io/static/v1?label=code%20style&message=black&color=black&style=flat-square)](https://github.com/psf/black)\n[![pre-commit: enabled](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white&style=flat-square)](https://github.com/pre-commit/pre-commit)\n\n### Release\n\n1. Run `poetry lock`\n2. Bump version in `pyproject.toml` and `__version__` variable\n3. Commit and push the changes with message `release: <version>`\n4. Publish a new release on GitHub which will trigger an automated workflow to\n   publish on PyPi\n\n## License\n\nremove-print-statements is licensed under the MIT License.\n\nSee [LICENSE](./LICENSE) for details.\n\n<!-- References -->\n\n[1]: https://adamj.eu/tech/2022/03/09/how-to-run-a-command-on-many-files-in-your-git-repository/\n',
    'author': 'Dhruv Manilawala',
    'author_email': 'dhruvmanila@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dhruvmanila/remove-print-statements',
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
