"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codepipeline = require("@aws-cdk/aws-codepipeline");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const cpactions = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-codepipeline-cloudformation');
const pipeline = new codepipeline.Pipeline(stack, 'Pipeline');
const bucket = new s3.Bucket(stack, 'PipelineBucket', {
    versioned: true,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
const sourceOutput = new codepipeline.Artifact('SourceArtifact');
const additionalArtifact = new codepipeline.Artifact('AdditionalArtifact');
const source = new cpactions.S3SourceAction({
    actionName: 'Source',
    output: sourceOutput,
    bucket,
    bucketKey: 'key',
});
const sourceStage = {
    stageName: 'Source',
    actions: [
        source,
        new cpactions.S3SourceAction({
            actionName: 'AdditionalSource',
            output: additionalArtifact,
            bucket,
            bucketKey: 'additional/key',
        }),
    ],
};
const changeSetName = "ChangeSetIntegTest";
const stackName = "IntegTest-TestActionStack";
const role = new aws_iam_1.Role(stack, 'CfnChangeSetRole', {
    assumedBy: new aws_iam_1.ServicePrincipal('cloudformation.amazonaws.com'),
});
pipeline.addStage(sourceStage);
pipeline.addStage({
    stageName: 'CFN',
    actions: [
        new cpactions.CloudFormationCreateReplaceChangeSetAction({
            actionName: 'DeployCFN',
            changeSetName,
            stackName,
            deploymentRole: role,
            templatePath: sourceOutput.atPath('test.yaml'),
            adminPermissions: false,
            parameterOverrides: {
                BucketName: sourceOutput.bucketName,
                ObjectKey: sourceOutput.objectKey,
                Url: additionalArtifact.url,
                OtherParam: sourceOutput.getParam('params.json', 'OtherParam'),
            },
            extraInputs: [additionalArtifact],
        }),
    ],
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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