"use strict";
const codepipeline = require("@aws-cdk/aws-codepipeline");
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const cdk = require("@aws-cdk/core");
const cpactions = require("../../lib");
function anyEcsService() {
    const stack = new cdk.Stack();
    const taskDefinition = new ecs.FargateTaskDefinition(stack, 'TaskDefinition');
    taskDefinition.addContainer('MainContainer', {
        image: ecs.ContainerImage.fromRegistry('amazon/amazon-ecs-sample'),
    });
    const vpc = new ec2.Vpc(stack, 'VPC');
    const cluster = new ecs.Cluster(stack, 'Cluster', {
        vpc,
    });
    return new ecs.FargateService(stack, 'FargateService', {
        cluster,
        taskDefinition,
    });
}
module.exports = {
    'ECS deploy Action': {
        'throws an exception if neither inputArtifact nor imageFile were provided'(test) {
            const service = anyEcsService();
            test.throws(() => {
                new cpactions.EcsDeployAction({
                    actionName: 'ECS',
                    service,
                });
            }, /one of 'input' or 'imageFile' is required/);
            test.done();
        },
        'can be created just by specifying the inputArtifact'(test) {
            const service = anyEcsService();
            const artifact = new codepipeline.Artifact('Artifact');
            test.doesNotThrow(() => {
                new cpactions.EcsDeployAction({
                    actionName: 'ECS',
                    service,
                    input: artifact,
                });
            });
            test.done();
        },
        'can be created just by specifying the imageFile'(test) {
            const service = anyEcsService();
            const artifact = new codepipeline.Artifact('Artifact');
            test.doesNotThrow(() => {
                new cpactions.EcsDeployAction({
                    actionName: 'ECS',
                    service,
                    imageFile: artifact.atPath('imageFile.json'),
                });
            });
            test.done();
        },
        'throws an exception if both inputArtifact and imageFile were provided'(test) {
            const service = anyEcsService();
            const artifact = new codepipeline.Artifact('Artifact');
            test.throws(() => {
                new cpactions.EcsDeployAction({
                    actionName: 'ECS',
                    service,
                    input: artifact,
                    imageFile: artifact.atPath('file.json'),
                });
            }, /one of 'input' or 'imageFile' can be provided/);
            test.done();
        },
        "sets the target service as the action's backing resource"(test) {
            const service = anyEcsService();
            const artifact = new codepipeline.Artifact('Artifact');
            const action = new cpactions.EcsDeployAction({
                actionName: 'ECS',
                service,
                input: artifact
            });
            test.equal(action.actionProperties.resource, service);
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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