"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagOptions = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const util_1 = require("./private/util");
const validation_1 = require("./private/validation");
const aws_servicecatalog_1 = require("aws-cdk-lib/aws-servicecatalog");
/**
 * (experimental) Defines a set of TagOptions, which are a list of key-value pairs managed in AWS Service Catalog.
 *
 * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
 * See https://docs.aws.amazon.com/servicecatalog/latest/adminguide/tagoptions.html
 *
 * @experimental
 * @resource AWS::ServiceCatalog::TagOption
 */
class TagOptions extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_servicecatalog_alpha_TagOptionsProps(props);
        this._cfnTagOptions = this.createUnderlyingTagOptions(props.allowedValuesForTags);
    }
    createUnderlyingTagOptions(allowedValuesForTags) {
        if (Object.keys(allowedValuesForTags).length === 0) {
            throw new Error(`No tag option keys or values were provided for resource ${this.node.path}`);
        }
        var tagOptions = [];
        for (const [tagKey, tagValues] of Object.entries(allowedValuesForTags)) {
            validation_1.InputValidator.validateLength(this.node.addr, 'TagOption key', 1, 128, tagKey);
            const uniqueTagValues = new Set(tagValues);
            if (uniqueTagValues.size === 0) {
                throw new Error(`No tag option values were provided for tag option key ${tagKey} for resource ${this.node.path}`);
            }
            uniqueTagValues.forEach((tagValue) => {
                validation_1.InputValidator.validateLength(this.node.addr, 'TagOption value', 1, 256, tagValue);
                const tagOptionIdentifier = util_1.hashValues(tagKey, tagValue);
                const tagOption = new aws_servicecatalog_1.CfnTagOption(this, tagOptionIdentifier, {
                    key: tagKey,
                    value: tagValue,
                    active: true,
                });
                tagOptions.push(tagOption);
            });
        }
        return tagOptions;
    }
}
exports.TagOptions = TagOptions;
_a = JSII_RTTI_SYMBOL_1;
TagOptions[_a] = { fqn: "@aws-cdk/aws-servicecatalog-alpha.TagOptions", version: "2.11.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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