**大纲：**

- 简介
- 仿Linux树形目录显示tree命令
- 文件差异比较diff命令
- 图片加水印marker命令
- curl请求命令转python请求代码

## 简介

filestools目前包含四个工具包，分别是树形目录显示、文件差异比较、图片加水印和curl请求转python代码。

通过以下命令进行安装：

```
pip install filestools -U
```

也可以使用阿里云加速（可能因为同步延迟，暂时无法下载到最新版）：

```
pip install filestools --index-url=http://mirrors.aliyun.com/pypi/simple -U
```

保证能够下载到最新版的命令：

```
pip install filestools --index-url https://pypi.org/simple/ -U
```

作者：小小明（代码实体）

博客主页：[https://blog.csdn.net/as604049322](https://blog.csdn.net/as604049322)



下面分别看看这几大功能的用法：

## 仿Linux树形目录显示tree命令

查看帮助文档：

```
D:\tool>tree -h
usage: tree [-h] [-p PATH] [-m MAX_LEVEL] [-n]

仿Linux树形目录显示，含文件/文件夹大小统计

optional arguments:
  -h, --help            show this help message and exit
  -p PATH, --path PATH  进行递归显示的目录路径，默认为当前目录
  -m MAX_LEVEL, --max-level MAX_LEVEL
                        递归展示的最大层数,默认为7层
  -n, --no-calc         指定该参数后，对于超过递归显示的最大层数的文件夹不再继续递归计算文件夹大小
```

安装treedir后即可直接使用tree命令显示当前目录的树形结构：

```
tree
```

指定其他需要递归显示的目录：

```
tree -p E:/tmp/wap
```

当目录层级过多，可以限制最大显示的层数：

```
tree -p E:/tmp -m 2
```

若递归计算文件夹大小耗时过久，可以加`-n`参数取消对超过递归层级的文件计算大小：

```
tree -p E:/ -m 2 -n
```



如果你的系统由于系统环境的优先级高于本地python导致执行结果是系统的tree命令，除了可以调整环境变量顺序修改优先级外，还可以使用tree2命令，与tree一致。

对于windows：

![image-20210731182848666](https://img-blog.csdnimg.cn/img_convert/eee21f02ec90e31c16198e94ea324e4a.png)

对于Linux：

![image-20210731183704104](https://img-blog.csdnimg.cn/img_convert/b3ac488b37c35928f343343261e64411.png)

查看指定目录并指定最大递归层级为2（默认最大层级是7）：

![image-20210731183841842](https://img-blog.csdnimg.cn/img_convert/1bae9a6736d21b9c5191c39d7b55d64e.png)

可以直接在python代码中操作：

```python
from treedir.tree import tree_dir
tree_dir(".", m_level=7, no_calc=False)
```



## 文件差异比较diff命令

`-h`参数可以查看帮助文档：

```
E:\>diff -h
usage: diff [-h] [-o OUT] [-m MAX_WIDTH] [-n NUMLINES] [-a] [--no-browser]
            file1 file2

比较两个文本文件的差异输出到HTML网页中

positional arguments:
  file1                 被比较的文件1
  file2                 被比较的文件2

optional arguments:
  -h, --help            show this help message and exit
  -o OUT, --out OUT     差异结果保存的文件名，默认值diff_result.html
  -m MAX_WIDTH, --max_width MAX_WIDTH
                        每行超过多少字符就自动换行，默认值70
  -n NUMLINES, --numlines NUMLINES
                        在差异行基础上前后显示多少行，默认是0
  -a, --show_all        只要设置这个参数就表示显示全部原始数据，此时-n参数无效；默认不显示全部
  --no-browser          设置这个参数，在生成结果后不会自动打开游览器
```

用法示例：

```
diff t1.log t2.log
```

生成结果：

![image-20210728201320511](https://img-blog.csdnimg.cn/img_convert/d5c1b3a235e39d3fc590b46a7551c725.png)

指定前后多显示一行：

```
diff t1.log t2.log -n 1
```

生成结果：

![image-20210728201632928](https://img-blog.csdnimg.cn/img_convert/e6ba5b0019cedecaeaca2552023e0ec3.png)

若要取消自动打开游览器：

```
diff t1.log t2.log --no-browser 
```

也可以直接在python代码中操作（关键字参数均为默认参数）：

```python
from filediff.diff import file_diff_compare
file_diff_compare("a.txt", "b.txt", diff_out="diff_result.html", max_width=70, numlines=0, show_all=False, no_browser=True)
```



## 图片加水印marker命令

查看帮助：

```
C:\Users\ASUS\Pictures>marker -h
usage: marker [-h] [-o OUT] [-c COLOR] [-s SPACE] [-a ANGLE] [--size SIZE]
              [--opacity OPACITY]
              file mark

用于一张图片或一个图片文件夹批量添加水印

positional arguments:
  file                  图片文件或图片文件夹路径
  mark                  要添加的水印内容

optional arguments:
  -h, --help            show this help message and exit
  -o OUT, --out OUT     添加水印后的结果保存位置，默认生成到output文件夹
  -c COLOR, --color COLOR
                        水印颜色，默认#8B8B1B
  -s SPACE, --space SPACE
                        水印直接的间隔, 默认75个空格
  -a ANGLE, --angle ANGLE
                        水印旋转角度，默认30度
  --size SIZE           水印字体的大小，默认50
  --opacity OPACITY     水印的透明度，默认0.15

```

示例：

![image-20210728225007612](https://img-blog.csdnimg.cn/img_convert/29fba109463af306b9f0423257b50093.png)

默认加水印的结果都添加到output文件夹中。

也可以直接在python代码中操作：

```python
from watermarker.marker import add_mark
add_mark(r"C:\Users\ASUS\Pictures\act", "小小明")
```



## curl请求命令转python请求代码

帮助文档：

```
E:\>curl2py -h
usage: curl2py [-h] [-f FILE] [-o OUT] [-t] [-c]

将curl网络请求命令转换成python的requests库请求代码，-f/-t/-o三个参数均没有指定时，结果将保存到剪切板中

optional arguments:
  -h, --help            show this help message and exit
  -f FILE, --file FILE  被转换的curl命令文件，-o和-t参数均没有指定将保存到对应的同名py脚本中，不指定则从直接对剪切板操作
  -o OUT, --out OUT     生成py脚本的保存位置
  -t, --tmp             py脚本是否保存到当前目录的tmp.py中
  -c, --copy            始终copy结果到剪切板
```

我们在复制游览器（使用谷歌游览器内核的游览器）请求信息为cURL(bash)后，就可以通过curl2py命令将其转换为python代码。

先在谷歌游览器中复制网络抓到的网络请求为cURL(bash)：

![](https://img-blog.csdnimg.cn/img_convert/37703fc31a632dc22a9c4d0aa8065326.png)]

再执行命令将剪切板中curl请求命令转换为python代码：

![image-20210729215225407](https://img-blog.csdnimg.cn/img_convert/e74bbd4e74507fc2f386b7fd602d3d4c.png)

还可以指定生成结果保存到文件：

![image-20210729215643949](https://img-blog.csdnimg.cn/img_convert/2817ddbfbaed487fc8f366a6559fbd5c.png)

也可以直接在python代码中使用：

```python
from curl2py.curlParseTool import curlCmdGenPyScript

curl_cmd = """curl 'https://pypi.org/' \
  -H 'authority: pypi.org' \
  -H 'cache-control: max-age=0' \
  -H 'upgrade-insecure-requests: 1' \
  -H 'user-agent: Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36' \
  -H 'accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9' \
  -H 'sec-fetch-site: same-origin' \
  -H 'sec-fetch-mode: navigate' \
  -H 'sec-fetch-user: ?1' \
  -H 'sec-fetch-dest: document' \
  -H 'referer: https://pypi.org/' \
  -H 'accept-language: zh-CN,zh;q=0.9' \
  -H 'if-none-match: "aHcyOtSkyMSZwaPVSUwL1g"' \
  --compressed"""
output = curlCmdGenPyScript(curl_cmd)
print(output)
```