"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-iot-kinesisstreams';
// Definitions
const props = {
    iotTopicRuleProps: {
        topicRulePayload: {
            description: "sends data to kinesis streams",
            sql: "SELECT * FROM 'solutions/constructs'",
            actions: []
        },
    },
    kinesisStreamProps: {
        shardCount: 5,
        retentionPeriod: aws_cdk_lib_1.Duration.hours(30)
    }
};
new lib_1.IotToKinesisStreams(stack, 'test-iot-kinesisstreams', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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