# PyBRAMS

**PyBRAMS** is a Python package that allows you to access information and data from the BRAMS (Belgian RAdio Meteor Stations) project. 

BRAMS is a network of radar receiving stations that use forward scattering techniques to study the meteoroid population. 

This project, coordinated by the Belgian Institute for Space Aeronomy (BIRA-IASB), provides a valuable source of data for space operators, research scientists and amateur astronomers.

# Contents
- [Features](#features)
- [Installation](#installation)
- [Usage](#usage)
   - [Command-line tool](#command-line-tool)
      - [Available commands](#available-commands)
         - [get](#get)
         - [cache](#cache)
         - [config](#config)
         - [spectrogram](#spectrogram)
         - [wavinfo](#wavinfo)
         - [trajectory](#trajectory)
- [Notebooks](#notebooks)
- [Contributing](#contributing)
- [License](#license)

## Features

- Fetch detailed information about BRAMS stations, including their location, name, number of antennas, and more.
- Retrieve raw data files in WAV format, which can be used for in-depth analysis of meteoroid activity.
- Access PNG images representing spectrograms, making it easy to visualize meteoroid detections.
- Compute trajectories, speeds and their associated uncertainties.
- Allow validation of results with optical data.

## Installation

You can install **PyBRAMS** using pip:

```bash
$ pip install pybrams
```
## Usage
 
This library can be used in two ways:
- As a command-line tool  for quick execution.
- As a Python module for integration into custom scripts.

### Command-line tool

The library provides an executable script called `pybrams`, which can be run from the terminal :

```bash
$ pybrams [options] [command]
```

#### Available options

##### --verbose

Some commands may take a significant amount of time to execute. The --verbose option provides detailed output and displays real-time progress. 

#### Available commands

##### get

The `get` command fetches BRAMS files in WAV format and saves them in the current working directory.

```bash
$ pybrams get INTERVAL [SYSTEMS...]
```

The  INTERVAL argument  must be in one of the following format :
-  a single datetime  in ISO 8601 format :
```bash
$ pybrams get 2025-01-01T03:05
```
- a datetime interval using ISO 8601 format, separated by / :
 ```bash
$ pybrams get 2025-02-12T03:03/2025-02-12T03:17
```
You can also provide one or multiple system codes to only fetch files from specific BRAMS system(s) :
```bash
$ pybrams get 2025-03-15T12:00 BESAFF_SYS001 BEHUMA_SYS001
```

##### cache
PyBRAMS uses a caching system to store metadata, WAV files and result files in a local directory. 
This improve performance by avoiding redundant calls to the BRAMS API and computations.

The `cache` commands allow the user to manage this cache by :

- checking the current status of the cache 
```bash
$ pybrams cache status
Cache is enabled
```
- enabling or disabling the cache
```bash
$ pybrams cache disable
Cache is disabled
$ pybrams cache enable
Cache is enabled
```

- clearing the cache
```bash
$ pybrams cache clear
Cache was cleared
```

- get information about the cache 
```bash
$ pybrams cache info
Number of files : 385
Total size : 1811688538 B
Total size : 1769227.09 KB
Total size : 1727.76 MB
```

##### config
PyBRAMS uses a global configuration file to manage settings.
The config command allows users to view the current configuration or copy it to the current working directory for customization.

To display the global configuration used by PyBRAMS, run :
```bash
$ pybrams config show
{
    "pybrams": {
      ...
   }
}
```

If you want to modify the settings, you can copy the global configuration file to the current working directory by running :
```bash
$ pybrams config copy
```
This creates a pybrams.json file in the current working directory, which you can edit to override the default settings.
When present, this file takes precedence over the global configuration.

##### spectrogram
The `spectrogram` command generates spectrograms from WAV files found in the current working directory or in the path specified by the user.
```brams
$ ls -1 *.wav
RAD_BEDOUR_20240729_2305_BESAFF_SYS001.wav
RAD_BEDOUR_20240729_2310_BESAFF_SYS001.wav
RAD_BEDOUR_20240729_2315_BESAFF_SYS001.wav
RAD_BEDOUR_20240729_2320_BESAFF_SYS001.wav
RAD_BEDOUR_20240729_2325_BESAFF_SYS001.wav
$ pybrams spectrogram
RAD_BEDOUR_20240729_2310_BESAFF_SYS001.png
RAD_BEDOUR_20240729_2305_BESAFF_SYS001.png
RAD_BEDOUR_20240729_2315_BESAFF_SYS001.png
RAD_BEDOUR_20240729_2320_BESAFF_SYS001.png
RAD_BEDOUR_20240729_2325_BESAFF_SYS001.png
```

##### wavinfo
The `wavinfo` command displays information about the WAV file provided by the user.

By default, the command displays information found in the header of the file :
```bash
$ pybrams wavinfo RAD_BEDOUR_20240729_2310_BESAFF_SYS001.wav
Header
Version : 4
Samplerate : 6048.0 Hz
LO frequency : 49969000.0 Hz
Start (us) : 1722294600326662
PPS count : 1800
Beacon latitude : 50.097526
Beacon longitude : 4.588525
Beacon altitude : 273.3 m
Beacon frequency : 49970000.0 Hz
Beacon power : 84.9
Beacon polarization : 3
Antenna ID : 1
Antenna latitude : 50.784132
Antenna longitude : 5.233545
Antenna altitude : 1
Antenna azimuth : 1
Antenna elevation : 1
Beacon code : BEDOUR
Observer code : 
Station code : BESAFF
Description : Calclock
```

##### trajectory

The `trajectory` command retrieves meteoroid trajectories using times of flight and phase information. It can be called with the brams subcommand and a corresponding datetime interval:

```bash
$ pybrams trajectory brams 2020-07-29T23:36:27/2020-07-29T23:36:32
```

You can also provide a CAMS-BeNeLux date and trajectory number, if the corresponding event is available in data/pybrams/optical/cams:

```bash
$ pybrams trajectory cams 2020-07-29 79
```

Both these subcommands can be complemented with options:

- `--recompute_meteors` to reprocess meteor data even if it is already cached.
- `--recompute_trajectory` to redetermine the best trajectory even if it is already cached.
- `--uncertainty` to perform a MCMC uncertainty quantification on the solution, based on [Kastinen and Kero (2022)](https://academic.oup.com/mnras/article/517/3/3974/6726639).

An example call to the `trajectory` command is then finally:

```bash
$ pybrams --verbose trajectory cams 2020-07-30 188 --uncertainty
```
&nbsp;
***

For more information about a specific command and available arguments, run :

```bash
$ pybrams COMMAND --help
```

## Notebooks

This repository includes two Jupyter notebooks that showcase the usage of **PyBRAMS**:

1. **Get Brams Data Notebook** ([get_brams_data.ipynb](./notebooks/get_brams_data.ipynb)):
   - Retrieves BRAMS data corresponding to a user-defined time interval or to a CAMS-BeNeLux event.
   - Outputs spectrograms, time series and amplitude curves.


2. **Reconstruct Trajectory Notebook** ([reconstruct_trajectory.ipynb](./notebooks/reconstruct_trajectory.ipynb)):
   - Focuses on reconstructing meteor trajectories from observational radar data, similar to the `trajectory` command.
   - Compares the results with optical data from CAMS-BeNeLux.


These notebooks serve as practical examples and are a good starting point for new implementations.

**Note**: Both notebooks require ipykernel and ipympl. The latter can be installed using pip:

```bash
$ pip install ipykernel ipympl
```

## Contributing

Contributions and feedback are welcome !

## License

This package is licensed under the MIT License. Feel free to use and modify it as needed.
