import { IWidget } from './widget';
/**
 * A widget that contains other widgets in a horizontal row.
 *
 * Widgets will be laid out next to each other
 *
 * @stability stable
 */
export declare class Row implements IWidget {
    /**
     * The amount of horizontal grid units the widget will take up.
     *
     * @stability stable
     */
    readonly width: number;
    /**
     * The amount of vertical grid units the widget will take up.
     *
     * @stability stable
     */
    readonly height: number;
    /**
     * List of contained widgets
     */
    private readonly widgets;
    /**
     * Relative position of each widget inside this row
     */
    private readonly offsets;
    /**
     * @stability stable
     */
    constructor(...widgets: IWidget[]);
    /**
     * Place the widget at a given position.
     *
     * @stability stable
     */
    position(x: number, y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     *
     * @stability stable
     */
    toJson(): any[];
}
/**
 * A widget that contains other widgets in a vertical column.
 *
 * Widgets will be laid out next to each other
 *
 * @stability stable
 */
export declare class Column implements IWidget {
    /**
     * The amount of horizontal grid units the widget will take up.
     *
     * @stability stable
     */
    readonly width: number;
    /**
     * The amount of vertical grid units the widget will take up.
     *
     * @stability stable
     */
    readonly height: number;
    /**
     * List of contained widgets
     */
    private readonly widgets;
    /**
     * @stability stable
     */
    constructor(...widgets: IWidget[]);
    /**
     * Place the widget at a given position.
     *
     * @stability stable
     */
    position(x: number, y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     *
     * @stability stable
     */
    toJson(): any[];
}
/**
 * Props of the spacer.
 *
 * @stability stable
 */
export interface SpacerProps {
    /**
     * Width of the spacer.
     *
     * @default 1
     * @stability stable
     */
    readonly width?: number;
    /**
     * Height of the spacer.
     *
     * @default : 1
     * @stability stable
     */
    readonly height?: number;
}
/**
 * A widget that doesn't display anything but takes up space.
 *
 * @stability stable
 */
export declare class Spacer implements IWidget {
    /**
     * The amount of horizontal grid units the widget will take up.
     *
     * @stability stable
     */
    readonly width: number;
    /**
     * The amount of vertical grid units the widget will take up.
     *
     * @stability stable
     */
    readonly height: number;
    /**
     * @stability stable
     */
    constructor(props?: SpacerProps);
    /**
     * Place the widget at a given position.
     *
     * @stability stable
     */
    position(_x: number, _y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     *
     * @stability stable
     */
    toJson(): any[];
}
