# coding: utf-8

"""
    Datový konektor Domino pro eSMLOUVY

    Toto je datový konektor umožňující datovou výměnu mezi obchodní logikou aplikace eSMLOUVY a datovým serverem HCL Domino.  Ovládá se pomocí REST API   # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: info@sysnet.cz
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class PublicApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_budget_category(self, identifier, **kwargs):  # noqa: E501
        """odstraní položku rozpočtového zařazení s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu rozpočtové zařazení Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_budget_category(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_budget_category_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_budget_category_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def delete_budget_category_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """odstraní položku rozpočtového zařazení s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu rozpočtové zařazení Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_budget_category_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'softdelete', 'undelete', 'delete_responses']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_budget_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_budget_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'softdelete' in params:
            query_params.append(('softdelete', params['softdelete']))  # noqa: E501
        if 'undelete' in params:
            query_params.append(('undelete', params['undelete']))  # noqa: E501
        if 'delete_responses' in params:
            query_params.append(('delete_responses', params['delete_responses']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/budget_category/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_container(self, identifier, **kwargs):  # noqa: E501
        """odstraní dokumentový kontejner s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu evidenční list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_container(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument odstraněn
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_container_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_container_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def delete_container_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """odstraní dokumentový kontejner s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu evidenční list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_container_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument odstraněn
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'softdelete', 'undelete', 'delete_responses', 'author']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'softdelete' in params:
            query_params.append(('softdelete', params['softdelete']))  # noqa: E501
        if 'undelete' in params:
            query_params.append(('undelete', params['undelete']))  # noqa: E501
        if 'delete_responses' in params:
            query_params.append(('delete_responses', params['delete_responses']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/container/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cover(self, identifier, **kwargs):  # noqa: E501
        """odstraní krycí list s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu krycí list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cover(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument odstraněn
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cover_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cover_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def delete_cover_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """odstraní krycí list s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu krycí list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cover_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument odstraněn
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'softdelete', 'undelete', 'delete_responses', 'author']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cover" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_cover`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'softdelete' in params:
            query_params.append(('softdelete', params['softdelete']))  # noqa: E501
        if 'undelete' in params:
            query_params.append(('undelete', params['undelete']))  # noqa: E501
        if 'delete_responses' in params:
            query_params.append(('delete_responses', params['delete_responses']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/cover/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_payment_event(self, identifier, **kwargs):  # noqa: E501
        """odstraní položku platebního kalenáře s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu položka platebního kalendáře Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payment_event(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_payment_event_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_payment_event_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def delete_payment_event_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """odstraní položku platebního kalenáře s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu položka platebního kalendáře Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payment_event_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'softdelete', 'undelete', 'delete_responses']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_payment_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_payment_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'softdelete' in params:
            query_params.append(('softdelete', params['softdelete']))  # noqa: E501
        if 'undelete' in params:
            query_params.append(('undelete', params['undelete']))  # noqa: E501
        if 'delete_responses' in params:
            query_params.append(('delete_responses', params['delete_responses']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/payment_event/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_registration(self, identifier, **kwargs):  # noqa: E501
        """odstraní evidenční list s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu evidenční list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_registration(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument odstraněn
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_registration_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_registration_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def delete_registration_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """odstraní evidenční list s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu evidenční list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_registration_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument odstraněn
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'softdelete', 'undelete', 'delete_responses', 'author']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_registration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_registration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'softdelete' in params:
            query_params.append(('softdelete', params['softdelete']))  # noqa: E501
        if 'undelete' in params:
            query_params.append(('undelete', params['undelete']))  # noqa: E501
        if 'delete_responses' in params:
            query_params.append(('delete_responses', params['delete_responses']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/registration/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_standpoint(self, identifier, **kwargs):  # noqa: E501
        """odstraní stanovisko s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu stanovisko Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_standpoint(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument odstraněn
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_standpoint_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_standpoint_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def delete_standpoint_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """odstraní stanovisko s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu stanovisko Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_standpoint_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :param bool delete_responses: Odstraní všechny odpovědi
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument odstraněn
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'softdelete', 'undelete', 'delete_responses', 'author']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_standpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_standpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'softdelete' in params:
            query_params.append(('softdelete', params['softdelete']))  # noqa: E501
        if 'undelete' in params:
            query_params.append(('undelete', params['undelete']))  # noqa: E501
        if 'delete_responses' in params:
            query_params.append(('delete_responses', params['delete_responses']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/standpoint/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_budget_category(self, identifier, **kwargs):  # noqa: E501
        """vrací položku rozpočtového zařazení s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu rozpočtové zařazení Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_budget_category(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param bool version: Vrací verzi identifikovanou parametrem id
        :return: BudgetCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_budget_category_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_budget_category_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_budget_category_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """vrací položku rozpočtového zařazení s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu rozpočtové zařazení Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_budget_category_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param bool version: Vrací verzi identifikovanou parametrem id
        :return: BudgetCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_budget_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_budget_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/budget_category/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BudgetCategory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_budget_category_list(self, **kwargs):  # noqa: E501
        """vrací seznam rozpočtových zařazení  # noqa: E501

        Vrátí dokumenty typu rozpočtové zařazení odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_budget_category_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_budget_category_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_budget_category_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_budget_category_list_with_http_info(self, **kwargs):  # noqa: E501
        """vrací seznam rozpočtových zařazení  # noqa: E501

        Vrátí dokumenty typu rozpočtové zařazení odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_budget_category_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'search', 'start', 'page_size', 'page', 'versions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_budget_category_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'versions' in params:
            query_params.append(('versions', params['versions']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/budget_category', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_budget_category_list_by_dept(self, dept, **kwargs):  # noqa: E501
        """vrací všechna rozpočtová opatření pro útvar  # noqa: E501

        Vrátí dokumenty typu rozpočtové zařazení pro útvar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_budget_category_list_by_dept(dept, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dept: Číslo (identifikátor útvaru (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_budget_category_list_by_dept_with_http_info(dept, **kwargs)  # noqa: E501
        else:
            (data) = self.get_budget_category_list_by_dept_with_http_info(dept, **kwargs)  # noqa: E501
            return data

    def get_budget_category_list_by_dept_with_http_info(self, dept, **kwargs):  # noqa: E501
        """vrací všechna rozpočtová opatření pro útvar  # noqa: E501

        Vrátí dokumenty typu rozpočtové zařazení pro útvar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_budget_category_list_by_dept_with_http_info(dept, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dept: Číslo (identifikátor útvaru (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dept', 'start', 'page_size', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_budget_category_list_by_dept" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dept' is set
        if ('dept' not in params or
                params['dept'] is None):
            raise ValueError("Missing the required parameter `dept` when calling `get_budget_category_list_by_dept`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dept' in params:
            path_params['dept'] = params['dept']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/budget_category/dept/{dept}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_container(self, identifier, **kwargs):  # noqa: E501
        """vrací dokumentový kontejner s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu kontejner Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool version: Vrací verzi identifikovanou parametrem identifier
        :param bool items: Vrací seznam položek obsažených v kontejneru
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_container_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_container_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_container_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """vrací dokumentový kontejner s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu kontejner Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool version: Vrací verzi identifikovanou parametrem identifier
        :param bool items: Vrací seznam položek obsažených v kontejneru
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'author', 'reader', 'version', 'items']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501
        if 'items' in params:
            query_params.append(('items', params['items']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/container/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Container',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_container_content(self, identifier, **kwargs):  # noqa: E501
        """vrací obsah kontejneru s daným identifikátorem  # noqa: E501

        Na základě identifikátoru vrátí obsah kontejneru Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_content(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory dokumentu, budou vráceny položky
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, budou vráceny položky
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_container_content_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_container_content_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_container_content_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """vrací obsah kontejneru s daným identifikátorem  # noqa: E501

        Na základě identifikátoru vrátí obsah kontejneru Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_content_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory dokumentu, budou vráceny položky
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, budou vráceny položky
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start', 'page_size', 'page', 'author', 'reader']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_container_content" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_container_content`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/container/items/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_container_list(self, **kwargs):  # noqa: E501
        """vrací seznam dokumentových kontejnerů  # noqa: E501

        Vrátí dokumenty typu kontejner odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param str searchbycolumn: Třídit podle sloupce
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_container_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_container_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_container_list_with_http_info(self, **kwargs):  # noqa: E501
        """vrací seznam dokumentových kontejnerů  # noqa: E501

        Vrátí dokumenty typu kontejner odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param str searchbycolumn: Třídit podle sloupce
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'search', 'searchbycolumn', 'start', 'page_size', 'page', 'author', 'reader', 'versions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_container_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'searchbycolumn' in params:
            query_params.append(('searchbycolumn', params['searchbycolumn']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501
        if 'versions' in params:
            query_params.append(('versions', params['versions']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/container', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cover(self, identifier, **kwargs):  # noqa: E501
        """vrací krycí list s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu krycí list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cover(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool version: Vrací verzi identifikovanou parametrem id
        :return: CoverSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cover_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cover_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_cover_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """vrací krycí list s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu krycí list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cover_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool version: Vrací verzi identifikovanou parametrem id
        :return: CoverSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'author', 'reader', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cover" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_cover`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/cover/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CoverSheet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cover_list(self, **kwargs):  # noqa: E501
        """vrací seznam kycích listů  # noqa: E501

        Vrátí dokumenty typu krycí list odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cover_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cover_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cover_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cover_list_with_http_info(self, **kwargs):  # noqa: E501
        """vrací seznam kycích listů  # noqa: E501

        Vrátí dokumenty typu krycí list odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cover_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'search', 'start', 'page_size', 'page', 'author', 'reader', 'versions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cover_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501
        if 'versions' in params:
            query_params.append(('versions', params['versions']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/cover', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cover_list_container(self, container, **kwargs):  # noqa: E501
        """vrací seznam kycích listů v kontejneru  # noqa: E501

        Vrátí dokumenty typu krycí list v konkrétním kontejneru  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cover_list_container(container, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container: Identifikátor kontejneru (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, budou dokumenty vráceny
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, budou dokumenty vráceny
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cover_list_container_with_http_info(container, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cover_list_container_with_http_info(container, **kwargs)  # noqa: E501
            return data

    def get_cover_list_container_with_http_info(self, container, **kwargs):  # noqa: E501
        """vrací seznam kycích listů v kontejneru  # noqa: E501

        Vrátí dokumenty typu krycí list v konkrétním kontejneru  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cover_list_container_with_http_info(container, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container: Identifikátor kontejneru (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, budou dokumenty vráceny
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, budou dokumenty vráceny
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container', 'start', 'page_size', 'page', 'author', 'reader']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cover_list_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container' is set
        if ('container' not in params or
                params['container'] is None):
            raise ValueError("Missing the required parameter `container` when calling `get_cover_list_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container' in params:
            path_params['container'] = params['container']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/cover/container/{container}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_event(self, identifier, **kwargs):  # noqa: E501
        """vrací položku platebního kalenáře s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu položka platebního kalendáře Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_event(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param bool version: Vrací verzi identifikovanou parametrem id
        :return: PaymentEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_event_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_event_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_payment_event_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """vrací položku platebního kalenáře s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu položka platebního kalendáře Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_event_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param bool version: Vrací verzi identifikovanou parametrem id
        :return: PaymentEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_payment_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/payment_event/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaymentEvent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_event_list(self, **kwargs):  # noqa: E501
        """vrací seznam položek platebního kalendáře  # noqa: E501

        Vrátí dokumenty typu položka platebního kalendáře odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_event_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent: Identifikátor rodičovského dokumentu. Může být PID, UNID nebo uuid
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_event_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_event_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_payment_event_list_with_http_info(self, **kwargs):  # noqa: E501
        """vrací seznam položek platebního kalendáře  # noqa: E501

        Vrátí dokumenty typu položka platebního kalendáře odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_event_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent: Identifikátor rodičovského dokumentu. Může být PID, UNID nebo uuid
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['parent', 'key', 'search', 'start', 'page_size', 'page', 'versions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_event_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'parent' in params:
            query_params.append(('parent', params['parent']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'versions' in params:
            query_params.append(('versions', params['versions']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/payment_event', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_event_list_parent(self, parent, **kwargs):  # noqa: E501
        """vrací seznam položek platebního kalendáře pro nadřazený dokument  # noqa: E501

        Vrátí dokumenty typu položka platebního kalendáře pro rodičovský dokument   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_event_list_parent(parent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent: Identifikátor rodičovského dokumentu. Může být PID, UNID nebo uuid (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_event_list_parent_with_http_info(parent, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_event_list_parent_with_http_info(parent, **kwargs)  # noqa: E501
            return data

    def get_payment_event_list_parent_with_http_info(self, parent, **kwargs):  # noqa: E501
        """vrací seznam položek platebního kalendáře pro nadřazený dokument  # noqa: E501

        Vrátí dokumenty typu položka platebního kalendáře pro rodičovský dokument   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_event_list_parent_with_http_info(parent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent: Identifikátor rodičovského dokumentu. Může být PID, UNID nebo uuid (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['parent', 'start', 'page_size', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_event_list_parent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'parent' is set
        if ('parent' not in params or
                params['parent'] is None):
            raise ValueError("Missing the required parameter `parent` when calling `get_payment_event_list_parent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'parent' in params:
            path_params['parent'] = params['parent']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/payment_event/parent/{parent}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_registration(self, identifier, **kwargs):  # noqa: E501
        """vrací evidenční list s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu evidenční list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_registration(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool version: Vrací verzi identifikovanou parametrem id
        :return: RegistrationSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_registration_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_registration_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_registration_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """vrací evidenční list s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu evidenční list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_registration_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool version: Vrací verzi identifikovanou parametrem id
        :return: RegistrationSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'author', 'reader', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_registration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_registration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/registration/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RegistrationSheet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_registration_list(self, **kwargs):  # noqa: E501
        """vrací seznam registračních listů  # noqa: E501

        Vrátí dokumenty typu evidenční list odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_registration_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_registration_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_registration_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_registration_list_with_http_info(self, **kwargs):  # noqa: E501
        """vrací seznam registračních listů  # noqa: E501

        Vrátí dokumenty typu evidenční list odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_registration_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'search', 'start', 'page_size', 'page', 'author', 'reader', 'versions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_registration_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501
        if 'versions' in params:
            query_params.append(('versions', params['versions']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/registration', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_registration_list_container(self, container, **kwargs):  # noqa: E501
        """vrací seznam registračních listů v kontejneru  # noqa: E501

        Vrátí dokumenty typu evidenční list v daném kontejneru  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_registration_list_container(container, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container: Identifikátor kontejneru (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, budou dokumenty vráceny
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, budou dokumenty vráceny
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_registration_list_container_with_http_info(container, **kwargs)  # noqa: E501
        else:
            (data) = self.get_registration_list_container_with_http_info(container, **kwargs)  # noqa: E501
            return data

    def get_registration_list_container_with_http_info(self, container, **kwargs):  # noqa: E501
        """vrací seznam registračních listů v kontejneru  # noqa: E501

        Vrátí dokumenty typu evidenční list v daném kontejneru  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_registration_list_container_with_http_info(container, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container: Identifikátor kontejneru (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, budou dokumenty vráceny
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, budou dokumenty vráceny
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container', 'start', 'page_size', 'page', 'author', 'reader']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_registration_list_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container' is set
        if ('container' not in params or
                params['container'] is None):
            raise ValueError("Missing the required parameter `container` when calling `get_registration_list_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container' in params:
            path_params['container'] = params['container']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/registration/container/{container}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_standpoint(self, identifier, **kwargs):  # noqa: E501
        """vrací stanovisko s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu stanovisko Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_standpoint(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool version: Vrací verzi identifikovanou parametrem id
        :return: Standpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_standpoint_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_standpoint_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_standpoint_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """vrací stanovisko s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu stanovisko Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_standpoint_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool version: Vrací verzi identifikovanou parametrem id
        :return: Standpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'author', 'reader', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_standpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_standpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/standpoint/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Standpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_standpoint_list(self, **kwargs):  # noqa: E501
        """vrací seznam stanovisek  # noqa: E501

        Vrátí dokumenty typu stanovisko odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_standpoint_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent: Identifikátor rodičovského dokumentu. Může být PID, UNID nebo uuid
        :param str stand: Typ stanoviska (číselný kód)
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_standpoint_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_standpoint_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_standpoint_list_with_http_info(self, **kwargs):  # noqa: E501
        """vrací seznam stanovisek  # noqa: E501

        Vrátí dokumenty typu stanovisko odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_standpoint_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent: Identifikátor rodičovského dokumentu. Může být PID, UNID nebo uuid
        :param str stand: Typ stanoviska (číselný kód)
        :param str key: Vyhledávací klíčové slovo. Může být PID, UNID, uuid nebo libovolný text
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :param bool versions: Vrací všechny verze
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['parent', 'stand', 'key', 'search', 'start', 'page_size', 'page', 'author', 'reader', 'versions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_standpoint_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'parent' in params:
            query_params.append(('parent', params['parent']))  # noqa: E501
        if 'stand' in params:
            query_params.append(('stand', params['stand']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501
        if 'versions' in params:
            query_params.append(('versions', params['versions']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/standpoint', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_standpoint_list_container(self, container, **kwargs):  # noqa: E501
        """vrací seznam stanovisek v kontejneru  # noqa: E501

        Vrátí dokumenty typu stanovisko zařazené do kontejneru  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_standpoint_list_container(container, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container: Identifikátor uuid kontejneru. Může být PID, UNID nebo uuid (required)
        :param str stand: Typ stanoviska (číselný kód)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_standpoint_list_container_with_http_info(container, **kwargs)  # noqa: E501
        else:
            (data) = self.get_standpoint_list_container_with_http_info(container, **kwargs)  # noqa: E501
            return data

    def get_standpoint_list_container_with_http_info(self, container, **kwargs):  # noqa: E501
        """vrací seznam stanovisek v kontejneru  # noqa: E501

        Vrátí dokumenty typu stanovisko zařazené do kontejneru  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_standpoint_list_container_with_http_info(container, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container: Identifikátor uuid kontejneru. Může být PID, UNID nebo uuid (required)
        :param str stand: Typ stanoviska (číselný kód)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container', 'stand', 'start', 'page_size', 'page', 'author', 'reader']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_standpoint_list_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container' is set
        if ('container' not in params or
                params['container'] is None):
            raise ValueError("Missing the required parameter `container` when calling `get_standpoint_list_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container' in params:
            path_params['container'] = params['container']  # noqa: E501

        query_params = []
        if 'stand' in params:
            query_params.append(('stand', params['stand']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/standpoint/container/{container}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_standpoint_list_parent(self, parent, **kwargs):  # noqa: E501
        """vrací seznam stanovisek pro nadřízený dokument  # noqa: E501

        Vrátí dokumenty typu stanovisko odpovídající nadřízenému dokumentu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_standpoint_list_parent(parent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent: Identifikátor rodičovského dokumentu. Může být PID, UNID nebo uuid (required)
        :param str stand: Typ stanoviska (číselný kód)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_standpoint_list_parent_with_http_info(parent, **kwargs)  # noqa: E501
        else:
            (data) = self.get_standpoint_list_parent_with_http_info(parent, **kwargs)  # noqa: E501
            return data

    def get_standpoint_list_parent_with_http_info(self, parent, **kwargs):  # noqa: E501
        """vrací seznam stanovisek pro nadřízený dokument  # noqa: E501

        Vrátí dokumenty typu stanovisko odpovídající nadřízenému dokumentu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_standpoint_list_parent_with_http_info(parent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent: Identifikátor rodičovského dokumentu. Může být PID, UNID nebo uuid (required)
        :param str stand: Typ stanoviska (číselný kód)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument vrácen
        :param str reader: Autorizace podle čtenáře. Pokud je jméno mezi čtenáři, bude dokument vrácen
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['parent', 'stand', 'start', 'page_size', 'page', 'author', 'reader']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_standpoint_list_parent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'parent' is set
        if ('parent' not in params or
                params['parent'] is None):
            raise ValueError("Missing the required parameter `parent` when calling `get_standpoint_list_parent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'parent' in params:
            path_params['parent'] = params['parent']  # noqa: E501

        query_params = []
        if 'stand' in params:
            query_params.append(('stand', params['stand']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'reader' in params:
            query_params.append(('reader', params['reader']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/standpoint/parent/{parent}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_budget_category(self, **kwargs):  # noqa: E501
        """vytvoří novou položku rozpočtového zařazení (Crud)  # noqa: E501

        Vytvoří nový dokument typu rozpočtové zařazení  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_budget_category(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BudgetCategory body:
        :return: BudgetCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_budget_category_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_budget_category_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_budget_category_with_http_info(self, **kwargs):  # noqa: E501
        """vytvoří novou položku rozpočtového zařazení (Crud)  # noqa: E501

        Vytvoří nový dokument typu rozpočtové zařazení  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_budget_category_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BudgetCategory body:
        :return: BudgetCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_budget_category" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/budget_category', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BudgetCategory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_container(self, **kwargs):  # noqa: E501
        """vytvoří nový dokumentový kontejner (Crud)  # noqa: E501

        Vytvoří nový dokument typu kontejner  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_container(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Container body:
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_container_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_container_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_container_with_http_info(self, **kwargs):  # noqa: E501
        """vytvoří nový dokumentový kontejner (Crud)  # noqa: E501

        Vytvoří nový dokument typu kontejner  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_container_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Container body:
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_container" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/container', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Container',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_cover(self, container_id, **kwargs):  # noqa: E501
        """vytvoří nový krycí list (Crud)  # noqa: E501

        Vytvoří nový dokument typu krycí list  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_cover(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: uuid kontejneru, do kterého bude krycí list zařazen (required)
        :param CoverSheet body:
        :return: CoverSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_cover_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_cover_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def post_cover_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """vytvoří nový krycí list (Crud)  # noqa: E501

        Vytvoří nový dokument typu krycí list  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_cover_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: uuid kontejneru, do kterého bude krycí list zařazen (required)
        :param CoverSheet body:
        :return: CoverSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_cover" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `post_cover`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'container_id' in params:
            query_params.append(('container_id', params['container_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/cover', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CoverSheet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_payment_event(self, parent_id, **kwargs):  # noqa: E501
        """vytvoří novou položku platebního kalendáře (Crud)  # noqa: E501

        Vytvoří nový dokument typu položka platebního kalendáře  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_payment_event(parent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent_id: identifikátor rodičovského dokumentu (PID, UNID nebo uuid) (required)
        :param PaymentEvent body:
        :return: PaymentEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_payment_event_with_http_info(parent_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_payment_event_with_http_info(parent_id, **kwargs)  # noqa: E501
            return data

    def post_payment_event_with_http_info(self, parent_id, **kwargs):  # noqa: E501
        """vytvoří novou položku platebního kalendáře (Crud)  # noqa: E501

        Vytvoří nový dokument typu položka platebního kalendáře  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_payment_event_with_http_info(parent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent_id: identifikátor rodičovského dokumentu (PID, UNID nebo uuid) (required)
        :param PaymentEvent body:
        :return: PaymentEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['parent_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_payment_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'parent_id' is set
        if ('parent_id' not in params or
                params['parent_id'] is None):
            raise ValueError("Missing the required parameter `parent_id` when calling `post_payment_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/payment_event', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaymentEvent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_registration(self, container_id, **kwargs):  # noqa: E501
        """vytvoří nový evidenční list (Crud)  # noqa: E501

        Vytvoří nový dokument typu evidenční list  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_registration(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: uuid kontejneru, do kterého bude evidenčbí list zařazen (required)
        :param RegistrationSheet body:
        :return: RegistrationSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_registration_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_registration_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def post_registration_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """vytvoří nový evidenční list (Crud)  # noqa: E501

        Vytvoří nový dokument typu evidenční list  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_registration_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: uuid kontejneru, do kterého bude evidenčbí list zařazen (required)
        :param RegistrationSheet body:
        :return: RegistrationSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_registration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `post_registration`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'container_id' in params:
            query_params.append(('container_id', params['container_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/registration', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RegistrationSheet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_standpoint(self, parent_id, **kwargs):  # noqa: E501
        """vytvoří nové stanovisko (Crud)  # noqa: E501

        Vytvoří nový dokument typu stanovisko  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_standpoint(parent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent_id: identifikátor rodičovského dokumentu (PID, UNID nebo uuid) (required)
        :param Standpoint body:
        :return: Standpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_standpoint_with_http_info(parent_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_standpoint_with_http_info(parent_id, **kwargs)  # noqa: E501
            return data

    def post_standpoint_with_http_info(self, parent_id, **kwargs):  # noqa: E501
        """vytvoří nové stanovisko (Crud)  # noqa: E501

        Vytvoří nový dokument typu stanovisko  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_standpoint_with_http_info(parent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str parent_id: identifikátor rodičovského dokumentu (PID, UNID nebo uuid) (required)
        :param Standpoint body:
        :return: Standpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['parent_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_standpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'parent_id' is set
        if ('parent_id' not in params or
                params['parent_id'] is None):
            raise ValueError("Missing the required parameter `parent_id` when calling `post_standpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/standpoint', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Standpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_budget_category(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje položku rozpočtového zařazení s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu rozpočtové zařazení Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_budget_category(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param BudgetCategory body:
        :return: BudgetCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_budget_category_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_budget_category_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def put_budget_category_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje položku rozpočtového zařazení s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu rozpočtové zařazení Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_budget_category_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param BudgetCategory body:
        :return: BudgetCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_budget_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `put_budget_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/budget_category/{identifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BudgetCategory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_container(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje dokumentový kontejner s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu kontejner Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_container(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param Container body:
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument uložen
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_container_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_container_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def put_container_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje dokumentový kontejner s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu kontejner Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_container_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param Container body:
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument uložen
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body', 'author']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `put_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/container/{identifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Container',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_cover(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje krycí list s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu krycí list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_cover(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param CoverSheet body:
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument aktualizován
        :return: CoverSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_cover_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_cover_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def put_cover_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje krycí list s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu krycí list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_cover_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param CoverSheet body:
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument aktualizován
        :return: CoverSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body', 'author']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_cover" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `put_cover`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/cover/{identifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CoverSheet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_payment_event(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje položku platebního kalenáře s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu položka platebního kalendáře Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_payment_event(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param PaymentEvent body:
        :return: PaymentEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_payment_event_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_payment_event_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def put_payment_event_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje položku platebního kalenáře s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu položka platebního kalendáře Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_payment_event_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param PaymentEvent body:
        :return: PaymentEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_payment_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `put_payment_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/payment_event/{identifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaymentEvent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_registration(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje evidenční list s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu evidenční list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_registration(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param RegistrationSheet body:
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument aktualizován
        :return: RegistrationSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_registration_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_registration_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def put_registration_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje evidenční list s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu evidenční list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_registration_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param RegistrationSheet body:
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument aktualizován
        :return: RegistrationSheet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body', 'author']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_registration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `put_registration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/registration/{identifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RegistrationSheet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_standpoint(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje stanovisko s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu krycí list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_standpoint(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param Standpoint body:
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument aktualizován
        :return: Standpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_standpoint_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_standpoint_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def put_standpoint_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje stanovisko s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu krycí list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_standpoint_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param Standpoint body:
        :param str author: Autorizace podle autora. Pokud je jméno mezi autory, bude dokument aktualizován
        :return: Standpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body', 'author']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_standpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `put_standpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/standpoint/{identifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Standpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
