# coding: utf-8

"""
    Datový konektor Domino pro eSMLOUVY

    Toto je datový konektor umožňující datovou výměnu mezi obchodní logikou aplikace eSMLOUVY a datovým serverem HCL Domino.  Ovládá se pomocí REST API   # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: info@sysnet.cz
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class AttachmentsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_attachment(self, storage, identifier, **kwargs):  # noqa: E501
        """odstraní soubor přílohy  # noqa: E501

        Odstraní soubor dokumentové přílohy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_attachment(storage, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storage: Replica ID storage application (required)
        :param str identifier: Identifikátor uuid přílohy (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_attachment_with_http_info(storage, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_attachment_with_http_info(storage, identifier, **kwargs)  # noqa: E501
            return data

    def delete_attachment_with_http_info(self, storage, identifier, **kwargs):  # noqa: E501
        """odstraní soubor přílohy  # noqa: E501

        Odstraní soubor dokumentové přílohy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_attachment_with_http_info(storage, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storage: Replica ID storage application (required)
        :param str identifier: Identifikátor uuid přílohy (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storage', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storage' is set
        if ('storage' not in params or
                params['storage'] is None):
            raise ValueError("Missing the required parameter `storage` when calling `delete_attachment`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_attachment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage' in params:
            path_params['storage'] = params['storage']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/attachment/{storage}/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_attachment(self, storage, identifier, **kwargs):  # noqa: E501
        """vrací soubor přílohy  # noqa: E501

        Vrátí soubor dokumentové přílohy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attachment(storage, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storage: Replica ID storage application (required)
        :param str identifier: Identifikátor uuid přílohy (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_attachment_with_http_info(storage, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_attachment_with_http_info(storage, identifier, **kwargs)  # noqa: E501
            return data

    def get_attachment_with_http_info(self, storage, identifier, **kwargs):  # noqa: E501
        """vrací soubor přílohy  # noqa: E501

        Vrátí soubor dokumentové přílohy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attachment_with_http_info(storage, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storage: Replica ID storage application (required)
        :param str identifier: Identifikátor uuid přílohy (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storage', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storage' is set
        if ('storage' not in params or
                params['storage'] is None):
            raise ValueError("Missing the required parameter `storage` when calling `get_attachment`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_attachment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage' in params:
            path_params['storage'] = params['storage']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/*', 'text/*', 'image/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/attachment/{storage}/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_attachment_list(self, **kwargs):  # noqa: E501
        """získá seznam příloh  # noqa: E501

        Vrátí seznam příloh odpovídající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attachment_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledávací klíčové slovo.
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param str creator: Tvůrce přílohy
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentAttachmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_attachment_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_attachment_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_attachment_list_with_http_info(self, **kwargs):  # noqa: E501
        """získá seznam příloh  # noqa: E501

        Vrátí seznam příloh odpovídající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attachment_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledávací klíčové slovo.
        :param str search: Textové položky pro fulltextové vyhledávání. Lze použít syntax fulltextového vyhledávání Domino - viz nápověda Domino  Při použití vyhledávání podle klíčového slova a fulltextu, je parametr key ignorován. 
        :param str creator: Tvůrce přílohy
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentAttachmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'search', 'creator', 'start', 'page_size', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attachment_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'creator' in params:
            query_params.append(('creator', params['creator']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/attachment', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentAttachmentList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_attachment_list_container(self, container, **kwargs):  # noqa: E501
        """vrací seznam příloh v kontejneru  # noqa: E501

        Vrátí seznam souborových příloh zařazených do kontejneru  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attachment_list_container(container, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container: Identifikátor uuid kontejneru. Může být PID, UNID nebo uuid (required)
        :param list[str] storage: Prohledávaná úložiště
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentAttachmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_attachment_list_container_with_http_info(container, **kwargs)  # noqa: E501
        else:
            (data) = self.get_attachment_list_container_with_http_info(container, **kwargs)  # noqa: E501
            return data

    def get_attachment_list_container_with_http_info(self, container, **kwargs):  # noqa: E501
        """vrací seznam příloh v kontejneru  # noqa: E501

        Vrátí seznam souborových příloh zařazených do kontejneru  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attachment_list_container_with_http_info(container, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container: Identifikátor uuid kontejneru. Může být PID, UNID nebo uuid (required)
        :param list[str] storage: Prohledávaná úložiště
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentAttachmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container', 'storage', 'start', 'page_size', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attachment_list_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container' is set
        if ('container' not in params or
                params['container'] is None):
            raise ValueError("Missing the required parameter `container` when calling `get_attachment_list_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container' in params:
            path_params['container'] = params['container']  # noqa: E501

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))  # noqa: E501
            collection_formats['storage'] = 'multi'  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/atachment/container/{container}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentAttachmentList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_attachment_list_document(self, document, **kwargs):  # noqa: E501
        """vrací seznam příloh v dokumentu  # noqa: E501

        Vrátí seznam souborových příloh zařazených do kontejneru  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attachment_list_document(document, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str document: Identifikátor uuid dokumentu. Může být PID, UNID nebo uuid (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentAttachmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_attachment_list_document_with_http_info(document, **kwargs)  # noqa: E501
        else:
            (data) = self.get_attachment_list_document_with_http_info(document, **kwargs)  # noqa: E501
            return data

    def get_attachment_list_document_with_http_info(self, document, **kwargs):  # noqa: E501
        """vrací seznam příloh v dokumentu  # noqa: E501

        Vrátí seznam souborových příloh zařazených do kontejneru  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attachment_list_document_with_http_info(document, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str document: Identifikátor uuid dokumentu. Může být PID, UNID nebo uuid (required)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentAttachmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document', 'start', 'page_size', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attachment_list_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if ('document' not in params or
                params['document'] is None):
            raise ValueError("Missing the required parameter `document` when calling `get_attachment_list_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'document' in params:
            path_params['document'] = params['document']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/atachment/document/{document}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentAttachmentList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_attachment(self, storage, name, **kwargs):  # noqa: E501
        """uploaduje novou přílohu (Crud)  # noqa: E501

        Uploaduje novou souborovou přílohu dokumentu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_attachment(storage, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storage: Replica ID storage application (required)
        :param str name: Attachment name for display (required)
        :param Object body: binární soubor base64
        :param str title: Attachment title for display
        :param str creator: Osoba, která uploadovala přílohu
        :param str field: RTF pole uložení přílohy
        :param str atttype: Typ přílohy - z číselníku typů
        :param str attsubtype: Typ přílohy - z číselníku typů
        :param str container: Container unique identifier
        :param str document: Source document unique identifier
        :return: DocumentAttachment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_attachment_with_http_info(storage, name, **kwargs)  # noqa: E501
        else:
            (data) = self.post_attachment_with_http_info(storage, name, **kwargs)  # noqa: E501
            return data

    def post_attachment_with_http_info(self, storage, name, **kwargs):  # noqa: E501
        """uploaduje novou přílohu (Crud)  # noqa: E501

        Uploaduje novou souborovou přílohu dokumentu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_attachment_with_http_info(storage, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storage: Replica ID storage application (required)
        :param str name: Attachment name for display (required)
        :param Object body: binární soubor base64
        :param str title: Attachment title for display
        :param str creator: Osoba, která uploadovala přílohu
        :param str field: RTF pole uložení přílohy
        :param str atttype: Typ přílohy - z číselníku typů
        :param str attsubtype: Typ přílohy - z číselníku typů
        :param str container: Container unique identifier
        :param str document: Source document unique identifier
        :return: DocumentAttachment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storage', 'name', 'body', 'title', 'creator', 'field', 'atttype', 'attsubtype', 'container', 'document']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storage' is set
        if ('storage' not in params or
                params['storage'] is None):
            raise ValueError("Missing the required parameter `storage` when calling `post_attachment`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `post_attachment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'title' in params:
            query_params.append(('title', params['title']))  # noqa: E501
        if 'creator' in params:
            query_params.append(('creator', params['creator']))  # noqa: E501
        if 'field' in params:
            query_params.append(('field', params['field']))  # noqa: E501
        if 'atttype' in params:
            query_params.append(('atttype', params['atttype']))  # noqa: E501
        if 'attsubtype' in params:
            query_params.append(('attsubtype', params['attsubtype']))  # noqa: E501
        if 'container' in params:
            query_params.append(('container', params['container']))  # noqa: E501
        if 'document' in params:
            query_params.append(('document', params['document']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/attachment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentAttachment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
