"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SesUser = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const RESOURCE_TYPE = 'Custom::HalloumiSesUserPassword';
/**
 * Define a new IAM user and generates the SES credentials.
 *
 * @stability stable
 */
class SesUser extends aws_iam_1.User {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        const access_keys = new aws_iam_1.CfnAccessKey(scope, `${id}AccessKeys`, {
            userName: this.userName,
        });
        const secret_key = core_1.Fn.getAtt(access_keys.logicalId, 'SecretAccessKey');
        this.accessKey = access_keys.ref;
        this.secretKey = secret_key.toString();
        const _lambda_role = new aws_iam_1.Role(scope, `${id}Role`, {
            assumedBy: new aws_iam_1.ServicePrincipal('lambda.amazonaws.com'),
        });
        _lambda_role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['logs:CreateLogGroup', 'logs:CreateLogStream', 'logs:PutLogEvents'],
            effect: aws_iam_1.Effect.ALLOW,
            resources: ['arn:aws:logs:*:*:*'],
        }));
        const _lambda_ses_password = new aws_lambda_1.Function(scope, `${id}Function`, {
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambda')),
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.on_event',
            role: _lambda_role,
        });
        const custom_resource = new core_1.CustomResource(scope, `${id}CustomResource`, {
            serviceToken: _lambda_ses_password.functionArn,
            resourceType: RESOURCE_TYPE,
            properties: {
                SecretKey: this.secretKey,
            },
        });
        this.smtpPassword = custom_resource.getAtt('password').toString();
    }
}
exports.SesUser = SesUser;
_a = JSII_RTTI_SYMBOL_1;
SesUser[_a] = { fqn: "halloumi-ses.SesUser", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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