import { User, UserProps } from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
/**
 * Define a new IAM user and generates the SES credentials.
 *
 * @stability stable
 */
export declare class SesUser extends User {
    /**
     * An attribute that represents the user access_key.
     *
     * @stability stable
     * @attribute true
     */
    readonly accessKey: string;
    /**
     * An attribute that represents the user secret_key.
     *
     * @stability stable
     * @attribute true
     */
    readonly secretKey: string;
    /**
     * An attribute that represents the user smtp password.
     *
     * @stability stable
     * @attribute true
     */
    readonly smtpPassword: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: UserProps);
}
