# API Reference

**Classes**

Name|Description
----|-----------
[SesUser](#halloumi-ses-sesuser)|Define a new IAM user and generates the SES credentials.



## class SesUser  <a id="halloumi-ses-sesuser"></a>

Define a new IAM user and generates the SES credentials.

__Implements__: [IConstruct](#constructs-iconstruct), [IConstruct](#aws-cdk-core-iconstruct), [IConstruct](#constructs-iconstruct), [IDependable](#aws-cdk-core-idependable), [IResource](#aws-cdk-core-iresource), [IConstruct](#constructs-iconstruct), [IDependable](#aws-cdk-core-idependable), [IConstruct](#aws-cdk-core-iconstruct), [IIdentity](#aws-cdk-aws-iam-iidentity), [IGrantable](#aws-cdk-aws-iam-igrantable), [IPrincipal](#aws-cdk-aws-iam-iprincipal), [IConstruct](#constructs-iconstruct), [IDependable](#aws-cdk-core-idependable), [IConstruct](#aws-cdk-core-iconstruct), [IResource](#aws-cdk-core-iresource), [IUser](#aws-cdk-aws-iam-iuser), [IGrantable](#aws-cdk-aws-iam-igrantable), [IPrincipal](#aws-cdk-aws-iam-iprincipal), [IConstruct](#constructs-iconstruct), [IDependable](#aws-cdk-core-idependable), [IConstruct](#aws-cdk-core-iconstruct), [IResource](#aws-cdk-core-iresource), [IIdentity](#aws-cdk-aws-iam-iidentity)
__Extends__: [User](#aws-cdk-aws-iam-user)

### Initializer




```ts
new SesUser(scope: Construct, id: string, props?: UserProps)
```

* **scope** (<code>[Construct](#aws-cdk-core-construct)</code>)  *No description*
* **id** (<code>string</code>)  *No description*
* **props** (<code>[UserProps](#aws-cdk-aws-iam-userprops)</code>)  *No description*
  * **groups** (<code>Array<[IGroup](#aws-cdk-aws-iam-igroup)></code>)  Groups to add this user to. __*Default*__: No groups.
  * **managedPolicies** (<code>Array<[IManagedPolicy](#aws-cdk-aws-iam-imanagedpolicy)></code>)  A list of managed policies associated with this role. __*Default*__: No managed policies.
  * **password** (<code>[SecretValue](#aws-cdk-core-secretvalue)</code>)  The password for the user. This is required so the user can access the AWS Management Console. __*Default*__: User won't be able to access the management console without a password.
  * **passwordResetRequired** (<code>boolean</code>)  Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console. __*Default*__: false
  * **path** (<code>string</code>)  The path for the user name. __*Default*__: /
  * **permissionsBoundary** (<code>[IManagedPolicy](#aws-cdk-aws-iam-imanagedpolicy)</code>)  AWS supports permissions boundaries for IAM entities (users or roles). __*Default*__: No permissions boundary.
  * **userName** (<code>string</code>)  A name for the IAM user. __*Default*__: Generated by CloudFormation (recommended)



### Properties


Name | Type | Description 
-----|------|-------------
**accessKey** | <code>string</code> | An attribute that represents the user access_key.
**secretKey** | <code>string</code> | An attribute that represents the user secret_key.
**smtpPassword** | <code>string</code> | An attribute that represents the user smtp password.



