(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["vendors-node_modules_monaco-editor_esm_vs_basic-languages_protobuf_protobuf_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/protobuf/protobuf.js":
/*!********************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/protobuf/protobuf.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/protobuf/protobuf.ts
var namedLiterals = ["true", "false"];
var conf = {
  comments: {
    lineComment: "//",
    blockComment: ["/*", "*/"]
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"],
    ["<", ">"]
  ],
  surroundingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: "<", close: ">" },
    { open: '"', close: '"' },
    { open: "'", close: "'" }
  ],
  autoClosingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: "<", close: ">" },
    { open: '"', close: '"', notIn: ["string"] },
    { open: "'", close: "'", notIn: ["string"] }
  ],
  autoCloseBefore: ".,=}])>' \n	",
  indentationRules: {
    increaseIndentPattern: new RegExp("^((?!\\/\\/).)*(\\{[^}\"'`]*|\\([^)\"'`]*|\\[[^\\]\"'`]*)$"),
    decreaseIndentPattern: new RegExp("^((?!.*?\\/\\*).*\\*/)?\\s*[\\}\\]].*$")
  }
};
var language = {
  defaultToken: "",
  tokenPostfix: ".proto",
  brackets: [
    { open: "{", close: "}", token: "delimiter.curly" },
    { open: "[", close: "]", token: "delimiter.square" },
    { open: "(", close: ")", token: "delimiter.parenthesis" },
    { open: "<", close: ">", token: "delimiter.angle" }
  ],
  symbols: /[=><!~?:&|+\-*/^%]+/,
  keywords: [
    "syntax",
    "import",
    "weak",
    "public",
    "package",
    "option",
    "repeated",
    "oneof",
    "map",
    "reserved",
    "to",
    "max",
    "enum",
    "message",
    "service",
    "rpc",
    "stream",
    "returns",
    "package",
    "optional",
    "true",
    "false"
  ],
  builtinTypes: [
    "double",
    "float",
    "int32",
    "int64",
    "uint32",
    "uint64",
    "sint32",
    "sint64",
    "fixed32",
    "fixed64",
    "sfixed32",
    "sfixed64",
    "bool",
    "string",
    "bytes"
  ],
  operators: ["=", "+", "-"],
  namedLiterals,
  escapes: `\\\\(u{[0-9A-Fa-f]+}|n|r|t|\\\\|'|\\\${)`,
  identifier: /[a-zA-Z]\w*/,
  fullIdentifier: /@identifier(?:\s*\.\s*@identifier)*/,
  optionName: /(?:@identifier|\(\s*@fullIdentifier\s*\))(?:\s*\.\s*@identifier)*/,
  messageName: /@identifier/,
  enumName: /@identifier/,
  messageType: /\.?\s*(?:@identifier\s*\.\s*)*@messageName/,
  enumType: /\.?\s*(?:@identifier\s*\.\s*)*@enumName/,
  floatLit: /[0-9]+\s*\.\s*[0-9]*(?:@exponent)?|[0-9]+@exponent|\.[0-9]+(?:@exponent)?/,
  exponent: /[eE]\s*[+-]?\s*[0-9]+/,
  boolLit: /true\b|false\b/,
  decimalLit: /[1-9][0-9]*/,
  octalLit: /0[0-7]*/,
  hexLit: /0[xX][0-9a-fA-F]+/,
  type: /double|float|int32|int64|uint32|uint64|sint32|sint64|fixed32|fixed64|sfixed32|sfixed64|bool|string|bytes|@messageType|@enumType/,
  keyType: /int32|int64|uint32|uint64|sint32|sint64|fixed32|fixed64|sfixed32|sfixed64|bool|string/,
  tokenizer: {
    root: [
      { include: "@whitespace" },
      [/syntax/, "keyword"],
      [/=/, "operators"],
      [/;/, "delimiter"],
      [
        /(")(proto3)(")/,
        ["string.quote", "string", { token: "string.quote", switchTo: "@topLevel.proto3" }]
      ],
      [
        /(")(proto2)(")/,
        ["string.quote", "string", { token: "string.quote", switchTo: "@topLevel.proto2" }]
      ],
      [
        /.*?/,
        { token: "", switchTo: "@topLevel.proto2" }
      ]
    ],
    topLevel: [
      { include: "@whitespace" },
      { include: "@constant" },
      [/=/, "operators"],
      [/[;.]/, "delimiter"],
      [
        /@fullIdentifier/,
        {
          cases: {
            option: { token: "keyword", next: "@option.$S2" },
            enum: { token: "keyword", next: "@enumDecl.$S2" },
            message: { token: "keyword", next: "@messageDecl.$S2" },
            service: { token: "keyword", next: "@serviceDecl.$S2" },
            extend: {
              cases: {
                "$S2==proto2": { token: "keyword", next: "@extendDecl.$S2" }
              }
            },
            "@keywords": "keyword",
            "@default": "identifier"
          }
        }
      ]
    ],
    enumDecl: [
      { include: "@whitespace" },
      [/@identifier/, "type.identifier"],
      [/{/, { token: "@brackets", bracket: "@open", switchTo: "@enumBody.$S2" }]
    ],
    enumBody: [
      { include: "@whitespace" },
      { include: "@constant" },
      [/=/, "operators"],
      [/;/, "delimiter"],
      [/option\b/, "keyword", "@option.$S2"],
      [/@identifier/, "identifier"],
      [/\[/, { token: "@brackets", bracket: "@open", next: "@options.$S2" }],
      [/}/, { token: "@brackets", bracket: "@close", next: "@pop" }]
    ],
    messageDecl: [
      { include: "@whitespace" },
      [/@identifier/, "type.identifier"],
      [/{/, { token: "@brackets", bracket: "@open", switchTo: "@messageBody.$S2" }]
    ],
    messageBody: [
      { include: "@whitespace" },
      { include: "@constant" },
      [/=/, "operators"],
      [/;/, "delimiter"],
      [
        "(map)(s*)(<)",
        ["keyword", "white", { token: "@brackets", bracket: "@open", next: "@map.$S2" }]
      ],
      [
        /@identifier/,
        {
          cases: {
            option: { token: "keyword", next: "@option.$S2" },
            enum: { token: "keyword", next: "@enumDecl.$S2" },
            message: { token: "keyword", next: "@messageDecl.$S2" },
            oneof: { token: "keyword", next: "@oneofDecl.$S2" },
            extensions: {
              cases: {
                "$S2==proto2": { token: "keyword", next: "@reserved.$S2" }
              }
            },
            reserved: { token: "keyword", next: "@reserved.$S2" },
            "(?:repeated|optional)": { token: "keyword", next: "@field.$S2" },
            required: {
              cases: {
                "$S2==proto2": { token: "keyword", next: "@field.$S2" }
              }
            },
            "$S2==proto3": { token: "@rematch", next: "@field.$S2" }
          }
        }
      ],
      [/\[/, { token: "@brackets", bracket: "@open", next: "@options.$S2" }],
      [/}/, { token: "@brackets", bracket: "@close", next: "@pop" }]
    ],
    extendDecl: [
      { include: "@whitespace" },
      [/@identifier/, "type.identifier"],
      [/{/, { token: "@brackets", bracket: "@open", switchTo: "@extendBody.$S2" }]
    ],
    extendBody: [
      { include: "@whitespace" },
      { include: "@constant" },
      [/;/, "delimiter"],
      [/(?:repeated|optional|required)/, "keyword", "@field.$S2"],
      [/\[/, { token: "@brackets", bracket: "@open", next: "@options.$S2" }],
      [/}/, { token: "@brackets", bracket: "@close", next: "@pop" }]
    ],
    options: [
      { include: "@whitespace" },
      { include: "@constant" },
      [/;/, "delimiter"],
      [/@optionName/, "annotation"],
      [/[()]/, "annotation.brackets"],
      [/=/, "operator"],
      [/\]/, { token: "@brackets", bracket: "@close", next: "@pop" }]
    ],
    option: [
      { include: "@whitespace" },
      [/@optionName/, "annotation"],
      [/[()]/, "annotation.brackets"],
      [/=/, "operator", "@pop"]
    ],
    oneofDecl: [
      { include: "@whitespace" },
      [/@identifier/, "identifier"],
      [/{/, { token: "@brackets", bracket: "@open", switchTo: "@oneofBody.$S2" }]
    ],
    oneofBody: [
      { include: "@whitespace" },
      { include: "@constant" },
      [/;/, "delimiter"],
      [/(@identifier)(\s*)(=)/, ["identifier", "white", "delimiter"]],
      [
        /@fullIdentifier|\./,
        {
          cases: {
            "@builtinTypes": "keyword",
            "@default": "type.identifier"
          }
        }
      ],
      [/\[/, { token: "@brackets", bracket: "@open", next: "@options.$S2" }],
      [/}/, { token: "@brackets", bracket: "@close", next: "@pop" }]
    ],
    reserved: [
      { include: "@whitespace" },
      [/,/, "delimiter"],
      [/;/, "delimiter", "@pop"],
      { include: "@constant" },
      [/to\b|max\b/, "keyword"]
    ],
    map: [
      { include: "@whitespace" },
      [
        /@fullIdentifier|\./,
        {
          cases: {
            "@builtinTypes": "keyword",
            "@default": "type.identifier"
          }
        }
      ],
      [/,/, "delimiter"],
      [/>/, { token: "@brackets", bracket: "@close", switchTo: "identifier" }]
    ],
    field: [
      { include: "@whitespace" },
      [
        "group",
        {
          cases: {
            "$S2==proto2": { token: "keyword", switchTo: "@groupDecl.$S2" }
          }
        }
      ],
      [/(@identifier)(\s*)(=)/, ["identifier", "white", { token: "delimiter", next: "@pop" }]],
      [
        /@fullIdentifier|\./,
        {
          cases: {
            "@builtinTypes": "keyword",
            "@default": "type.identifier"
          }
        }
      ]
    ],
    groupDecl: [
      { include: "@whitespace" },
      [/@identifier/, "identifier"],
      ["=", "operator"],
      [/{/, { token: "@brackets", bracket: "@open", switchTo: "@messageBody.$S2" }],
      { include: "@constant" }
    ],
    type: [
      { include: "@whitespace" },
      [/@identifier/, "type.identifier", "@pop"],
      [/./, "delimiter"]
    ],
    identifier: [{ include: "@whitespace" }, [/@identifier/, "identifier", "@pop"]],
    serviceDecl: [
      { include: "@whitespace" },
      [/@identifier/, "identifier"],
      [/{/, { token: "@brackets", bracket: "@open", switchTo: "@serviceBody.$S2" }]
    ],
    serviceBody: [
      { include: "@whitespace" },
      { include: "@constant" },
      [/;/, "delimiter"],
      [/option\b/, "keyword", "@option.$S2"],
      [/rpc\b/, "keyword", "@rpc.$S2"],
      [/\[/, { token: "@brackets", bracket: "@open", next: "@options.$S2" }],
      [/}/, { token: "@brackets", bracket: "@close", next: "@pop" }]
    ],
    rpc: [
      { include: "@whitespace" },
      [/@identifier/, "identifier"],
      [/\(/, { token: "@brackets", bracket: "@open", switchTo: "@request.$S2" }],
      [/{/, { token: "@brackets", bracket: "@open", next: "@methodOptions.$S2" }],
      [/;/, "delimiter", "@pop"]
    ],
    request: [
      { include: "@whitespace" },
      [
        /@messageType/,
        {
          cases: {
            stream: { token: "keyword", next: "@type.$S2" },
            "@default": "type.identifier"
          }
        }
      ],
      [/\)/, { token: "@brackets", bracket: "@close", switchTo: "@returns.$S2" }]
    ],
    returns: [
      { include: "@whitespace" },
      [/returns\b/, "keyword"],
      [/\(/, { token: "@brackets", bracket: "@open", switchTo: "@response.$S2" }]
    ],
    response: [
      { include: "@whitespace" },
      [
        /@messageType/,
        {
          cases: {
            stream: { token: "keyword", next: "@type.$S2" },
            "@default": "type.identifier"
          }
        }
      ],
      [/\)/, { token: "@brackets", bracket: "@close", switchTo: "@rpc.$S2" }]
    ],
    methodOptions: [
      { include: "@whitespace" },
      { include: "@constant" },
      [/;/, "delimiter"],
      ["option", "keyword"],
      [/@optionName/, "annotation"],
      [/[()]/, "annotation.brackets"],
      [/=/, "operator"],
      [/}/, { token: "@brackets", bracket: "@close", next: "@pop" }]
    ],
    comment: [
      [/[^\/*]+/, "comment"],
      [/\/\*/, "comment", "@push"],
      ["\\*/", "comment", "@pop"],
      [/[\/*]/, "comment"]
    ],
    string: [
      [/[^\\"]+/, "string"],
      [/@escapes/, "string.escape"],
      [/\\./, "string.escape.invalid"],
      [/"/, { token: "string.quote", bracket: "@close", next: "@pop" }]
    ],
    stringSingle: [
      [/[^\\']+/, "string"],
      [/@escapes/, "string.escape"],
      [/\\./, "string.escape.invalid"],
      [/'/, { token: "string.quote", bracket: "@close", next: "@pop" }]
    ],
    constant: [
      ["@boolLit", "keyword.constant"],
      ["@hexLit", "number.hex"],
      ["@octalLit", "number.octal"],
      ["@decimalLit", "number"],
      ["@floatLit", "number.float"],
      [/("([^"\\]|\\.)*|'([^'\\]|\\.)*)$/, "string.invalid"],
      [/"/, { token: "string.quote", bracket: "@open", next: "@string" }],
      [/'/, { token: "string.quote", bracket: "@open", next: "@stringSingle" }],
      [/{/, { token: "@brackets", bracket: "@open", next: "@prototext" }],
      [/identifier/, "identifier"]
    ],
    whitespace: [
      [/[ \t\r\n]+/, "white"],
      [/\/\*/, "comment", "@comment"],
      [/\/\/.*$/, "comment"]
    ],
    prototext: [
      { include: "@whitespace" },
      { include: "@constant" },
      [/@identifier/, "identifier"],
      [/[:;]/, "delimiter"],
      [/}/, { token: "@brackets", bracket: "@close", next: "@pop" }]
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmVuZG9ycy1ub2RlX21vZHVsZXNfbW9uYWNvLWVkaXRvcl9lc21fdnNfYmFzaWMtbGFuZ3VhZ2VzX3Byb3RvYnVmX3Byb3RvYnVmX2pzLndlYi5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBLE9BQU8sS0FBSztBQUNaO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxNQUFNLFFBQVEsWUFBWSxHQUFHO0FBQzdCLE1BQU0sdUJBQXVCO0FBQzdCLE1BQU0sdUJBQXVCO0FBQzdCLE1BQU0sdUJBQXVCO0FBQzdCLE1BQU0sdUJBQXVCO0FBQzdCLE1BQU07QUFDTjtBQUNBO0FBQ0EsTUFBTSxRQUFRLFlBQVksR0FBRztBQUM3QixNQUFNLHVCQUF1QjtBQUM3QixNQUFNLHVCQUF1QjtBQUM3QixNQUFNLHVCQUF1QjtBQUM3QixNQUFNLDBDQUEwQztBQUNoRCxNQUFNO0FBQ047QUFDQSx3QkFBd0I7QUFDeEI7QUFDQSwwREFBMEQsR0FBRztBQUM3RCxzRUFBc0U7QUFDdEU7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTSxRQUFRLFlBQVksNkJBQTZCO0FBQ3ZELE1BQU0sa0RBQWtEO0FBQ3hELE1BQU0sdURBQXVEO0FBQzdELE1BQU07QUFDTjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxtQkFBbUIsYUFBYSxtQkFBbUI7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVEsd0JBQXdCO0FBQ2hDO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLHFDQUFxQyxxREFBcUQ7QUFDMUY7QUFDQTtBQUNBO0FBQ0EscUNBQXFDLHFEQUFxRDtBQUMxRjtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBO0FBQ0EsUUFBUSx3QkFBd0I7QUFDaEMsUUFBUSxzQkFBc0I7QUFDOUI7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBO0FBQ0E7QUFDQSxzQkFBc0IsdUNBQXVDO0FBQzdELG9CQUFvQix5Q0FBeUM7QUFDN0QsdUJBQXVCLDRDQUE0QztBQUNuRSx1QkFBdUIsNENBQTRDO0FBQ25FO0FBQ0E7QUFDQSxpQ0FBaUM7QUFDakM7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRLHdCQUF3QjtBQUNoQztBQUNBLFNBQVMsS0FBSyxpRUFBaUU7QUFDL0U7QUFDQTtBQUNBLFFBQVEsd0JBQXdCO0FBQ2hDLFFBQVEsc0JBQXNCO0FBQzlCO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxlQUFlLDREQUE0RDtBQUMzRSxTQUFTLEtBQUsscURBQXFEO0FBQ25FO0FBQ0E7QUFDQSxRQUFRLHdCQUF3QjtBQUNoQztBQUNBLFNBQVMsS0FBSyxvRUFBb0U7QUFDbEY7QUFDQTtBQUNBLFFBQVEsd0JBQXdCO0FBQ2hDLFFBQVEsc0JBQXNCO0FBQzlCO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSwrQkFBK0Isd0RBQXdEO0FBQ3ZGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxzQkFBc0IsdUNBQXVDO0FBQzdELG9CQUFvQix5Q0FBeUM7QUFDN0QsdUJBQXVCLDRDQUE0QztBQUNuRSxxQkFBcUIsMENBQTBDO0FBQy9EO0FBQ0E7QUFDQSxpQ0FBaUM7QUFDakM7QUFDQSxhQUFhO0FBQ2Isd0JBQXdCLHlDQUF5QztBQUNqRSx1Q0FBdUMsc0NBQXNDO0FBQzdFO0FBQ0E7QUFDQSxpQ0FBaUM7QUFDakM7QUFDQSxhQUFhO0FBQ2IsNkJBQTZCO0FBQzdCO0FBQ0E7QUFDQTtBQUNBLGVBQWUsNERBQTREO0FBQzNFLFNBQVMsS0FBSyxxREFBcUQ7QUFDbkU7QUFDQTtBQUNBLFFBQVEsd0JBQXdCO0FBQ2hDO0FBQ0EsU0FBUyxLQUFLLG1FQUFtRTtBQUNqRjtBQUNBO0FBQ0EsUUFBUSx3QkFBd0I7QUFDaEMsUUFBUSxzQkFBc0I7QUFDOUIsU0FBUztBQUNUO0FBQ0EsZUFBZSw0REFBNEQ7QUFDM0UsU0FBUyxLQUFLLHFEQUFxRDtBQUNuRTtBQUNBO0FBQ0EsUUFBUSx3QkFBd0I7QUFDaEMsUUFBUSxzQkFBc0I7QUFDOUIsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBLGVBQWUscURBQXFEO0FBQ3BFO0FBQ0E7QUFDQSxRQUFRLHdCQUF3QjtBQUNoQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsUUFBUSx3QkFBd0I7QUFDaEM7QUFDQSxTQUFTLEtBQUssa0VBQWtFO0FBQ2hGO0FBQ0E7QUFDQSxRQUFRLHdCQUF3QjtBQUNoQyxRQUFRLHNCQUFzQjtBQUM5QixTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxlQUFlLDREQUE0RDtBQUMzRSxTQUFTLEtBQUsscURBQXFEO0FBQ25FO0FBQ0E7QUFDQSxRQUFRLHdCQUF3QjtBQUNoQztBQUNBLFNBQVM7QUFDVCxRQUFRLHNCQUFzQjtBQUM5QjtBQUNBO0FBQ0E7QUFDQSxRQUFRLHdCQUF3QjtBQUNoQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGNBQWMsK0RBQStEO0FBQzdFO0FBQ0E7QUFDQSxRQUFRLHdCQUF3QjtBQUNoQztBQUNBO0FBQ0E7QUFDQTtBQUNBLDZCQUE2QjtBQUM3QjtBQUNBO0FBQ0E7QUFDQSwwREFBMEQsa0NBQWtDO0FBQzVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRLHdCQUF3QjtBQUNoQztBQUNBO0FBQ0EsU0FBUyxLQUFLLG9FQUFvRTtBQUNsRixRQUFRO0FBQ1I7QUFDQTtBQUNBLFFBQVEsd0JBQXdCO0FBQ2hDO0FBQ0E7QUFDQTtBQUNBLG1CQUFtQix3QkFBd0I7QUFDM0M7QUFDQSxRQUFRLHdCQUF3QjtBQUNoQztBQUNBLFNBQVMsS0FBSyxvRUFBb0U7QUFDbEY7QUFDQTtBQUNBLFFBQVEsd0JBQXdCO0FBQ2hDLFFBQVEsc0JBQXNCO0FBQzlCLFNBQVM7QUFDVDtBQUNBO0FBQ0EsZUFBZSw0REFBNEQ7QUFDM0UsU0FBUyxLQUFLLHFEQUFxRDtBQUNuRTtBQUNBO0FBQ0EsUUFBUSx3QkFBd0I7QUFDaEM7QUFDQSxlQUFlLGdFQUFnRTtBQUMvRSxTQUFTLEtBQUssa0VBQWtFO0FBQ2hGLFNBQVM7QUFDVDtBQUNBO0FBQ0EsUUFBUSx3QkFBd0I7QUFDaEM7QUFDQTtBQUNBO0FBQ0E7QUFDQSxzQkFBc0IscUNBQXFDO0FBQzNEO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsZUFBZSxpRUFBaUU7QUFDaEY7QUFDQTtBQUNBLFFBQVEsd0JBQXdCO0FBQ2hDO0FBQ0EsZUFBZSxpRUFBaUU7QUFDaEY7QUFDQTtBQUNBLFFBQVEsd0JBQXdCO0FBQ2hDO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCLHFDQUFxQztBQUMzRDtBQUNBO0FBQ0E7QUFDQTtBQUNBLGVBQWUsNkRBQTZEO0FBQzVFO0FBQ0E7QUFDQSxRQUFRLHdCQUF3QjtBQUNoQyxRQUFRLHNCQUFzQjtBQUM5QixTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTLEtBQUsscURBQXFEO0FBQ25FO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxjQUFjLHdEQUF3RDtBQUN0RTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsY0FBYyx3REFBd0Q7QUFDdEU7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGNBQWMsMERBQTBEO0FBQ3hFLGNBQWMsZ0VBQWdFO0FBQzlFLFNBQVMsS0FBSywwREFBMEQ7QUFDeEU7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVEsd0JBQXdCO0FBQ2hDLFFBQVEsc0JBQXNCO0FBQzlCO0FBQ0EsV0FBVztBQUNYLFNBQVMsS0FBSyxxREFBcUQ7QUFDbkU7QUFDQTtBQUNBO0FBSUUiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly93ZWIuanMvLi9ub2RlX21vZHVsZXMvbW9uYWNvLWVkaXRvci9lc20vdnMvYmFzaWMtbGFuZ3VhZ2VzL3Byb3RvYnVmL3Byb3RvYnVmLmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qIS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXG4gKiBDb3B5cmlnaHQgKGMpIE1pY3Jvc29mdCBDb3Jwb3JhdGlvbi4gQWxsIHJpZ2h0cyByZXNlcnZlZC5cbiAqIFZlcnNpb246IDAuMzQuMSg1NDc4NzBiNjg4MTMwMmM1YjRmZjMyMTczYzE2ZDA2MDA5ZTM1ODhmKVxuICogUmVsZWFzZWQgdW5kZXIgdGhlIE1JVCBsaWNlbnNlXG4gKiBodHRwczovL2dpdGh1Yi5jb20vbWljcm9zb2Z0L21vbmFjby1lZGl0b3IvYmxvYi9tYWluL0xJQ0VOU0UudHh0XG4gKi0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tKi9cblxuLy8gc3JjL2Jhc2ljLWxhbmd1YWdlcy9wcm90b2J1Zi9wcm90b2J1Zi50c1xudmFyIG5hbWVkTGl0ZXJhbHMgPSBbXCJ0cnVlXCIsIFwiZmFsc2VcIl07XG52YXIgY29uZiA9IHtcbiAgY29tbWVudHM6IHtcbiAgICBsaW5lQ29tbWVudDogXCIvL1wiLFxuICAgIGJsb2NrQ29tbWVudDogW1wiLypcIiwgXCIqL1wiXVxuICB9LFxuICBicmFja2V0czogW1xuICAgIFtcIntcIiwgXCJ9XCJdLFxuICAgIFtcIltcIiwgXCJdXCJdLFxuICAgIFtcIihcIiwgXCIpXCJdLFxuICAgIFtcIjxcIiwgXCI+XCJdXG4gIF0sXG4gIHN1cnJvdW5kaW5nUGFpcnM6IFtcbiAgICB7IG9wZW46IFwie1wiLCBjbG9zZTogXCJ9XCIgfSxcbiAgICB7IG9wZW46IFwiW1wiLCBjbG9zZTogXCJdXCIgfSxcbiAgICB7IG9wZW46IFwiKFwiLCBjbG9zZTogXCIpXCIgfSxcbiAgICB7IG9wZW46IFwiPFwiLCBjbG9zZTogXCI+XCIgfSxcbiAgICB7IG9wZW46ICdcIicsIGNsb3NlOiAnXCInIH0sXG4gICAgeyBvcGVuOiBcIidcIiwgY2xvc2U6IFwiJ1wiIH1cbiAgXSxcbiAgYXV0b0Nsb3NpbmdQYWlyczogW1xuICAgIHsgb3BlbjogXCJ7XCIsIGNsb3NlOiBcIn1cIiB9LFxuICAgIHsgb3BlbjogXCJbXCIsIGNsb3NlOiBcIl1cIiB9LFxuICAgIHsgb3BlbjogXCIoXCIsIGNsb3NlOiBcIilcIiB9LFxuICAgIHsgb3BlbjogXCI8XCIsIGNsb3NlOiBcIj5cIiB9LFxuICAgIHsgb3BlbjogJ1wiJywgY2xvc2U6ICdcIicsIG5vdEluOiBbXCJzdHJpbmdcIl0gfSxcbiAgICB7IG9wZW46IFwiJ1wiLCBjbG9zZTogXCInXCIsIG5vdEluOiBbXCJzdHJpbmdcIl0gfVxuICBdLFxuICBhdXRvQ2xvc2VCZWZvcmU6IFwiLiw9fV0pPicgXFxuXHRcIixcbiAgaW5kZW50YXRpb25SdWxlczoge1xuICAgIGluY3JlYXNlSW5kZW50UGF0dGVybjogbmV3IFJlZ0V4cChcIl4oKD8hXFxcXC9cXFxcLykuKSooXFxcXHtbXn1cXFwiJ2BdKnxcXFxcKFteKVxcXCInYF0qfFxcXFxbW15cXFxcXVxcXCInYF0qKSRcIiksXG4gICAgZGVjcmVhc2VJbmRlbnRQYXR0ZXJuOiBuZXcgUmVnRXhwKFwiXigoPyEuKj9cXFxcL1xcXFwqKS4qXFxcXCovKT9cXFxccypbXFxcXH1cXFxcXV0uKiRcIilcbiAgfVxufTtcbnZhciBsYW5ndWFnZSA9IHtcbiAgZGVmYXVsdFRva2VuOiBcIlwiLFxuICB0b2tlblBvc3RmaXg6IFwiLnByb3RvXCIsXG4gIGJyYWNrZXRzOiBbXG4gICAgeyBvcGVuOiBcIntcIiwgY2xvc2U6IFwifVwiLCB0b2tlbjogXCJkZWxpbWl0ZXIuY3VybHlcIiB9LFxuICAgIHsgb3BlbjogXCJbXCIsIGNsb3NlOiBcIl1cIiwgdG9rZW46IFwiZGVsaW1pdGVyLnNxdWFyZVwiIH0sXG4gICAgeyBvcGVuOiBcIihcIiwgY2xvc2U6IFwiKVwiLCB0b2tlbjogXCJkZWxpbWl0ZXIucGFyZW50aGVzaXNcIiB9LFxuICAgIHsgb3BlbjogXCI8XCIsIGNsb3NlOiBcIj5cIiwgdG9rZW46IFwiZGVsaW1pdGVyLmFuZ2xlXCIgfVxuICBdLFxuICBzeW1ib2xzOiAvWz0+PCF+PzomfCtcXC0qL14lXSsvLFxuICBrZXl3b3JkczogW1xuICAgIFwic3ludGF4XCIsXG4gICAgXCJpbXBvcnRcIixcbiAgICBcIndlYWtcIixcbiAgICBcInB1YmxpY1wiLFxuICAgIFwicGFja2FnZVwiLFxuICAgIFwib3B0aW9uXCIsXG4gICAgXCJyZXBlYXRlZFwiLFxuICAgIFwib25lb2ZcIixcbiAgICBcIm1hcFwiLFxuICAgIFwicmVzZXJ2ZWRcIixcbiAgICBcInRvXCIsXG4gICAgXCJtYXhcIixcbiAgICBcImVudW1cIixcbiAgICBcIm1lc3NhZ2VcIixcbiAgICBcInNlcnZpY2VcIixcbiAgICBcInJwY1wiLFxuICAgIFwic3RyZWFtXCIsXG4gICAgXCJyZXR1cm5zXCIsXG4gICAgXCJwYWNrYWdlXCIsXG4gICAgXCJvcHRpb25hbFwiLFxuICAgIFwidHJ1ZVwiLFxuICAgIFwiZmFsc2VcIlxuICBdLFxuICBidWlsdGluVHlwZXM6IFtcbiAgICBcImRvdWJsZVwiLFxuICAgIFwiZmxvYXRcIixcbiAgICBcImludDMyXCIsXG4gICAgXCJpbnQ2NFwiLFxuICAgIFwidWludDMyXCIsXG4gICAgXCJ1aW50NjRcIixcbiAgICBcInNpbnQzMlwiLFxuICAgIFwic2ludDY0XCIsXG4gICAgXCJmaXhlZDMyXCIsXG4gICAgXCJmaXhlZDY0XCIsXG4gICAgXCJzZml4ZWQzMlwiLFxuICAgIFwic2ZpeGVkNjRcIixcbiAgICBcImJvb2xcIixcbiAgICBcInN0cmluZ1wiLFxuICAgIFwiYnl0ZXNcIlxuICBdLFxuICBvcGVyYXRvcnM6IFtcIj1cIiwgXCIrXCIsIFwiLVwiXSxcbiAgbmFtZWRMaXRlcmFscyxcbiAgZXNjYXBlczogYFxcXFxcXFxcKHV7WzAtOUEtRmEtZl0rfXxufHJ8dHxcXFxcXFxcXHwnfFxcXFxcXCR7KWAsXG4gIGlkZW50aWZpZXI6IC9bYS16QS1aXVxcdyovLFxuICBmdWxsSWRlbnRpZmllcjogL0BpZGVudGlmaWVyKD86XFxzKlxcLlxccypAaWRlbnRpZmllcikqLyxcbiAgb3B0aW9uTmFtZTogLyg/OkBpZGVudGlmaWVyfFxcKFxccypAZnVsbElkZW50aWZpZXJcXHMqXFwpKSg/OlxccypcXC5cXHMqQGlkZW50aWZpZXIpKi8sXG4gIG1lc3NhZ2VOYW1lOiAvQGlkZW50aWZpZXIvLFxuICBlbnVtTmFtZTogL0BpZGVudGlmaWVyLyxcbiAgbWVzc2FnZVR5cGU6IC9cXC4/XFxzKig/OkBpZGVudGlmaWVyXFxzKlxcLlxccyopKkBtZXNzYWdlTmFtZS8sXG4gIGVudW1UeXBlOiAvXFwuP1xccyooPzpAaWRlbnRpZmllclxccypcXC5cXHMqKSpAZW51bU5hbWUvLFxuICBmbG9hdExpdDogL1swLTldK1xccypcXC5cXHMqWzAtOV0qKD86QGV4cG9uZW50KT98WzAtOV0rQGV4cG9uZW50fFxcLlswLTldKyg/OkBleHBvbmVudCk/LyxcbiAgZXhwb25lbnQ6IC9bZUVdXFxzKlsrLV0/XFxzKlswLTldKy8sXG4gIGJvb2xMaXQ6IC90cnVlXFxifGZhbHNlXFxiLyxcbiAgZGVjaW1hbExpdDogL1sxLTldWzAtOV0qLyxcbiAgb2N0YWxMaXQ6IC8wWzAtN10qLyxcbiAgaGV4TGl0OiAvMFt4WF1bMC05YS1mQS1GXSsvLFxuICB0eXBlOiAvZG91YmxlfGZsb2F0fGludDMyfGludDY0fHVpbnQzMnx1aW50NjR8c2ludDMyfHNpbnQ2NHxmaXhlZDMyfGZpeGVkNjR8c2ZpeGVkMzJ8c2ZpeGVkNjR8Ym9vbHxzdHJpbmd8Ynl0ZXN8QG1lc3NhZ2VUeXBlfEBlbnVtVHlwZS8sXG4gIGtleVR5cGU6IC9pbnQzMnxpbnQ2NHx1aW50MzJ8dWludDY0fHNpbnQzMnxzaW50NjR8Zml4ZWQzMnxmaXhlZDY0fHNmaXhlZDMyfHNmaXhlZDY0fGJvb2x8c3RyaW5nLyxcbiAgdG9rZW5pemVyOiB7XG4gICAgcm9vdDogW1xuICAgICAgeyBpbmNsdWRlOiBcIkB3aGl0ZXNwYWNlXCIgfSxcbiAgICAgIFsvc3ludGF4LywgXCJrZXl3b3JkXCJdLFxuICAgICAgWy89LywgXCJvcGVyYXRvcnNcIl0sXG4gICAgICBbLzsvLCBcImRlbGltaXRlclwiXSxcbiAgICAgIFtcbiAgICAgICAgLyhcIikocHJvdG8zKShcIikvLFxuICAgICAgICBbXCJzdHJpbmcucXVvdGVcIiwgXCJzdHJpbmdcIiwgeyB0b2tlbjogXCJzdHJpbmcucXVvdGVcIiwgc3dpdGNoVG86IFwiQHRvcExldmVsLnByb3RvM1wiIH1dXG4gICAgICBdLFxuICAgICAgW1xuICAgICAgICAvKFwiKShwcm90bzIpKFwiKS8sXG4gICAgICAgIFtcInN0cmluZy5xdW90ZVwiLCBcInN0cmluZ1wiLCB7IHRva2VuOiBcInN0cmluZy5xdW90ZVwiLCBzd2l0Y2hUbzogXCJAdG9wTGV2ZWwucHJvdG8yXCIgfV1cbiAgICAgIF0sXG4gICAgICBbXG4gICAgICAgIC8uKj8vLFxuICAgICAgICB7IHRva2VuOiBcIlwiLCBzd2l0Y2hUbzogXCJAdG9wTGV2ZWwucHJvdG8yXCIgfVxuICAgICAgXVxuICAgIF0sXG4gICAgdG9wTGV2ZWw6IFtcbiAgICAgIHsgaW5jbHVkZTogXCJAd2hpdGVzcGFjZVwiIH0sXG4gICAgICB7IGluY2x1ZGU6IFwiQGNvbnN0YW50XCIgfSxcbiAgICAgIFsvPS8sIFwib3BlcmF0b3JzXCJdLFxuICAgICAgWy9bOy5dLywgXCJkZWxpbWl0ZXJcIl0sXG4gICAgICBbXG4gICAgICAgIC9AZnVsbElkZW50aWZpZXIvLFxuICAgICAgICB7XG4gICAgICAgICAgY2FzZXM6IHtcbiAgICAgICAgICAgIG9wdGlvbjogeyB0b2tlbjogXCJrZXl3b3JkXCIsIG5leHQ6IFwiQG9wdGlvbi4kUzJcIiB9LFxuICAgICAgICAgICAgZW51bTogeyB0b2tlbjogXCJrZXl3b3JkXCIsIG5leHQ6IFwiQGVudW1EZWNsLiRTMlwiIH0sXG4gICAgICAgICAgICBtZXNzYWdlOiB7IHRva2VuOiBcImtleXdvcmRcIiwgbmV4dDogXCJAbWVzc2FnZURlY2wuJFMyXCIgfSxcbiAgICAgICAgICAgIHNlcnZpY2U6IHsgdG9rZW46IFwia2V5d29yZFwiLCBuZXh0OiBcIkBzZXJ2aWNlRGVjbC4kUzJcIiB9LFxuICAgICAgICAgICAgZXh0ZW5kOiB7XG4gICAgICAgICAgICAgIGNhc2VzOiB7XG4gICAgICAgICAgICAgICAgXCIkUzI9PXByb3RvMlwiOiB7IHRva2VuOiBcImtleXdvcmRcIiwgbmV4dDogXCJAZXh0ZW5kRGVjbC4kUzJcIiB9XG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcIkBrZXl3b3Jkc1wiOiBcImtleXdvcmRcIixcbiAgICAgICAgICAgIFwiQGRlZmF1bHRcIjogXCJpZGVudGlmaWVyXCJcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIF1cbiAgICBdLFxuICAgIGVudW1EZWNsOiBbXG4gICAgICB7IGluY2x1ZGU6IFwiQHdoaXRlc3BhY2VcIiB9LFxuICAgICAgWy9AaWRlbnRpZmllci8sIFwidHlwZS5pZGVudGlmaWVyXCJdLFxuICAgICAgWy97LywgeyB0b2tlbjogXCJAYnJhY2tldHNcIiwgYnJhY2tldDogXCJAb3BlblwiLCBzd2l0Y2hUbzogXCJAZW51bUJvZHkuJFMyXCIgfV1cbiAgICBdLFxuICAgIGVudW1Cb2R5OiBbXG4gICAgICB7IGluY2x1ZGU6IFwiQHdoaXRlc3BhY2VcIiB9LFxuICAgICAgeyBpbmNsdWRlOiBcIkBjb25zdGFudFwiIH0sXG4gICAgICBbLz0vLCBcIm9wZXJhdG9yc1wiXSxcbiAgICAgIFsvOy8sIFwiZGVsaW1pdGVyXCJdLFxuICAgICAgWy9vcHRpb25cXGIvLCBcImtleXdvcmRcIiwgXCJAb3B0aW9uLiRTMlwiXSxcbiAgICAgIFsvQGlkZW50aWZpZXIvLCBcImlkZW50aWZpZXJcIl0sXG4gICAgICBbL1xcWy8sIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQG9wZW5cIiwgbmV4dDogXCJAb3B0aW9ucy4kUzJcIiB9XSxcbiAgICAgIFsvfS8sIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQGNsb3NlXCIsIG5leHQ6IFwiQHBvcFwiIH1dXG4gICAgXSxcbiAgICBtZXNzYWdlRGVjbDogW1xuICAgICAgeyBpbmNsdWRlOiBcIkB3aGl0ZXNwYWNlXCIgfSxcbiAgICAgIFsvQGlkZW50aWZpZXIvLCBcInR5cGUuaWRlbnRpZmllclwiXSxcbiAgICAgIFsvey8sIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQG9wZW5cIiwgc3dpdGNoVG86IFwiQG1lc3NhZ2VCb2R5LiRTMlwiIH1dXG4gICAgXSxcbiAgICBtZXNzYWdlQm9keTogW1xuICAgICAgeyBpbmNsdWRlOiBcIkB3aGl0ZXNwYWNlXCIgfSxcbiAgICAgIHsgaW5jbHVkZTogXCJAY29uc3RhbnRcIiB9LFxuICAgICAgWy89LywgXCJvcGVyYXRvcnNcIl0sXG4gICAgICBbLzsvLCBcImRlbGltaXRlclwiXSxcbiAgICAgIFtcbiAgICAgICAgXCIobWFwKShzKikoPClcIixcbiAgICAgICAgW1wia2V5d29yZFwiLCBcIndoaXRlXCIsIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQG9wZW5cIiwgbmV4dDogXCJAbWFwLiRTMlwiIH1dXG4gICAgICBdLFxuICAgICAgW1xuICAgICAgICAvQGlkZW50aWZpZXIvLFxuICAgICAgICB7XG4gICAgICAgICAgY2FzZXM6IHtcbiAgICAgICAgICAgIG9wdGlvbjogeyB0b2tlbjogXCJrZXl3b3JkXCIsIG5leHQ6IFwiQG9wdGlvbi4kUzJcIiB9LFxuICAgICAgICAgICAgZW51bTogeyB0b2tlbjogXCJrZXl3b3JkXCIsIG5leHQ6IFwiQGVudW1EZWNsLiRTMlwiIH0sXG4gICAgICAgICAgICBtZXNzYWdlOiB7IHRva2VuOiBcImtleXdvcmRcIiwgbmV4dDogXCJAbWVzc2FnZURlY2wuJFMyXCIgfSxcbiAgICAgICAgICAgIG9uZW9mOiB7IHRva2VuOiBcImtleXdvcmRcIiwgbmV4dDogXCJAb25lb2ZEZWNsLiRTMlwiIH0sXG4gICAgICAgICAgICBleHRlbnNpb25zOiB7XG4gICAgICAgICAgICAgIGNhc2VzOiB7XG4gICAgICAgICAgICAgICAgXCIkUzI9PXByb3RvMlwiOiB7IHRva2VuOiBcImtleXdvcmRcIiwgbmV4dDogXCJAcmVzZXJ2ZWQuJFMyXCIgfVxuICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgcmVzZXJ2ZWQ6IHsgdG9rZW46IFwia2V5d29yZFwiLCBuZXh0OiBcIkByZXNlcnZlZC4kUzJcIiB9LFxuICAgICAgICAgICAgXCIoPzpyZXBlYXRlZHxvcHRpb25hbClcIjogeyB0b2tlbjogXCJrZXl3b3JkXCIsIG5leHQ6IFwiQGZpZWxkLiRTMlwiIH0sXG4gICAgICAgICAgICByZXF1aXJlZDoge1xuICAgICAgICAgICAgICBjYXNlczoge1xuICAgICAgICAgICAgICAgIFwiJFMyPT1wcm90bzJcIjogeyB0b2tlbjogXCJrZXl3b3JkXCIsIG5leHQ6IFwiQGZpZWxkLiRTMlwiIH1cbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiJFMyPT1wcm90bzNcIjogeyB0b2tlbjogXCJAcmVtYXRjaFwiLCBuZXh0OiBcIkBmaWVsZC4kUzJcIiB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICBdLFxuICAgICAgWy9cXFsvLCB7IHRva2VuOiBcIkBicmFja2V0c1wiLCBicmFja2V0OiBcIkBvcGVuXCIsIG5leHQ6IFwiQG9wdGlvbnMuJFMyXCIgfV0sXG4gICAgICBbL30vLCB7IHRva2VuOiBcIkBicmFja2V0c1wiLCBicmFja2V0OiBcIkBjbG9zZVwiLCBuZXh0OiBcIkBwb3BcIiB9XVxuICAgIF0sXG4gICAgZXh0ZW5kRGVjbDogW1xuICAgICAgeyBpbmNsdWRlOiBcIkB3aGl0ZXNwYWNlXCIgfSxcbiAgICAgIFsvQGlkZW50aWZpZXIvLCBcInR5cGUuaWRlbnRpZmllclwiXSxcbiAgICAgIFsvey8sIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQG9wZW5cIiwgc3dpdGNoVG86IFwiQGV4dGVuZEJvZHkuJFMyXCIgfV1cbiAgICBdLFxuICAgIGV4dGVuZEJvZHk6IFtcbiAgICAgIHsgaW5jbHVkZTogXCJAd2hpdGVzcGFjZVwiIH0sXG4gICAgICB7IGluY2x1ZGU6IFwiQGNvbnN0YW50XCIgfSxcbiAgICAgIFsvOy8sIFwiZGVsaW1pdGVyXCJdLFxuICAgICAgWy8oPzpyZXBlYXRlZHxvcHRpb25hbHxyZXF1aXJlZCkvLCBcImtleXdvcmRcIiwgXCJAZmllbGQuJFMyXCJdLFxuICAgICAgWy9cXFsvLCB7IHRva2VuOiBcIkBicmFja2V0c1wiLCBicmFja2V0OiBcIkBvcGVuXCIsIG5leHQ6IFwiQG9wdGlvbnMuJFMyXCIgfV0sXG4gICAgICBbL30vLCB7IHRva2VuOiBcIkBicmFja2V0c1wiLCBicmFja2V0OiBcIkBjbG9zZVwiLCBuZXh0OiBcIkBwb3BcIiB9XVxuICAgIF0sXG4gICAgb3B0aW9uczogW1xuICAgICAgeyBpbmNsdWRlOiBcIkB3aGl0ZXNwYWNlXCIgfSxcbiAgICAgIHsgaW5jbHVkZTogXCJAY29uc3RhbnRcIiB9LFxuICAgICAgWy87LywgXCJkZWxpbWl0ZXJcIl0sXG4gICAgICBbL0BvcHRpb25OYW1lLywgXCJhbm5vdGF0aW9uXCJdLFxuICAgICAgWy9bKCldLywgXCJhbm5vdGF0aW9uLmJyYWNrZXRzXCJdLFxuICAgICAgWy89LywgXCJvcGVyYXRvclwiXSxcbiAgICAgIFsvXFxdLywgeyB0b2tlbjogXCJAYnJhY2tldHNcIiwgYnJhY2tldDogXCJAY2xvc2VcIiwgbmV4dDogXCJAcG9wXCIgfV1cbiAgICBdLFxuICAgIG9wdGlvbjogW1xuICAgICAgeyBpbmNsdWRlOiBcIkB3aGl0ZXNwYWNlXCIgfSxcbiAgICAgIFsvQG9wdGlvbk5hbWUvLCBcImFubm90YXRpb25cIl0sXG4gICAgICBbL1soKV0vLCBcImFubm90YXRpb24uYnJhY2tldHNcIl0sXG4gICAgICBbLz0vLCBcIm9wZXJhdG9yXCIsIFwiQHBvcFwiXVxuICAgIF0sXG4gICAgb25lb2ZEZWNsOiBbXG4gICAgICB7IGluY2x1ZGU6IFwiQHdoaXRlc3BhY2VcIiB9LFxuICAgICAgWy9AaWRlbnRpZmllci8sIFwiaWRlbnRpZmllclwiXSxcbiAgICAgIFsvey8sIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQG9wZW5cIiwgc3dpdGNoVG86IFwiQG9uZW9mQm9keS4kUzJcIiB9XVxuICAgIF0sXG4gICAgb25lb2ZCb2R5OiBbXG4gICAgICB7IGluY2x1ZGU6IFwiQHdoaXRlc3BhY2VcIiB9LFxuICAgICAgeyBpbmNsdWRlOiBcIkBjb25zdGFudFwiIH0sXG4gICAgICBbLzsvLCBcImRlbGltaXRlclwiXSxcbiAgICAgIFsvKEBpZGVudGlmaWVyKShcXHMqKSg9KS8sIFtcImlkZW50aWZpZXJcIiwgXCJ3aGl0ZVwiLCBcImRlbGltaXRlclwiXV0sXG4gICAgICBbXG4gICAgICAgIC9AZnVsbElkZW50aWZpZXJ8XFwuLyxcbiAgICAgICAge1xuICAgICAgICAgIGNhc2VzOiB7XG4gICAgICAgICAgICBcIkBidWlsdGluVHlwZXNcIjogXCJrZXl3b3JkXCIsXG4gICAgICAgICAgICBcIkBkZWZhdWx0XCI6IFwidHlwZS5pZGVudGlmaWVyXCJcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIF0sXG4gICAgICBbL1xcWy8sIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQG9wZW5cIiwgbmV4dDogXCJAb3B0aW9ucy4kUzJcIiB9XSxcbiAgICAgIFsvfS8sIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQGNsb3NlXCIsIG5leHQ6IFwiQHBvcFwiIH1dXG4gICAgXSxcbiAgICByZXNlcnZlZDogW1xuICAgICAgeyBpbmNsdWRlOiBcIkB3aGl0ZXNwYWNlXCIgfSxcbiAgICAgIFsvLC8sIFwiZGVsaW1pdGVyXCJdLFxuICAgICAgWy87LywgXCJkZWxpbWl0ZXJcIiwgXCJAcG9wXCJdLFxuICAgICAgeyBpbmNsdWRlOiBcIkBjb25zdGFudFwiIH0sXG4gICAgICBbL3RvXFxifG1heFxcYi8sIFwia2V5d29yZFwiXVxuICAgIF0sXG4gICAgbWFwOiBbXG4gICAgICB7IGluY2x1ZGU6IFwiQHdoaXRlc3BhY2VcIiB9LFxuICAgICAgW1xuICAgICAgICAvQGZ1bGxJZGVudGlmaWVyfFxcLi8sXG4gICAgICAgIHtcbiAgICAgICAgICBjYXNlczoge1xuICAgICAgICAgICAgXCJAYnVpbHRpblR5cGVzXCI6IFwia2V5d29yZFwiLFxuICAgICAgICAgICAgXCJAZGVmYXVsdFwiOiBcInR5cGUuaWRlbnRpZmllclwiXG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICBdLFxuICAgICAgWy8sLywgXCJkZWxpbWl0ZXJcIl0sXG4gICAgICBbLz4vLCB7IHRva2VuOiBcIkBicmFja2V0c1wiLCBicmFja2V0OiBcIkBjbG9zZVwiLCBzd2l0Y2hUbzogXCJpZGVudGlmaWVyXCIgfV1cbiAgICBdLFxuICAgIGZpZWxkOiBbXG4gICAgICB7IGluY2x1ZGU6IFwiQHdoaXRlc3BhY2VcIiB9LFxuICAgICAgW1xuICAgICAgICBcImdyb3VwXCIsXG4gICAgICAgIHtcbiAgICAgICAgICBjYXNlczoge1xuICAgICAgICAgICAgXCIkUzI9PXByb3RvMlwiOiB7IHRva2VuOiBcImtleXdvcmRcIiwgc3dpdGNoVG86IFwiQGdyb3VwRGVjbC4kUzJcIiB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICBdLFxuICAgICAgWy8oQGlkZW50aWZpZXIpKFxccyopKD0pLywgW1wiaWRlbnRpZmllclwiLCBcIndoaXRlXCIsIHsgdG9rZW46IFwiZGVsaW1pdGVyXCIsIG5leHQ6IFwiQHBvcFwiIH1dXSxcbiAgICAgIFtcbiAgICAgICAgL0BmdWxsSWRlbnRpZmllcnxcXC4vLFxuICAgICAgICB7XG4gICAgICAgICAgY2FzZXM6IHtcbiAgICAgICAgICAgIFwiQGJ1aWx0aW5UeXBlc1wiOiBcImtleXdvcmRcIixcbiAgICAgICAgICAgIFwiQGRlZmF1bHRcIjogXCJ0eXBlLmlkZW50aWZpZXJcIlxuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgXVxuICAgIF0sXG4gICAgZ3JvdXBEZWNsOiBbXG4gICAgICB7IGluY2x1ZGU6IFwiQHdoaXRlc3BhY2VcIiB9LFxuICAgICAgWy9AaWRlbnRpZmllci8sIFwiaWRlbnRpZmllclwiXSxcbiAgICAgIFtcIj1cIiwgXCJvcGVyYXRvclwiXSxcbiAgICAgIFsvey8sIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQG9wZW5cIiwgc3dpdGNoVG86IFwiQG1lc3NhZ2VCb2R5LiRTMlwiIH1dLFxuICAgICAgeyBpbmNsdWRlOiBcIkBjb25zdGFudFwiIH1cbiAgICBdLFxuICAgIHR5cGU6IFtcbiAgICAgIHsgaW5jbHVkZTogXCJAd2hpdGVzcGFjZVwiIH0sXG4gICAgICBbL0BpZGVudGlmaWVyLywgXCJ0eXBlLmlkZW50aWZpZXJcIiwgXCJAcG9wXCJdLFxuICAgICAgWy8uLywgXCJkZWxpbWl0ZXJcIl1cbiAgICBdLFxuICAgIGlkZW50aWZpZXI6IFt7IGluY2x1ZGU6IFwiQHdoaXRlc3BhY2VcIiB9LCBbL0BpZGVudGlmaWVyLywgXCJpZGVudGlmaWVyXCIsIFwiQHBvcFwiXV0sXG4gICAgc2VydmljZURlY2w6IFtcbiAgICAgIHsgaW5jbHVkZTogXCJAd2hpdGVzcGFjZVwiIH0sXG4gICAgICBbL0BpZGVudGlmaWVyLywgXCJpZGVudGlmaWVyXCJdLFxuICAgICAgWy97LywgeyB0b2tlbjogXCJAYnJhY2tldHNcIiwgYnJhY2tldDogXCJAb3BlblwiLCBzd2l0Y2hUbzogXCJAc2VydmljZUJvZHkuJFMyXCIgfV1cbiAgICBdLFxuICAgIHNlcnZpY2VCb2R5OiBbXG4gICAgICB7IGluY2x1ZGU6IFwiQHdoaXRlc3BhY2VcIiB9LFxuICAgICAgeyBpbmNsdWRlOiBcIkBjb25zdGFudFwiIH0sXG4gICAgICBbLzsvLCBcImRlbGltaXRlclwiXSxcbiAgICAgIFsvb3B0aW9uXFxiLywgXCJrZXl3b3JkXCIsIFwiQG9wdGlvbi4kUzJcIl0sXG4gICAgICBbL3JwY1xcYi8sIFwia2V5d29yZFwiLCBcIkBycGMuJFMyXCJdLFxuICAgICAgWy9cXFsvLCB7IHRva2VuOiBcIkBicmFja2V0c1wiLCBicmFja2V0OiBcIkBvcGVuXCIsIG5leHQ6IFwiQG9wdGlvbnMuJFMyXCIgfV0sXG4gICAgICBbL30vLCB7IHRva2VuOiBcIkBicmFja2V0c1wiLCBicmFja2V0OiBcIkBjbG9zZVwiLCBuZXh0OiBcIkBwb3BcIiB9XVxuICAgIF0sXG4gICAgcnBjOiBbXG4gICAgICB7IGluY2x1ZGU6IFwiQHdoaXRlc3BhY2VcIiB9LFxuICAgICAgWy9AaWRlbnRpZmllci8sIFwiaWRlbnRpZmllclwiXSxcbiAgICAgIFsvXFwoLywgeyB0b2tlbjogXCJAYnJhY2tldHNcIiwgYnJhY2tldDogXCJAb3BlblwiLCBzd2l0Y2hUbzogXCJAcmVxdWVzdC4kUzJcIiB9XSxcbiAgICAgIFsvey8sIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQG9wZW5cIiwgbmV4dDogXCJAbWV0aG9kT3B0aW9ucy4kUzJcIiB9XSxcbiAgICAgIFsvOy8sIFwiZGVsaW1pdGVyXCIsIFwiQHBvcFwiXVxuICAgIF0sXG4gICAgcmVxdWVzdDogW1xuICAgICAgeyBpbmNsdWRlOiBcIkB3aGl0ZXNwYWNlXCIgfSxcbiAgICAgIFtcbiAgICAgICAgL0BtZXNzYWdlVHlwZS8sXG4gICAgICAgIHtcbiAgICAgICAgICBjYXNlczoge1xuICAgICAgICAgICAgc3RyZWFtOiB7IHRva2VuOiBcImtleXdvcmRcIiwgbmV4dDogXCJAdHlwZS4kUzJcIiB9LFxuICAgICAgICAgICAgXCJAZGVmYXVsdFwiOiBcInR5cGUuaWRlbnRpZmllclwiXG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICBdLFxuICAgICAgWy9cXCkvLCB7IHRva2VuOiBcIkBicmFja2V0c1wiLCBicmFja2V0OiBcIkBjbG9zZVwiLCBzd2l0Y2hUbzogXCJAcmV0dXJucy4kUzJcIiB9XVxuICAgIF0sXG4gICAgcmV0dXJuczogW1xuICAgICAgeyBpbmNsdWRlOiBcIkB3aGl0ZXNwYWNlXCIgfSxcbiAgICAgIFsvcmV0dXJuc1xcYi8sIFwia2V5d29yZFwiXSxcbiAgICAgIFsvXFwoLywgeyB0b2tlbjogXCJAYnJhY2tldHNcIiwgYnJhY2tldDogXCJAb3BlblwiLCBzd2l0Y2hUbzogXCJAcmVzcG9uc2UuJFMyXCIgfV1cbiAgICBdLFxuICAgIHJlc3BvbnNlOiBbXG4gICAgICB7IGluY2x1ZGU6IFwiQHdoaXRlc3BhY2VcIiB9LFxuICAgICAgW1xuICAgICAgICAvQG1lc3NhZ2VUeXBlLyxcbiAgICAgICAge1xuICAgICAgICAgIGNhc2VzOiB7XG4gICAgICAgICAgICBzdHJlYW06IHsgdG9rZW46IFwia2V5d29yZFwiLCBuZXh0OiBcIkB0eXBlLiRTMlwiIH0sXG4gICAgICAgICAgICBcIkBkZWZhdWx0XCI6IFwidHlwZS5pZGVudGlmaWVyXCJcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIF0sXG4gICAgICBbL1xcKS8sIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQGNsb3NlXCIsIHN3aXRjaFRvOiBcIkBycGMuJFMyXCIgfV1cbiAgICBdLFxuICAgIG1ldGhvZE9wdGlvbnM6IFtcbiAgICAgIHsgaW5jbHVkZTogXCJAd2hpdGVzcGFjZVwiIH0sXG4gICAgICB7IGluY2x1ZGU6IFwiQGNvbnN0YW50XCIgfSxcbiAgICAgIFsvOy8sIFwiZGVsaW1pdGVyXCJdLFxuICAgICAgW1wib3B0aW9uXCIsIFwia2V5d29yZFwiXSxcbiAgICAgIFsvQG9wdGlvbk5hbWUvLCBcImFubm90YXRpb25cIl0sXG4gICAgICBbL1soKV0vLCBcImFubm90YXRpb24uYnJhY2tldHNcIl0sXG4gICAgICBbLz0vLCBcIm9wZXJhdG9yXCJdLFxuICAgICAgWy99LywgeyB0b2tlbjogXCJAYnJhY2tldHNcIiwgYnJhY2tldDogXCJAY2xvc2VcIiwgbmV4dDogXCJAcG9wXCIgfV1cbiAgICBdLFxuICAgIGNvbW1lbnQ6IFtcbiAgICAgIFsvW15cXC8qXSsvLCBcImNvbW1lbnRcIl0sXG4gICAgICBbL1xcL1xcKi8sIFwiY29tbWVudFwiLCBcIkBwdXNoXCJdLFxuICAgICAgW1wiXFxcXCovXCIsIFwiY29tbWVudFwiLCBcIkBwb3BcIl0sXG4gICAgICBbL1tcXC8qXS8sIFwiY29tbWVudFwiXVxuICAgIF0sXG4gICAgc3RyaW5nOiBbXG4gICAgICBbL1teXFxcXFwiXSsvLCBcInN0cmluZ1wiXSxcbiAgICAgIFsvQGVzY2FwZXMvLCBcInN0cmluZy5lc2NhcGVcIl0sXG4gICAgICBbL1xcXFwuLywgXCJzdHJpbmcuZXNjYXBlLmludmFsaWRcIl0sXG4gICAgICBbL1wiLywgeyB0b2tlbjogXCJzdHJpbmcucXVvdGVcIiwgYnJhY2tldDogXCJAY2xvc2VcIiwgbmV4dDogXCJAcG9wXCIgfV1cbiAgICBdLFxuICAgIHN0cmluZ1NpbmdsZTogW1xuICAgICAgWy9bXlxcXFwnXSsvLCBcInN0cmluZ1wiXSxcbiAgICAgIFsvQGVzY2FwZXMvLCBcInN0cmluZy5lc2NhcGVcIl0sXG4gICAgICBbL1xcXFwuLywgXCJzdHJpbmcuZXNjYXBlLmludmFsaWRcIl0sXG4gICAgICBbLycvLCB7IHRva2VuOiBcInN0cmluZy5xdW90ZVwiLCBicmFja2V0OiBcIkBjbG9zZVwiLCBuZXh0OiBcIkBwb3BcIiB9XVxuICAgIF0sXG4gICAgY29uc3RhbnQ6IFtcbiAgICAgIFtcIkBib29sTGl0XCIsIFwia2V5d29yZC5jb25zdGFudFwiXSxcbiAgICAgIFtcIkBoZXhMaXRcIiwgXCJudW1iZXIuaGV4XCJdLFxuICAgICAgW1wiQG9jdGFsTGl0XCIsIFwibnVtYmVyLm9jdGFsXCJdLFxuICAgICAgW1wiQGRlY2ltYWxMaXRcIiwgXCJudW1iZXJcIl0sXG4gICAgICBbXCJAZmxvYXRMaXRcIiwgXCJudW1iZXIuZmxvYXRcIl0sXG4gICAgICBbLyhcIihbXlwiXFxcXF18XFxcXC4pKnwnKFteJ1xcXFxdfFxcXFwuKSopJC8sIFwic3RyaW5nLmludmFsaWRcIl0sXG4gICAgICBbL1wiLywgeyB0b2tlbjogXCJzdHJpbmcucXVvdGVcIiwgYnJhY2tldDogXCJAb3BlblwiLCBuZXh0OiBcIkBzdHJpbmdcIiB9XSxcbiAgICAgIFsvJy8sIHsgdG9rZW46IFwic3RyaW5nLnF1b3RlXCIsIGJyYWNrZXQ6IFwiQG9wZW5cIiwgbmV4dDogXCJAc3RyaW5nU2luZ2xlXCIgfV0sXG4gICAgICBbL3svLCB7IHRva2VuOiBcIkBicmFja2V0c1wiLCBicmFja2V0OiBcIkBvcGVuXCIsIG5leHQ6IFwiQHByb3RvdGV4dFwiIH1dLFxuICAgICAgWy9pZGVudGlmaWVyLywgXCJpZGVudGlmaWVyXCJdXG4gICAgXSxcbiAgICB3aGl0ZXNwYWNlOiBbXG4gICAgICBbL1sgXFx0XFxyXFxuXSsvLCBcIndoaXRlXCJdLFxuICAgICAgWy9cXC9cXCovLCBcImNvbW1lbnRcIiwgXCJAY29tbWVudFwiXSxcbiAgICAgIFsvXFwvXFwvLiokLywgXCJjb21tZW50XCJdXG4gICAgXSxcbiAgICBwcm90b3RleHQ6IFtcbiAgICAgIHsgaW5jbHVkZTogXCJAd2hpdGVzcGFjZVwiIH0sXG4gICAgICB7IGluY2x1ZGU6IFwiQGNvbnN0YW50XCIgfSxcbiAgICAgIFsvQGlkZW50aWZpZXIvLCBcImlkZW50aWZpZXJcIl0sXG4gICAgICBbL1s6O10vLCBcImRlbGltaXRlclwiXSxcbiAgICAgIFsvfS8sIHsgdG9rZW46IFwiQGJyYWNrZXRzXCIsIGJyYWNrZXQ6IFwiQGNsb3NlXCIsIG5leHQ6IFwiQHBvcFwiIH1dXG4gICAgXVxuICB9XG59O1xuZXhwb3J0IHtcbiAgY29uZixcbiAgbGFuZ3VhZ2Vcbn07XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=