(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["vendors-node_modules_monaco-editor_esm_vs_basic-languages_postiats_postiats_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/postiats/postiats.js":
/*!********************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/postiats/postiats.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/postiats/postiats.ts
var conf = {
  comments: {
    lineComment: "//",
    blockComment: ["(*", "*)"]
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"],
    ["<", ">"]
  ],
  autoClosingPairs: [
    { open: '"', close: '"', notIn: ["string", "comment"] },
    { open: "{", close: "}", notIn: ["string", "comment"] },
    { open: "[", close: "]", notIn: ["string", "comment"] },
    { open: "(", close: ")", notIn: ["string", "comment"] }
  ]
};
var language = {
  tokenPostfix: ".pats",
  defaultToken: "invalid",
  keywords: [
    "abstype",
    "abst0ype",
    "absprop",
    "absview",
    "absvtype",
    "absviewtype",
    "absvt0ype",
    "absviewt0ype",
    "as",
    "and",
    "assume",
    "begin",
    "classdec",
    "datasort",
    "datatype",
    "dataprop",
    "dataview",
    "datavtype",
    "dataviewtype",
    "do",
    "end",
    "extern",
    "extype",
    "extvar",
    "exception",
    "fn",
    "fnx",
    "fun",
    "prfn",
    "prfun",
    "praxi",
    "castfn",
    "if",
    "then",
    "else",
    "ifcase",
    "in",
    "infix",
    "infixl",
    "infixr",
    "prefix",
    "postfix",
    "implmnt",
    "implement",
    "primplmnt",
    "primplement",
    "import",
    "let",
    "local",
    "macdef",
    "macrodef",
    "nonfix",
    "symelim",
    "symintr",
    "overload",
    "of",
    "op",
    "rec",
    "sif",
    "scase",
    "sortdef",
    "sta",
    "stacst",
    "stadef",
    "static",
    "staload",
    "dynload",
    "try",
    "tkindef",
    "typedef",
    "propdef",
    "viewdef",
    "vtypedef",
    "viewtypedef",
    "prval",
    "var",
    "prvar",
    "when",
    "where",
    "with",
    "withtype",
    "withprop",
    "withview",
    "withvtype",
    "withviewtype"
  ],
  keywords_dlr: [
    "$delay",
    "$ldelay",
    "$arrpsz",
    "$arrptrsize",
    "$d2ctype",
    "$effmask",
    "$effmask_ntm",
    "$effmask_exn",
    "$effmask_ref",
    "$effmask_wrt",
    "$effmask_all",
    "$extern",
    "$extkind",
    "$extype",
    "$extype_struct",
    "$extval",
    "$extfcall",
    "$extmcall",
    "$literal",
    "$myfilename",
    "$mylocation",
    "$myfunction",
    "$lst",
    "$lst_t",
    "$lst_vt",
    "$list",
    "$list_t",
    "$list_vt",
    "$rec",
    "$rec_t",
    "$rec_vt",
    "$record",
    "$record_t",
    "$record_vt",
    "$tup",
    "$tup_t",
    "$tup_vt",
    "$tuple",
    "$tuple_t",
    "$tuple_vt",
    "$break",
    "$continue",
    "$raise",
    "$showtype",
    "$vcopyenv_v",
    "$vcopyenv_vt",
    "$tempenver",
    "$solver_assert",
    "$solver_verify"
  ],
  keywords_srp: [
    "#if",
    "#ifdef",
    "#ifndef",
    "#then",
    "#elif",
    "#elifdef",
    "#elifndef",
    "#else",
    "#endif",
    "#error",
    "#prerr",
    "#print",
    "#assert",
    "#undef",
    "#define",
    "#include",
    "#require",
    "#pragma",
    "#codegen2",
    "#codegen3"
  ],
  irregular_keyword_list: [
    "val+",
    "val-",
    "val",
    "case+",
    "case-",
    "case",
    "addr@",
    "addr",
    "fold@",
    "free@",
    "fix@",
    "fix",
    "lam@",
    "lam",
    "llam@",
    "llam",
    "viewt@ype+",
    "viewt@ype-",
    "viewt@ype",
    "viewtype+",
    "viewtype-",
    "viewtype",
    "view+",
    "view-",
    "view@",
    "view",
    "type+",
    "type-",
    "type",
    "vtype+",
    "vtype-",
    "vtype",
    "vt@ype+",
    "vt@ype-",
    "vt@ype",
    "viewt@ype+",
    "viewt@ype-",
    "viewt@ype",
    "viewtype+",
    "viewtype-",
    "viewtype",
    "prop+",
    "prop-",
    "prop",
    "type+",
    "type-",
    "type",
    "t@ype",
    "t@ype+",
    "t@ype-",
    "abst@ype",
    "abstype",
    "absviewt@ype",
    "absvt@ype",
    "for*",
    "for",
    "while*",
    "while"
  ],
  keywords_types: [
    "bool",
    "double",
    "byte",
    "int",
    "short",
    "char",
    "void",
    "unit",
    "long",
    "float",
    "string",
    "strptr"
  ],
  keywords_effects: [
    "0",
    "fun",
    "clo",
    "prf",
    "funclo",
    "cloptr",
    "cloref",
    "ref",
    "ntm",
    "1"
  ],
  operators: [
    "@",
    "!",
    "|",
    "`",
    ":",
    "$",
    ".",
    "=",
    "#",
    "~",
    "..",
    "...",
    "=>",
    "=<>",
    "=/=>",
    "=>>",
    "=/=>>",
    "<",
    ">",
    "><",
    ".<",
    ">.",
    ".<>.",
    "->",
    "-<>"
  ],
  brackets: [
    { open: ",(", close: ")", token: "delimiter.parenthesis" },
    { open: "`(", close: ")", token: "delimiter.parenthesis" },
    { open: "%(", close: ")", token: "delimiter.parenthesis" },
    { open: "'(", close: ")", token: "delimiter.parenthesis" },
    { open: "'{", close: "}", token: "delimiter.parenthesis" },
    { open: "@(", close: ")", token: "delimiter.parenthesis" },
    { open: "@{", close: "}", token: "delimiter.brace" },
    { open: "@[", close: "]", token: "delimiter.square" },
    { open: "#[", close: "]", token: "delimiter.square" },
    { open: "{", close: "}", token: "delimiter.curly" },
    { open: "[", close: "]", token: "delimiter.square" },
    { open: "(", close: ")", token: "delimiter.parenthesis" },
    { open: "<", close: ">", token: "delimiter.angle" }
  ],
  symbols: /[=><!~?:&|+\-*\/\^%]+/,
  IDENTFST: /[a-zA-Z_]/,
  IDENTRST: /[a-zA-Z0-9_'$]/,
  symbolic: /[%&+-./:=@~`^|*!$#?<>]/,
  digit: /[0-9]/,
  digitseq0: /@digit*/,
  xdigit: /[0-9A-Za-z]/,
  xdigitseq0: /@xdigit*/,
  INTSP: /[lLuU]/,
  FLOATSP: /[fFlL]/,
  fexponent: /[eE][+-]?[0-9]+/,
  fexponent_bin: /[pP][+-]?[0-9]+/,
  deciexp: /\.[0-9]*@fexponent?/,
  hexiexp: /\.[0-9a-zA-Z]*@fexponent_bin?/,
  irregular_keywords: /val[+-]?|case[+-]?|addr\@?|fold\@|free\@|fix\@?|lam\@?|llam\@?|prop[+-]?|type[+-]?|view[+-@]?|viewt@?ype[+-]?|t@?ype[+-]?|v(iew)?t@?ype[+-]?|abst@?ype|absv(iew)?t@?ype|for\*?|while\*?/,
  ESCHAR: /[ntvbrfa\\\?'"\(\[\{]/,
  start: "root",
  tokenizer: {
    root: [
      { regex: /[ \t\r\n]+/, action: { token: "" } },
      { regex: /\(\*\)/, action: { token: "invalid" } },
      {
        regex: /\(\*/,
        action: { token: "comment", next: "lexing_COMMENT_block_ml" }
      },
      {
        regex: /\(/,
        action: "@brackets"
      },
      {
        regex: /\)/,
        action: "@brackets"
      },
      {
        regex: /\[/,
        action: "@brackets"
      },
      {
        regex: /\]/,
        action: "@brackets"
      },
      {
        regex: /\{/,
        action: "@brackets"
      },
      {
        regex: /\}/,
        action: "@brackets"
      },
      {
        regex: /,\(/,
        action: "@brackets"
      },
      { regex: /,/, action: { token: "delimiter.comma" } },
      { regex: /;/, action: { token: "delimiter.semicolon" } },
      {
        regex: /@\(/,
        action: "@brackets"
      },
      {
        regex: /@\[/,
        action: "@brackets"
      },
      {
        regex: /@\{/,
        action: "@brackets"
      },
      {
        regex: /:</,
        action: { token: "keyword", next: "@lexing_EFFECT_commaseq0" }
      },
      { regex: /\.@symbolic+/, action: { token: "identifier.sym" } },
      {
        regex: /\.@digit*@fexponent@FLOATSP*/,
        action: { token: "number.float" }
      },
      { regex: /\.@digit+/, action: { token: "number.float" } },
      {
        regex: /\$@IDENTFST@IDENTRST*/,
        action: {
          cases: {
            "@keywords_dlr": { token: "keyword.dlr" },
            "@default": { token: "namespace" }
          }
        }
      },
      {
        regex: /\#@IDENTFST@IDENTRST*/,
        action: {
          cases: {
            "@keywords_srp": { token: "keyword.srp" },
            "@default": { token: "identifier" }
          }
        }
      },
      { regex: /%\(/, action: { token: "delimiter.parenthesis" } },
      {
        regex: /^%{(#|\^|\$)?/,
        action: {
          token: "keyword",
          next: "@lexing_EXTCODE",
          nextEmbedded: "text/javascript"
        }
      },
      { regex: /^%}/, action: { token: "keyword" } },
      { regex: /'\(/, action: { token: "delimiter.parenthesis" } },
      { regex: /'\[/, action: { token: "delimiter.bracket" } },
      { regex: /'\{/, action: { token: "delimiter.brace" } },
      [/(')(\\@ESCHAR|\\[xX]@xdigit+|\\@digit+)(')/, ["string", "string.escape", "string"]],
      [/'[^\\']'/, "string"],
      [/"/, "string.quote", "@lexing_DQUOTE"],
      {
        regex: /`\(/,
        action: "@brackets"
      },
      { regex: /\\/, action: { token: "punctuation" } },
      {
        regex: /@irregular_keywords(?!@IDENTRST)/,
        action: { token: "keyword" }
      },
      {
        regex: /@IDENTFST@IDENTRST*[<!\[]?/,
        action: {
          cases: {
            "@keywords": { token: "keyword" },
            "@keywords_types": { token: "type" },
            "@default": { token: "identifier" }
          }
        }
      },
      {
        regex: /\/\/\/\//,
        action: { token: "comment", next: "@lexing_COMMENT_rest" }
      },
      { regex: /\/\/.*$/, action: { token: "comment" } },
      {
        regex: /\/\*/,
        action: { token: "comment", next: "@lexing_COMMENT_block_c" }
      },
      {
        regex: /-<|=</,
        action: { token: "keyword", next: "@lexing_EFFECT_commaseq0" }
      },
      {
        regex: /@symbolic+/,
        action: {
          cases: {
            "@operators": "keyword",
            "@default": "operator"
          }
        }
      },
      {
        regex: /0[xX]@xdigit+(@hexiexp|@fexponent_bin)@FLOATSP*/,
        action: { token: "number.float" }
      },
      { regex: /0[xX]@xdigit+@INTSP*/, action: { token: "number.hex" } },
      {
        regex: /0[0-7]+(?![0-9])@INTSP*/,
        action: { token: "number.octal" }
      },
      {
        regex: /@digit+(@fexponent|@deciexp)@FLOATSP*/,
        action: { token: "number.float" }
      },
      {
        regex: /@digit@digitseq0@INTSP*/,
        action: { token: "number.decimal" }
      },
      { regex: /@digit+@INTSP*/, action: { token: "number" } }
    ],
    lexing_COMMENT_block_ml: [
      [/[^\(\*]+/, "comment"],
      [/\(\*/, "comment", "@push"],
      [/\(\*/, "comment.invalid"],
      [/\*\)/, "comment", "@pop"],
      [/\*/, "comment"]
    ],
    lexing_COMMENT_block_c: [
      [/[^\/*]+/, "comment"],
      [/\*\//, "comment", "@pop"],
      [/[\/*]/, "comment"]
    ],
    lexing_COMMENT_rest: [
      [/$/, "comment", "@pop"],
      [/.*/, "comment"]
    ],
    lexing_EFFECT_commaseq0: [
      {
        regex: /@IDENTFST@IDENTRST+|@digit+/,
        action: {
          cases: {
            "@keywords_effects": { token: "type.effect" },
            "@default": { token: "identifier" }
          }
        }
      },
      { regex: /,/, action: { token: "punctuation" } },
      { regex: />/, action: { token: "@rematch", next: "@pop" } }
    ],
    lexing_EXTCODE: [
      {
        regex: /^%}/,
        action: {
          token: "@rematch",
          next: "@pop",
          nextEmbedded: "@pop"
        }
      },
      { regex: /[^%]+/, action: "" }
    ],
    lexing_DQUOTE: [
      { regex: /"/, action: { token: "string.quote", next: "@pop" } },
      {
        regex: /(\{\$)(@IDENTFST@IDENTRST*)(\})/,
        action: [{ token: "string.escape" }, { token: "identifier" }, { token: "string.escape" }]
      },
      { regex: /\\$/, action: { token: "string.escape" } },
      {
        regex: /\\(@ESCHAR|[xX]@xdigit+|@digit+)/,
        action: { token: "string.escape" }
      },
      { regex: /[^\\"]+/, action: { token: "string" } }
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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