# Code generated by codegen/python/pyemo/pygen.go; DO NOT EDIT
from typing import Any, List, Optional


def h(msg: str):
    pass


class Emo:
    zone: Optional[str]
    activate_print = True
    activate_emojis = True
    hook = h
    _has_hook = False

    def __init__(self, *args, **kwargs):
        if len(args) == 0:
            self.zone = ""
        else:
            self.zone = args[0]
        if "activate_print" in kwargs:
            self.activate_print = kwargs["activate_print"]
        if "activate_emojis" in kwargs:
            self.activate_print = kwargs["activate_emojis"]
        if "hook" in kwargs:
            self.hook = kwargs["hook"]
            self._has_hook = True

    def _get_emo_string(self, emoji: str, obj: List[Any]) -> str:
        buf = []
        if self.activate_emojis:
            buf.append(emoji)
        if self.zone:
            buf.append("[" + self.zone + "]")
        if len(obj) > 0:
            for item in obj:
                buf.append(str(item))
        return " ".join(buf)

    def emo(self, emoji: str, obj: List[Any]) -> str:
        msg = self._get_emo_string(emoji, obj)
        if self.activate_print:
            print(msg)
        if self._has_hook:
            self.hook(msg)
        return msg

    def msg(self, *args):
        print(*args)

    def sep(self) -> str:
        msg: str = "➖➖➖➖➖➖➖➖➖➖➖"
        if self.activate_print:
            print(msg)
        return msg

    def section(self, name: str) -> str:
        msg = "➖➖➖➖➖ " + name + " ➖➖➖➖➖"
        if self.activate_print:
            print(msg)
        return msg

    def section_end(self):
        return self.sep()

    def ready(self, obj: List[Any] = []):
        if len(obj) == 0:
            obj[0] = "ready"
        return self.emo("⏲️", obj)

    def info(self, *args):
        return self.emo("ℹ️", list(args))

    def warning(self, *args):
        return self.emo("🔔", list(args))

    def error(self, *args):
        return self.emo("💢", list(args))

    def query(self, *args):
        return self.emo("🗄️", list(args))

    def query_error(self, *args):
        return self.emo("🗄️", list(args))

    def encrypt(self, *args):
        return self.emo("🎼", list(args))

    def encrypt_error(self, *args):
        return self.emo("🎼", list(args))

    def decrypt(self, *args):
        return self.emo("🗝️", list(args))

    def decrypt_error(self, *args):
        return self.emo("🗝️", list(args))

    def time(self, *args):
        return self.emo("⏱️", list(args))

    def time_error(self, *args):
        return self.emo("⏱️", list(args))

    def param(self, *args):
        return self.emo("📩", list(args))

    def param_error(self, *args):
        return self.emo("📩", list(args))

    def debug(self, *args):
        return self.emo("💊", list(args))

    def state(self, *args):
        return self.emo("📢", list(args))

    def save(self, *args):
        return self.emo("💾", list(args))

    def delete(self, *args):
        return self.emo("❌", list(args))

    def data(self, *args):
        return self.emo("💼", list(args))

    def line(self, *args):
        return self.emo("➖", list(args))

    def init(self, *args):
        return self.emo("🎬", list(args))

    def update(self, *args):
        return self.emo("🆙", list(args))

    def ok(self, *args):
        return self.emo("🆗", list(args))

    def build(self, *args):
        return self.emo("🔧", list(args))

    def aconstructor(self, *args):
        return self.emo("🛠️", list(args))

    def not_found(self, *args):
        return self.emo("🚫", list(args))

    def found(self, *args):
        return self.emo("👁️‍🗨️", list(args))

    def result(self, *args):
        return self.emo("📌", list(args))

    def input(self, *args):
        return self.emo("📥", list(args))

    def output(self, *args):
        return self.emo("📤", list(args))

    def function(self, *args):
        return self.emo("🔨", list(args))

    def key(self, *args):
        return self.emo("🔑", list(args))

    def access_token(self, *args):
        return self.emo("🔑", list(args))

    def refresh_token(self, *args):
        return self.emo("🗝️", list(args))

    def transmit(self, *args):
        return self.emo("📡", list(args))

    def start(self, *args):
        return self.emo("🏁", list(args))

    def stop(self, *args):
        return self.emo("🛑", list(args))

    def arrow_in(self, *args):
        return self.emo("=>", list(args))

    def arrow_out(self, *args):
        return self.emo("<=", list(args))

    def small_arrow_in(self, *args):
        return self.emo("->", list(args))

    def small_arrow_out(self, *args):
        return self.emo("<-", list(args))

    def request_get(self, *args):
        return self.emo("🔷", list(args))

    def request_post(self, *args):
        return self.emo("🔶", list(args))
