import * as tfe from "@cdktf/provider-tfe";
import { TerraformStack, IResolvable } from "cdktf";
import { Construct, IConstruct } from "constructs";
export interface WorkspaceConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#agent_pool_id Workspace#agent_pool_id}.
     *
     * @stability stable
     */
    readonly agentPoolId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#allow_destroy_plan Workspace#allow_destroy_plan}.
     *
     * @stability stable
     */
    readonly allowDestroyPlan?: boolean | IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#auto_apply Workspace#auto_apply}.
     *
     * @stability stable
     */
    readonly autoApply?: boolean | IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#description Workspace#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#execution_mode Workspace#execution_mode}.
     *
     * @stability stable
     */
    readonly executionMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#file_triggers_enabled Workspace#file_triggers_enabled}.
     *
     * @stability stable
     */
    readonly fileTriggersEnabled?: boolean | IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#global_remote_state Workspace#global_remote_state}.
     *
     * @stability stable
     */
    readonly globalRemoteState?: boolean | IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#queue_all_runs Workspace#queue_all_runs}.
     *
     * @stability stable
     */
    readonly queueAllRuns?: boolean | IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#remote_state_consumer_ids Workspace#remote_state_consumer_ids}.
     *
     * @stability stable
     */
    readonly remoteStateConsumerIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#speculative_enabled Workspace#speculative_enabled}.
     *
     * @stability stable
     */
    readonly speculativeEnabled?: boolean | IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#ssh_key_id Workspace#ssh_key_id}.
     *
     * @stability stable
     */
    readonly sshKeyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#structured_run_output_enabled Workspace#structured_run_output_enabled}.
     *
     * @stability stable
     */
    readonly structuredRunOutputEnabled?: boolean | IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#tag_names Workspace#tag_names}.
     *
     * @stability stable
     */
    readonly tagNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#terraform_version Workspace#terraform_version}.
     *
     * @stability stable
     */
    readonly terraformVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#trigger_prefixes Workspace#trigger_prefixes}.
     *
     * @stability stable
     */
    readonly triggerPrefixes?: string[];
}
export interface RemoteBackendOptionsWorkspace {
    readonly name: string;
}
export interface RemoteBackendOptions {
    readonly hostname?: string;
    readonly organization: string;
    readonly token?: string;
    readonly workspaces: RemoteBackendOptionsWorkspace;
}
export interface BaseStackOptions {
    readonly hostname?: string;
    readonly token?: string;
    readonly sslSkipVerify?: boolean;
    readonly defaultWorkspaceConfig?: WorkspaceConfig;
}
export declare class BaseStack extends TerraformStack {
    private organizationName;
    private prefix;
    private options;
    static isBaseStack(x: any): x is BaseStack;
    static baseStackOf(construct: IConstruct): BaseStack;
    tfeProvider: tfe.TfeProvider;
    organization: tfe.DataTfeOrganization;
    constructor(scope: Construct, organizationName: string, prefix: string, options?: BaseStackOptions);
    getRemoteBackendOptions(stackName: string): RemoteBackendOptions;
    /**
     * If you want to have more control over the workspace name, you can override this method.
     */
    getWorkspaceName(stackName: string): string;
    bootstrapWorkspace(stackName: string, stackConfig?: WorkspaceConfig): tfe.Workspace;
}
export declare class Stack extends TerraformStack {
    static isMultiStackStack(x: any): x is Stack;
    workspace: tfe.Workspace;
    constructor(scope: Construct, stackName: string, config?: WorkspaceConfig);
    addDependency(dependency: TerraformStack): void;
}
