# Python Efficient Hypothesis Management (PyEHM)

[![Documentation Status](https://readthedocs.org/projects/pyehm/badge/?version=latest)](https://pyehm.readthedocs.io/en/latest/?badge=latest)
[![CircleCI](https://circleci.com/gh/sglvladi/pyehm/tree/main.svg?style=shield)](https://circleci.com/gh/sglvladi/pyehm/tree/main)
[![License](https://img.shields.io/badge/License-EPL%202.0-red.svg)](https://opensource.org/licenses/EPL-2.0)

PyEHM is a Python package that includes open-source implementations of the Efficient Hypothesis Management (EHM) 
Algorithms described in [1], [2] and **covered by the patent** [3].

> [1] Maskell, S., Briers, M. and Wright, R., 2004, August. Fast mutual exclusion. In Signal and Data Processing of 
Small Targets 2004 (Vol. 5428, pp. 526-536). International Society for Optics and Photonics
> 
> [2] Horridge, P. and Maskell, S., 2006, July. Real-time tracking of hundreds of targets with efficient exact JPDAF 
implementation. In 2006 9th International Conference on Information Fusion (pp. 1-8). IEEE 
> 
> [3] Maskell, S., 2003, July. Signal Processing with Reduced Combinatorial Complexity. Patent Reference:0315349.1

## Documentation
Please see the [PyEHM documentation](https://pyehm.readthedocs.io/) for installation instructions, API references and 
usage examples.

## License
PyEHM is licenced under Eclipse Public License 2.0. See [License](LICENSE) for more details.

This software is the property of [QinetiQ Limited](https://www.qinetiq.com/en/) and any requests for use of the
software for commercial use or other use outside of the Eclipse Public Licence should be made to QinetiQ Limited.

The current QinetiQ contact is Richard Lane (rlane1 [at] qinetiq [dot] com).
